/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.EntityAnimal;
import net.minecraft.core.entity.animal.EntityWaterAnimal;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet38EntityStatus;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet42EntityTagData;
import net.minecraft.core.net.packet.Packet54PlayNoteBlock;
import net.minecraft.core.net.packet.Packet60Explosion;
import net.minecraft.core.net.packet.Packet71Weather;
import net.minecraft.core.net.packet.Packet73WeatherStatus;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pathfinder.IdHashMap;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.chunk.provider.ChunkProviderServer;

public class WorldServer
extends World {
    public ChunkProviderServer chunkProviderServer;
    public boolean field_819_z = false;
    public boolean levelSaving;
    private MinecraftServer mcServer;
    private final IdHashMap field_20912_E;
    private long lastWeatherSend = System.currentTimeMillis();

    public WorldServer(MinecraftServer minecraftserver, LevelStorage isavehandler, String name, int dimensionId, WorldType worldType, long seed) {
        super(isavehandler, name, seed, Dimension.getDimensionList().get(dimensionId), worldType);
        this.field_20912_E = new IdHashMap();
        this.mcServer = minecraftserver;
    }

    @Override
    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        if (!this.mcServer.spawnPeacefulMobs && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
            entity.remove();
        }
        if (entity.passenger == null || !(entity.passenger instanceof EntityPlayer)) {
            super.updateEntityWithOptionalForce(entity, flag);
        }
    }

    public void func_12017_b(Entity entity, boolean flag) {
        super.updateEntityWithOptionalForce(entity, flag);
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        IChunkLoader ichunkloader = this.saveHandler.getChunkLoader(this.dimension);
        this.chunkProviderServer = (ChunkProviderServer)Global.accessor.createChunkProvider(this, ichunkloader);
        return this.chunkProviderServer;
    }

    public List<TileEntity> getTileEntityList(int i, int j, int k, int l, int i1, int j1) {
        ArrayList<TileEntity> arraylist = new ArrayList<TileEntity>();
        for (int k1 = 0; k1 < this.loadedTileEntityList.size(); ++k1) {
            TileEntity tileentity = (TileEntity)this.loadedTileEntityList.get(k1);
            if (tileentity.x < i || tileentity.y < j || tileentity.z < k || tileentity.x >= l || tileentity.y >= i1 || tileentity.z >= j1) continue;
            arraylist.add(tileentity);
        }
        return arraylist;
    }

    @Override
    public boolean canMineBlock(EntityPlayer entityplayer, int i, int j, int k) {
        int i1;
        int l = (int)MathHelper.abs(i - this.levelData.getSpawnX());
        if (l > (i1 = (int)MathHelper.abs(k - this.levelData.getSpawnZ()))) {
            i1 = l;
        }
        return i1 > 16 || this.mcServer.playerList.isOp(entityplayer.username);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (entity == null) {
            return;
        }
        this.field_20912_E.add(entity.id, entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (entity == null) {
            return;
        }
        this.field_20912_E.remove(entity.id);
    }

    @Override
    protected void updateSleepingPlayers() {
        if (this.areEnoughPlayersFullyAsleep()) {
            boolean wasInterrupted = false;
            if (this.spawnHostileMobs && this.difficultySetting >= 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                wasInterrupted = SpawnerMobs.performSleepSpawning(this, this.players);
            }
            if (!wasInterrupted) {
                if (MinecraftServer.getInstance() != null && this.players.size() > 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                    EntityPlayer player = null;
                    for (EntityPlayer player2 : this.players) {
                        if (!player2.isPlayerFullyAsleep()) continue;
                        player = player2;
                    }
                    if (player != null) {
                        MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new Packet3Chat(TextFormatting.YELLOW + player.getDisplayName() + TextFormatting.ORANGE + " went to sleep. Sweet dreams!"), this.dimension.id);
                    }
                }
                long timePlusOneDay = this.levelData.getWorldTime() + 24000L;
                this.levelData.setWorldTime(timePlusOneDay - timePlusOneDay % 24000L + (long)this.worldType.getSunriseTick(this) + 1000L);
                this.wakeUpAllPlayers();
            }
        }
    }

    @Override
    public void updateEnoughPlayersSleepingFlag(EntityPlayer player) {
        this.enoughPlayersSleeping = false;
        if (this.players.size() > 0) {
            int playersSleeping = 0;
            int req = this.getPlayersRequiredToSkipNight();
            for (EntityPlayer p : this.players) {
                if (!p.isPlayerSleeping()) continue;
                ++playersSleeping;
            }
            if (playersSleeping >= req) {
                this.enoughPlayersSleeping = true;
            }
            if (MinecraftServer.getInstance() != null && player != null && this.players.size() > 1 && req > 1) {
                int moreReq = req - playersSleeping;
                if (player.isPlayerSleeping()) {
                    MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new Packet3Chat(TextFormatting.YELLOW + player.username + TextFormatting.ORANGE + " went to bed."), this.dimension.id);
                } else {
                    MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new Packet3Chat(TextFormatting.YELLOW + player.username + TextFormatting.ORANGE + " has left their bed."), this.dimension.id);
                }
                if (moreReq > 0) {
                    if (moreReq > 1) {
                        MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new Packet3Chat(TextFormatting.LIGHT_GRAY + "" + moreReq + " more players are required to sleep to skip to daytime"), this.dimension.id);
                    } else {
                        MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new Packet3Chat(TextFormatting.LIGHT_GRAY + "1 more player is required to sleep to skip to daytime"), this.dimension.id);
                    }
                }
            }
        }
    }

    public Entity func_6158_a(int i) {
        return (Entity)this.field_20912_E.get(i);
    }

    @Override
    public boolean addWeatherEffect(Entity entity) {
        if (super.addWeatherEffect(entity)) {
            this.mcServer.playerList.sendPacketToPlayersAroundPoint(entity.x, entity.y, entity.z, 512.0, this.dimension.id, new Packet71Weather(entity));
            return true;
        }
        return false;
    }

    @Override
    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
        Packet38EntityStatus packet38entitystatus = new Packet38EntityStatus(entityId.id, entityStatus);
        this.mcServer.getEntityTracker(this.dimension.id).sendPacketToTrackedPlayersAndTrackedEntity(entityId, packet38entitystatus);
    }

    @Override
    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
        Packet38EntityStatus packet38entitystatus = new Packet38EntityStatus(entityId.id, entityStatus, attackedAtYaw);
        this.mcServer.getEntityTracker(this.dimension.id).sendPacketToTrackedPlayersAndTrackedEntity(entityId, packet38entitystatus);
    }

    @Override
    public void sendTrackedEntityDataPacket(Entity entity) {
        Packet42EntityTagData packet42entitytagdata = new Packet42EntityTagData(entity);
        this.mcServer.getEntityTracker(this.dimension.id).sendPacketToTrackedPlayersAndTrackedEntity(entity, packet42entitytagdata);
    }

    @Override
    public Explosion createExplosion(Entity entity, double d, double d1, double d2, float f) {
        return this.newExplosion(entity, d, d1, d2, f, false, false);
    }

    @Override
    public Explosion newExplosion(Entity entity, double d, double d1, double d2, float f, boolean flag, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, d, d1, d2, f) : new ExplosionCannonball(this, entity, d, d1, d2, f);
        explosion.isFlaming = flag;
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        this.mcServer.playerList.sendPacketToPlayersAroundPoint(d, d1, d2, 64.0, this.dimension.id, new Packet60Explosion(d, d1, d2, f, explosion.destroyedBlockPositions, isCannonBall));
        return explosion;
    }

    @Override
    public void triggerEvent(int i, int j, int k, int index, int data) {
        super.triggerEvent(i, j, k, index, data);
        this.mcServer.playerList.sendPacketToPlayersAroundPoint(i, j, k, 64.0, this.dimension.id, new Packet54PlayNoteBlock(i, j, k, index, data));
    }

    public void func_30006_w() {
        this.saveHandler.checkSessionLock();
    }

    @Override
    public void tick() {
        super.tick();
        if (System.currentTimeMillis() - this.lastWeatherSend > 1000L) {
            this.mcServer.playerList.sendPacketToAllPlayers(new Packet73WeatherStatus(this.dimension.id, this.getCurrentWeather() != null ? this.getCurrentWeather().weatherId : -1, this.weatherManager.getNextWeather() != null ? this.weatherManager.getNextWeather().weatherId : -1, this.weatherManager.getWeatherDuration(), this.weatherManager.getWeatherIntensity(), this.weatherManager.getWeatherPower()));
            this.lastWeatherSend = System.currentTimeMillis();
        }
    }
}

