/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.b100.json.element.JsonEntry;
import com.b100.json.element.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackException;
import net.minecraft.client.util.helper.TexturePackJsonHelper;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.SkinVariantList;

public class ClientSkinVariantList
extends SkinVariantList {
    private final Minecraft mc;
    private final Map<String, Integer> entitySkinCounts = new HashMap<String, Integer>();

    public ClientSkinVariantList(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @Override
    public int getNumSkinsForEntity(Class<? extends Entity> entityClass) {
        Integer count = this.entitySkinCounts.get(entityClass.getName());
        return count != null ? count : 1;
    }

    public void refresh(List<Throwable> errors) {
        this.entitySkinCounts.clear();
        this.load(this.mc.texturePackList.getDefaultTexturePack(), errors);
        if (this.mc.texturePackList.selectedTexturePack != this.mc.texturePackList.getDefaultTexturePack() && this.mc.texturePackList.selectedTexturePack.hasFile("/mob/variants.json")) {
            this.load(this.mc.texturePackList.selectedTexturePack, errors);
        }
    }

    public void load(TexturePack texturePack, List<Throwable> errors) {
        try {
            JsonObject rootObject = TexturePackJsonHelper.readJsonObject(texturePack, "/mob/variants.json");
            try {
                if (rootObject.has("replace") && rootObject.getBoolean("replace")) {
                    this.entitySkinCounts.clear();
                }
                JsonObject variants = TexturePackJsonHelper.getObject(rootObject, "variants");
                for (JsonEntry entry : variants) {
                    String key = entry.name;
                    JsonObject value = entry.value.getAsObject();
                    int numSkins = Math.max(1, value.getInt("numSkins"));
                    this.entitySkinCounts.put(key, numSkins);
                }
            }
            catch (Exception e) {
                throw new TexturePackException("Error in variants.json", e);
            }
        }
        catch (Exception e) {
            errors.add(e);
            this.entitySkinCounts.clear();
        }
    }

    public void print() {
        System.out.println("Skin Variants: ");
        for (String key : this.entitySkinCounts.keySet()) {
            System.out.println("    " + key + " : " + this.entitySkinCounts.get(key));
        }
    }
}

