/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.core.block.entity.TileEntityBlastFurnace;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.ContainerFurnace;
import net.minecraft.core.player.inventory.InventoryPlayer;
import org.lwjgl.opengl.GL11;

public class GuiFurnace
extends GuiContainer {
    private final TileEntityFurnace furnaceInventory;

    public GuiFurnace(InventoryPlayer inventoryplayer, TileEntityFurnace tileentityfurnace) {
        super(new ContainerFurnace(inventoryplayer, tileentityfurnace));
        this.furnaceInventory = tileentityfurnace;
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        I18n i18n = I18n.getInstance();
        if (this.furnaceInventory instanceof TileEntityBlastFurnace) {
            this.fontRenderer.drawString(i18n.translateKey("gui.furnace.blast.label.blast_furnace"), 60, 6, 0x404040);
        } else {
            this.fontRenderer.drawString(i18n.translateKey("gui.furnace.label.furnace"), 60, 6, 0x404040);
        }
        this.fontRenderer.drawString(i18n.translateKey("gui.furnace.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        int guiTexture = this.furnaceInventory instanceof TileEntityBlastFurnace ? this.mc.renderEngine.getTexture("/gui/blastfurnace.png") : this.mc.renderEngine.getTexture("/gui/furnace.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(guiTexture);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.furnaceInventory.isBurning()) {
            if (this.furnaceInventory instanceof TileEntityBlastFurnace) {
                int fireHeight = this.furnaceInventory.getBurnTimeRemainingScaled(14);
                this.drawTexturedModalRect(x + 56, y + 35 + 14 - fireHeight, 176, 14 - fireHeight, 14, fireHeight + 2);
                int arrowWidth = this.furnaceInventory.getCookProgressScaled(24);
                this.drawTexturedModalRect(x + 79, y + 34, 176, 15, arrowWidth + 1, 16);
            } else {
                int fireHeight = this.furnaceInventory.getBurnTimeRemainingScaled(12);
                this.drawTexturedModalRect(x + 56, y + 36 + 12 - fireHeight, 176, 12 - fireHeight, 14, fireHeight + 2);
                int arrowWidth = this.furnaceInventory.getCookProgressScaled(24);
                this.drawTexturedModalRect(x + 79, y + 34, 176, 14, arrowWidth + 1, 16);
            }
        }
    }

    @Override
    public void guiSpecificControllerInput(ControllerInput controller) {
        controller.craftingGuiHandler.handleFurnace(this);
    }
}

