/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumArt;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPaintingPicker
extends GuiScreen {
    private final EntityPlayer player;
    private final List<ArtEntry> artEntries = new ArrayList<ArtEntry>();
    private EnumArt centerArt = EnumArt.Kebab;
    private int tallestSize = 0;

    public GuiPaintingPicker(EntityPlayer player) {
        this.player = player;
        for (EnumArt art : EnumArt.values()) {
            if (art.sizeY <= this.tallestSize) continue;
            this.tallestSize = art.sizeY;
        }
    }

    @Override
    public void init() {
        super.init();
        this.centerArt = this.player.getSelectedArt();
        this.updateArtEntries();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        super.drawScreen(mouseX, mouseY, partialTick);
        float dWheel = Mouse.getDWheel();
        if (dWheel < 0.0f) {
            this.centerArt = EnumArt.getNext(this.centerArt);
            this.updateArtEntries();
        } else if (dWheel > 0.0f) {
            this.centerArt = EnumArt.getPrevious(this.centerArt);
            this.updateArtEntries();
        }
        this.drawPaintings(this.width, this.height, mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int scale = this.getScale(this.width, this.height);
        if (mouseButton == 0) {
            for (ArtEntry artEntry : this.artEntries) {
                if (mouseX < artEntry.x || mouseX > artEntry.x + artEntry.art.sizeX * scale || mouseY < artEntry.y || mouseY > artEntry.y + artEntry.art.sizeY * scale) continue;
                this.mc.playerController.setPaintingType(artEntry.art);
                this.mc.displayGuiScreen(null);
                break;
            }
        }
    }

    private void updateArtEntries() {
        float alpha;
        int pCenterY;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int scale = this.getScale(this.width, this.height);
        int offsetX = 32 * scale;
        int artGap = 2;
        this.artEntries.clear();
        this.artEntries.add(new ArtEntry(this.centerArt, centerX - offsetX, centerY - this.centerArt.sizeY / 2 * scale, 1.0f));
        EnumArt currentArt = EnumArt.getNext(this.centerArt);
        int dy = (this.centerArt.sizeY / 2 + artGap) * scale + 22;
        while (currentArt != this.centerArt) {
            pCenterY = dy;
            alpha = 1.0f - (float)pCenterY / ((float)this.height / 2.0f);
            this.artEntries.add(new ArtEntry(currentArt, centerX - offsetX, centerY + dy, alpha * 0.75f));
            dy += (currentArt.sizeY + artGap) * scale;
            currentArt = EnumArt.getNext(currentArt);
        }
        currentArt = EnumArt.getPrevious(this.centerArt);
        dy = -(this.centerArt.sizeY / 2) * scale;
        while (currentArt != this.centerArt) {
            pCenterY = (dy -= (currentArt.sizeY + artGap) * scale) + currentArt.sizeY * scale;
            alpha = 1.0f - (float)(-pCenterY) / ((float)this.height / 2.0f);
            this.artEntries.add(new ArtEntry(currentArt, centerX - offsetX, centerY + dy, alpha * 0.75f));
            currentArt = EnumArt.getPrevious(currentArt);
        }
    }

    private void drawPaintings(int screenWidth, int screenHeight, int mouseX, int mouseY) {
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int scale = this.getScale(screenWidth, screenHeight);
        int offsetX = 32 * scale;
        GL11.glEnable((int)3553);
        this.drawString(this.fontRenderer, this.centerArt.title, centerX - offsetX, centerY + this.centerArt.sizeY / 2 * scale + 4, -1);
        this.drawString(this.fontRenderer, this.centerArt.artist, centerX - offsetX, centerY + this.centerArt.sizeY / 2 * scale + 16, 0x7F7F7F7F);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (ArtEntry entry : this.artEntries) {
            if (!(entry.alpha > 0.0f)) continue;
            if (mouseX > entry.x && mouseX < entry.x + entry.art.sizeX * scale && mouseY > entry.y && mouseY < entry.y + entry.art.sizeY * scale) {
                GL11.glDisable((int)3553);
                this.drawRectWidthHeight(entry.x - scale, entry.y - scale, (entry.art.sizeX + 2) * scale, (entry.art.sizeY + 2) * scale, -1);
                GL11.glEnable((int)3553);
            }
            this.drawPainting(entry.art, entry.x, entry.y, entry.art.sizeX, entry.art.sizeY, entry.alpha);
        }
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawPainting(EnumArt art, int x, int y, int width, int height, float alpha) {
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/art/kz.png"));
        int scale = this.getScale(this.width, this.height);
        this.drawTexturedModalRectPainting(x, y, art.offsetX, art.offsetY, width * scale, height * scale, width, height, alpha);
    }

    public void drawTexturedModalRectPainting(int x, int y, int u, int v, int width, int height, int uvWidth, int uvHeight, float alpha) {
        float uScale = 0.001953125f;
        float vScale = 0.001953125f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, alpha);
        tessellator.addVertexWithUV(x, y + height, this.zLevel, (float)u * uScale, (float)(v + uvHeight) * vScale);
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, (float)(u + uvWidth) * uScale, (float)(v + uvHeight) * vScale);
        tessellator.addVertexWithUV(x + width, y, this.zLevel, (float)(u + uvWidth) * uScale, (float)v * vScale);
        tessellator.addVertexWithUV(x, y, this.zLevel, (float)u * uScale, (float)v * vScale);
        tessellator.draw();
    }

    public int getScale(int width, int height) {
        return Math.min((int)((float)height * 0.9f / (float)this.tallestSize), this.mc.resolution.scale);
    }

    private static final class ArtEntry {
        public final EnumArt art;
        public final int x;
        public final int y;
        public final float alpha;

        public ArtEntry(EnumArt art, int x, int y, float alpha) {
            this.art = art;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

