/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiTexturedButton
extends GuiButton {
    private final String texturePath;
    private int u;
    private int v;

    public GuiTexturedButton(int id, String texturePath, int xPosition, int yPosition, int u, int v, int width, int height) {
        super(id, xPosition, yPosition, width, height, "");
        this.texturePath = texturePath;
        this.u = u;
        this.v = v;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        boolean isHovered;
        if (!this.visible) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture(this.texturePath));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = isHovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        if (!this.enabled) {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, this.u, this.v, this.width, this.height);
        } else if (!isHovered) {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, this.u, this.v + this.height, this.width, this.height);
        } else {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, this.u, this.v + this.height * 2, this.width, this.height);
        }
        this.mouseDragged(mc, mouseX, mouseY);
    }
}

