/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.hud.Layout;
import net.minecraft.client.gui.hud.MovableHudComponent;
import net.minecraft.core.item.ItemBucketIceCream;
import net.minecraft.core.item.ItemFood;
import org.lwjgl.opengl.GL11;

public class HealthBarComponent
extends MovableHudComponent {
    private final Random random = new Random();

    public HealthBarComponent(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.playerController.canHurtPlayer() && !mc.thePlayer.getGamemode().isPlayerInvulnerable() && mc.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void render(Minecraft mc, GuiIngame gui, int xSizeScreen, int ySizeScreen, float partialTick) {
        boolean heartsFlash;
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/gui/icons.png"));
        GL11.glDisable((int)3042);
        boolean bl = heartsFlash = mc.thePlayer.heartsFlashTime / 3 % 2 == 1;
        if (mc.thePlayer.heartsFlashTime < 10) {
            heartsFlash = false;
        }
        int health = mc.thePlayer.getHealth();
        int prevHealth = mc.thePlayer.prevHealth;
        this.random.setSeed((long)gui.updateCounter * 312871L);
        for (int i = 0; i < 10; ++i) {
            int heartOffset = 0;
            if (heartsFlash) {
                heartOffset = 1;
            }
            int xHeart = x + i * 8;
            int yHeart = y;
            if (health <= 4) {
                yHeart += this.random.nextInt(2);
            }
            gui.drawTexturedModalRect(xHeart, yHeart, 16 + heartOffset * 9, 0, 9, 9);
            if (heartsFlash) {
                if (i * 2 + 1 < prevHealth) {
                    gui.drawTexturedModalRect(xHeart, yHeart, 70, 0, 9, 9);
                }
                if (i * 2 + 1 == prevHealth) {
                    gui.drawTexturedModalRect(xHeart, yHeart, 79, 0, 9, 9);
                }
            }
            if (i * 2 + 1 < health) {
                gui.drawTexturedModalRect(xHeart, yHeart, 52, 0, 9, 9);
            }
            if (i * 2 + 1 == health) {
                gui.drawTexturedModalRect(xHeart, yHeart, 61, 0, 9, 9);
            }
            if (mc.thePlayer.inventory.getCurrentItem() == null || !(mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood) && !(mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemBucketIceCream) || !((Boolean)mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) continue;
            int healing = 0;
            healing = mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood ? ((ItemFood)mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount() : ((ItemBucketIceCream)mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount();
            if (i * 2 + 1 < health) continue;
            if (i * 2 + 1 == health) {
                gui.drawTexturedModalRect(xHeart, yHeart, 106, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 < health + healing) {
                gui.drawTexturedModalRect(xHeart, yHeart, 88, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health + healing) continue;
            gui.drawTexturedModalRect(xHeart, yHeart, 97, 0, 9, 9);
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/gui/icons.png"));
        GL11.glDisable((int)3042);
        int health = 11;
        for (int i = 0; i < 10; ++i) {
            int xHeart = x + i * 8;
            gui.drawTexturedModalRect(xHeart, y, 16, 0, 9, 9);
            if (i * 2 + 1 < health) {
                gui.drawTexturedModalRect(xHeart, y, 52, 0, 9, 9);
            }
            if (i * 2 + 1 != health) continue;
            gui.drawTexturedModalRect(xHeart, y, 61, 0, 9, 9);
        }
    }
}

