/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import com.b100.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityPickupFX;
import net.minecraft.client.entity.player.EntityClientPlayerMP;
import net.minecraft.client.entity.player.EntityOtherPlayerMP;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.GuiConnectFailed;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.guidebook.GuiGuidebook;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.player.controller.PlayerControllerMP;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityBlastFurnace;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.crafting.legacy.CraftingManager;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityBobber;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityTNT;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityArrowGolden;
import net.minecraft.core.entity.projectile.EntityArrowPurple;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.entity.projectile.EntityEgg;
import net.minecraft.core.entity.projectile.EntityFireball;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet100OpenWindow;
import net.minecraft.core.net.packet.Packet101CloseWindow;
import net.minecraft.core.net.packet.Packet103SetSlot;
import net.minecraft.core.net.packet.Packet104WindowItems;
import net.minecraft.core.net.packet.Packet105UpdateProgressbar;
import net.minecraft.core.net.packet.Packet106Transaction;
import net.minecraft.core.net.packet.Packet10Flying;
import net.minecraft.core.net.packet.Packet131MapData;
import net.minecraft.core.net.packet.Packet132SetMobSpawner;
import net.minecraft.core.net.packet.Packet136SendKey;
import net.minecraft.core.net.packet.Packet138PlayerList;
import net.minecraft.core.net.packet.Packet140TileEntityData;
import net.minecraft.core.net.packet.Packet142OpenFlagWindow;
import net.minecraft.core.net.packet.Packet143PhotoMode;
import net.minecraft.core.net.packet.Packet16BlockItemSwitch;
import net.minecraft.core.net.packet.Packet17Sleep;
import net.minecraft.core.net.packet.Packet18Animation;
import net.minecraft.core.net.packet.Packet1Login;
import net.minecraft.core.net.packet.Packet200Statistic;
import net.minecraft.core.net.packet.Packet201Ids;
import net.minecraft.core.net.packet.Packet20NamedEntitySpawn;
import net.minecraft.core.net.packet.Packet21PickupSpawn;
import net.minecraft.core.net.packet.Packet22Collect;
import net.minecraft.core.net.packet.Packet23VehicleSpawn;
import net.minecraft.core.net.packet.Packet24MobSpawn;
import net.minecraft.core.net.packet.Packet250CustomPayload;
import net.minecraft.core.net.packet.Packet255KickDisconnect;
import net.minecraft.core.net.packet.Packet25EntityPainting;
import net.minecraft.core.net.packet.Packet26BoatControl;
import net.minecraft.core.net.packet.Packet28EntityVelocity;
import net.minecraft.core.net.packet.Packet29DestroyEntity;
import net.minecraft.core.net.packet.Packet2Handshake;
import net.minecraft.core.net.packet.Packet30Entity;
import net.minecraft.core.net.packet.Packet34EntityTeleport;
import net.minecraft.core.net.packet.Packet35EntityNickname;
import net.minecraft.core.net.packet.Packet38EntityStatus;
import net.minecraft.core.net.packet.Packet39AttachEntity;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet40EntityMetadata;
import net.minecraft.core.net.packet.Packet41EntityPlayerGamemode;
import net.minecraft.core.net.packet.Packet42EntityTagData;
import net.minecraft.core.net.packet.Packet4UpdateTime;
import net.minecraft.core.net.packet.Packet50PreChunk;
import net.minecraft.core.net.packet.Packet51MapChunk;
import net.minecraft.core.net.packet.Packet52MultiBlockChange;
import net.minecraft.core.net.packet.Packet53BlockChange;
import net.minecraft.core.net.packet.Packet54PlayNoteBlock;
import net.minecraft.core.net.packet.Packet5PlayerInventory;
import net.minecraft.core.net.packet.Packet60Explosion;
import net.minecraft.core.net.packet.Packet61PlaySoundEffect;
import net.minecraft.core.net.packet.Packet62PlaySoundDirect;
import net.minecraft.core.net.packet.Packet63SpawnParticleEffect;
import net.minecraft.core.net.packet.Packet6SpawnPosition;
import net.minecraft.core.net.packet.Packet70Bed;
import net.minecraft.core.net.packet.Packet71Weather;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.core.net.packet.Packet73WeatherStatus;
import net.minecraft.core.net.packet.Packet74GameRule;
import net.minecraft.core.net.packet.Packet75RecipeSync;
import net.minecraft.core.net.packet.Packet8UpdateHealth;
import net.minecraft.core.net.packet.Packet9Respawn;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.InventoryBasic;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.weather.Weather;

public class NetClientHandler
extends NetHandler {
    private boolean disconnected = false;
    private final NetworkManager netManager;
    public String field_1209_a;
    private final Minecraft mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    public SavedDataStorage savedDataStorage;
    public List<PlayerProfile> players;
    public HashMap<String, String> playerList = new HashMap();
    Random rand;

    public NetClientHandler(Minecraft minecraft, String host, int port) throws UnknownHostException, IOException {
        this.savedDataStorage = new SavedDataStorage(null);
        this.rand = new Random();
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(host), port);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.players = new ArrayList<PlayerProfile>();
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public int findPlayerInList(PlayerProfile playerProfile) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!this.players.get((int)i).playerName.equals(playerProfile.playerName)) continue;
            return i;
        }
        return -1;
    }

    public void addPlayer(PlayerProfile playerProfile) {
        this.players.add(playerProfile);
    }

    public PlayerProfile getPlayer(String username) {
        for (PlayerProfile player : this.players) {
            if (!player.playerName.equals(username)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(int index) {
        this.players.remove(index);
    }

    @Override
    public void handleLogin(Packet1Login packet1login) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statsCounter.addValueToStat(StatList.joinMultiplayerStat, 1);
        this.worldClient = new WorldClient(this.mc, this, packet1login.worldSeed, packet1login.dimensionId, packet1login.worldTypeId);
        this.worldClient.isClientSide = true;
        this.mc.changeWorld(this.worldClient);
        this.mc.thePlayer.dimension = packet1login.dimensionId;
        this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        this.mc.thePlayer.id = packet1login.playerEntityIdAndProtocolVersion;
        NetworkManager.PACKET_DELAY = packet1login.packetDelay;
        Registries.RECIPES = new RecipeRegistry();
        CraftingManager.getInstance().reset();
        CraftingManager.getInstance().init();
    }

    @Override
    public void handlePickupSpawn(Packet21PickupSpawn packet21pickupspawn) {
        double d = (double)packet21pickupspawn.xPosition / 32.0;
        double d1 = (double)packet21pickupspawn.yPosition / 32.0;
        double d2 = (double)packet21pickupspawn.zPosition / 32.0;
        EntityItem entityitem = new EntityItem(this.worldClient, d, d1, d2, new ItemStack(packet21pickupspawn.itemID, packet21pickupspawn.count, packet21pickupspawn.itemDamage, packet21pickupspawn.tag));
        entityitem.xd = (double)packet21pickupspawn.rotation / 128.0;
        entityitem.yd = (double)packet21pickupspawn.pitch / 128.0;
        entityitem.zd = (double)packet21pickupspawn.roll / 128.0;
        entityitem.serverPosX = packet21pickupspawn.xPosition;
        entityitem.serverPosY = packet21pickupspawn.yPosition;
        entityitem.serverPosZ = packet21pickupspawn.zPosition;
        this.worldClient.func_712_a(packet21pickupspawn.entityId, entityitem);
    }

    @Override
    public void handleVehicleSpawn(Packet23VehicleSpawn packet23vehiclespawn) {
        double d = (double)packet23vehiclespawn.xPosition / 32.0;
        double d1 = (double)packet23vehiclespawn.yPosition / 32.0;
        double d2 = (double)packet23vehiclespawn.zPosition / 32.0;
        Entity obj = null;
        if (packet23vehiclespawn.type == 10) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 0);
        }
        if (packet23vehiclespawn.type == 11) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 1);
        }
        if (packet23vehiclespawn.type == 12) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 2);
        }
        if (packet23vehiclespawn.type == 90) {
            obj = new EntityBobber(this.worldClient, d, d1, d2);
        }
        if (packet23vehiclespawn.type == 60) {
            obj = packet23vehiclespawn.arrowType == 2 ? new EntityArrowGolden((World)this.worldClient, d, d1, d2) : (packet23vehiclespawn.arrowType == 1 ? new EntityArrowPurple((World)this.worldClient, d, d1, d2) : new EntityArrow(this.worldClient, d, d1, d2, packet23vehiclespawn.arrowType));
        }
        if (packet23vehiclespawn.type == 61) {
            obj = new EntitySnowball(this.worldClient, d, d1, d2);
        }
        if (packet23vehiclespawn.type == 62) {
            obj = new EntityEgg(this.worldClient, d, d1, d2);
        }
        if (packet23vehiclespawn.type == 63) {
            obj = new EntityFireball(this.worldClient, d, d1, d2, (double)packet23vehiclespawn.field_28047_e / 8000.0, (double)packet23vehiclespawn.field_28046_f / 8000.0, (double)packet23vehiclespawn.field_28045_g / 8000.0);
            packet23vehiclespawn.field_28044_i = 0;
        }
        if (packet23vehiclespawn.type == 64) {
            obj = new EntityPebble(this.worldClient, d, d1, d2);
        }
        if (packet23vehiclespawn.type == 1) {
            obj = new EntityBoat(this.worldClient, d, d1, d2);
        }
        if (packet23vehiclespawn.type == 50) {
            obj = new EntityTNT(this.worldClient, d, d1, d2);
        }
        if (packet23vehiclespawn.type == 70) {
            obj = new EntityFallingSand(this.worldClient, d, d1, d2, Block.sand.id);
        }
        if (packet23vehiclespawn.type == 71) {
            obj = new EntityFallingSand(this.worldClient, d, d1, d2, Block.gravel.id);
        }
        if (packet23vehiclespawn.type == 73) {
            obj = new EntityFallingSand(this.worldClient, d, d1, d2, Block.mud.id);
        }
        if (packet23vehiclespawn.type == 72) {
            obj = new EntityCannonball(this.worldClient, d, d1, d2);
        }
        if (obj != null) {
            obj.serverPosX = packet23vehiclespawn.xPosition;
            obj.serverPosY = packet23vehiclespawn.yPosition;
            obj.serverPosZ = packet23vehiclespawn.zPosition;
            obj.yRot = packet23vehiclespawn.yaw;
            obj.xRot = packet23vehiclespawn.pitch;
            obj.id = packet23vehiclespawn.entityId;
            this.worldClient.func_712_a(packet23vehiclespawn.entityId, obj);
            if (packet23vehiclespawn.field_28044_i > 0) {
                Entity entity;
                if (packet23vehiclespawn.type == 60 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityArrow)obj).owner = (EntityLiving)entity;
                }
                if (packet23vehiclespawn.type == 72 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityCannonball)obj).owner = (EntityLiving)entity;
                }
                if (packet23vehiclespawn.type == 73 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityArrowGolden)obj).owner = (EntityLiving)entity;
                }
                obj.lerpMotion((double)packet23vehiclespawn.field_28047_e / 8000.0, (double)packet23vehiclespawn.field_28046_f / 8000.0, (double)packet23vehiclespawn.field_28045_g / 8000.0);
            }
        }
    }

    @Override
    public void handleWeather(Packet71Weather packet71weather) {
        double d = (double)packet71weather.field_27053_b / 32.0;
        double d1 = (double)packet71weather.field_27057_c / 32.0;
        double d2 = (double)packet71weather.field_27056_d / 32.0;
        EntityLightningBolt entitylightningbolt = null;
        if (packet71weather.field_27055_e == 1) {
            entitylightningbolt = new EntityLightningBolt(this.worldClient, d, d1, d2);
        }
        if (entitylightningbolt != null) {
            entitylightningbolt.serverPosX = packet71weather.field_27053_b;
            entitylightningbolt.serverPosY = packet71weather.field_27057_c;
            entitylightningbolt.serverPosZ = packet71weather.field_27056_d;
            entitylightningbolt.yRot = 0.0f;
            entitylightningbolt.xRot = 0.0f;
            entitylightningbolt.id = packet71weather.field_27054_a;
            this.worldClient.addWeatherEffect(entitylightningbolt);
        }
    }

    @Override
    public void handleWeatherStatus(Packet73WeatherStatus packet) {
        if (this.worldClient.dimension.id != packet.dimId) {
            return;
        }
        Weather currentWeather = packet.id == -1 ? null : Weather.weatherList[packet.id];
        Weather newWeather = packet.newId == -1 ? null : Weather.weatherList[packet.newId];
        this.worldClient.weatherManager.overrideWeather(currentWeather, newWeather, packet.duration, packet.intensity, packet.power);
    }

    @Override
    public void handleEntityPainting(Packet25EntityPainting packet25entitypainting) {
        EntityPainting entitypainting = new EntityPainting(this.worldClient, packet25entitypainting.xPosition, packet25entitypainting.yPosition, packet25entitypainting.zPosition, packet25entitypainting.direction, packet25entitypainting.title);
        this.worldClient.func_712_a(packet25entitypainting.entityId, entitypainting);
    }

    @Override
    public void handleBoatControl(Packet26BoatControl packet26BoatControl) {
        Entity entity1 = this.worldClient.getEntityById(packet26BoatControl.entityId);
        if (entity1 instanceof EntityBoat) {
            EntityBoat boat = (EntityBoat)entity1;
            boat.handleControlDirect(packet26BoatControl.targetXD, packet26BoatControl.targetZD, packet26BoatControl.targetYRot);
        }
    }

    @Override
    public void handleEntityVelocity(Packet28EntityVelocity packet28entityvelocity) {
        Entity entity = this.getEntityByID(packet28entityvelocity.entityId);
        if (entity == null) {
            return;
        }
        entity.lerpMotion((double)packet28entityvelocity.motionX / 8000.0, (double)packet28entityvelocity.motionY / 8000.0, (double)packet28entityvelocity.motionZ / 8000.0);
    }

    @Override
    public void handleEntityMetadata(Packet40EntityMetadata packet40entitymetadata) {
        Entity entity = this.getEntityByID(packet40entitymetadata.entityId);
        if (entity != null && packet40entitymetadata.func_21047_b() != null) {
            entity.getEntityData().assignValues(packet40entitymetadata.func_21047_b());
        }
    }

    @Override
    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn packet20namedentityspawn) {
        double d = (double)packet20namedentityspawn.xPosition / 32.0;
        double d1 = (double)packet20namedentityspawn.yPosition / 32.0;
        double d2 = (double)packet20namedentityspawn.zPosition / 32.0;
        float f = (float)(packet20namedentityspawn.rotation * 360) / 256.0f;
        float f1 = (float)(packet20namedentityspawn.pitch * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.mc.theWorld, packet20namedentityspawn.name);
        entityotherplayermp.serverPosX = packet20namedentityspawn.xPosition;
        entityotherplayermp.xo = entityotherplayermp.serverPosX;
        entityotherplayermp.serverPosY = packet20namedentityspawn.yPosition;
        entityotherplayermp.yo = entityotherplayermp.serverPosY;
        entityotherplayermp.serverPosZ = packet20namedentityspawn.zPosition;
        entityotherplayermp.zo = entityotherplayermp.serverPosZ;
        int i = packet20namedentityspawn.currentItem;
        entityotherplayermp.inventory.mainInventory[entityotherplayermp.inventory.currentItem] = i == 0 ? null : new ItemStack(i, 1, 0);
        entityotherplayermp.absMoveTo(d, d1, d2, f, f1);
        this.worldClient.func_712_a(packet20namedentityspawn.entityId, entityotherplayermp);
        entityotherplayermp.nickname = StringUtils.substring(packet20namedentityspawn.nickname, 0, 32);
        entityotherplayermp.chatColor = packet20namedentityspawn.chatColor;
    }

    @Override
    public void handleEntityTeleport(Packet34EntityTeleport packet34entityteleport) {
        Entity entity = this.getEntityByID(packet34entityteleport.entityId);
        if (entity != null) {
            entity.serverPosX = packet34entityteleport.xPosition;
            entity.serverPosY = packet34entityteleport.yPosition;
            entity.serverPosZ = packet34entityteleport.zPosition;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = (float)(packet34entityteleport.yaw * 360) / 256.0f;
            float f1 = (float)(packet34entityteleport.pitch * 360) / 256.0f;
            entity.lerpTo(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntity(Packet30Entity packet30entity) {
        Entity entity = this.getEntityByID(packet30entity.entityId);
        if (entity != null) {
            entity.serverPosX += packet30entity.xPosition;
            entity.serverPosY += packet30entity.yPosition;
            entity.serverPosZ += packet30entity.zPosition;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = packet30entity.rotating ? (float)(packet30entity.yaw * 360) / 256.0f : entity.yRot;
            float f1 = packet30entity.rotating ? (float)(packet30entity.pitch * 360) / 256.0f : entity.xRot;
            entity.lerpTo(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntityTagData(Packet42EntityTagData packet) {
        Entity entity = this.getEntityByID(packet.entityId);
        if (entity != null) {
            entity.readAdditionalSaveData(packet.tag);
        }
    }

    @Override
    public void handleSetMobSpawner(Packet132SetMobSpawner packet132SetMobSpawner) {
        TileEntity tileentity;
        if (this.mc.theWorld.isBlockLoaded(packet132SetMobSpawner.xPosition, packet132SetMobSpawner.yPosition, packet132SetMobSpawner.zPosition) && (tileentity = this.mc.theWorld.getBlockTileEntity(packet132SetMobSpawner.xPosition, packet132SetMobSpawner.yPosition, packet132SetMobSpawner.zPosition)) instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)tileentity;
            tileEntityMobSpawner.setMobId(packet132SetMobSpawner.spawnType);
            tileEntityMobSpawner.onInventoryChanged();
        }
    }

    @Override
    public void handleDestroyEntity(Packet29DestroyEntity packet29destroyentity) {
        this.worldClient.removeEntityFromWorld(packet29destroyentity.entityId);
    }

    @Override
    public void handleFlying(Packet10Flying packet10flying) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.x;
        double d1 = entityplayersp.y;
        double d2 = entityplayersp.z;
        float f = entityplayersp.yRot;
        float f1 = entityplayersp.xRot;
        if (packet10flying.moving) {
            d = packet10flying.xPosition;
            d1 = packet10flying.yPosition;
            d2 = packet10flying.zPosition;
        }
        if (packet10flying.rotating) {
            f = packet10flying.yaw;
            f1 = packet10flying.pitch;
        }
        entityplayersp.ySlideOffset = 0.0f;
        entityplayersp.zd = 0.0;
        entityplayersp.yd = 0.0;
        entityplayersp.xd = 0.0;
        entityplayersp.absMoveTo(d, d1, d2, f, f1);
        packet10flying.xPosition = entityplayersp.x;
        packet10flying.yPosition = entityplayersp.bb.minY;
        packet10flying.zPosition = entityplayersp.z;
        packet10flying.stance = entityplayersp.y;
        this.netManager.addToSendQueue(packet10flying);
        if (!this.field_1210_g) {
            this.mc.thePlayer.xo = this.mc.thePlayer.x;
            this.mc.thePlayer.yo = this.mc.thePlayer.y;
            this.mc.thePlayer.zo = this.mc.thePlayer.z;
            this.field_1210_g = true;
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    public void handlePreChunk(Packet50PreChunk packet50prechunk) {
        this.worldClient.doPreChunk(packet50prechunk.xPosition, packet50prechunk.yPosition, packet50prechunk.mode);
    }

    @Override
    public void handleMultiBlockChange(Packet52MultiBlockChange packet) {
        int xBase = packet.xChunk * 16;
        int zBase = packet.zChunk * 16;
        for (int k = 0; k < packet.size; ++k) {
            int coord = packet.coordinateArray[k];
            int type = packet.typeArray[k] & 0x3FFF;
            byte data = packet.metadataArray[k];
            int x = coord >> 0 & 0xF;
            int y = coord >> 8 & 0xFF;
            int z = coord >> 4 & 0xF;
            this.worldClient.setBlockAndMetadataWithNotify(x + xBase, y, z + zBase, type, data);
            this.worldClient.func_711_c(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
            this.worldClient.markBlocksDirty(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
        }
    }

    @Override
    public void handleMapChunk(Packet51MapChunk packet) {
        this.worldClient.func_711_c(packet.xPosition, packet.yPosition, packet.zPosition, packet.xPosition + packet.xSize - 1, packet.yPosition + packet.ySize - 1, packet.zPosition + packet.zSize - 1);
        this.worldClient.setChunkData(packet.xPosition, packet.yPosition, packet.zPosition, packet.xSize, packet.ySize, packet.zSize, packet.chunk);
    }

    @Override
    public void handleBlockChange(Packet53BlockChange packet53blockchange) {
        this.worldClient.func_714_c(packet53blockchange.xPosition, packet53blockchange.yPosition, packet53blockchange.zPosition, packet53blockchange.type, packet53blockchange.metadata);
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet255kickdisconnect) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld(null);
        this.mc.displayGuiScreen(new GuiConnectFailed("disconnect.disconnected", "disconnect.genericReason", new Object[]{packet255kickdisconnect.reason}));
    }

    @Override
    public void handleErrorMessage(String s, Object[] errorLines) {
        if (!this.disconnected) {
            this.disconnected = true;
            this.mc.changeWorld(null);
            this.mc.displayGuiScreen(new GuiConnectFailed("disconnect.lost", s, errorLines));
        }
    }

    public void func_28117_a(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
        this.netManager.serverShutdown();
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public void handleCollect(Packet22Collect packet22collect) {
        Entity entity = this.getEntityByID(packet22collect.collectedEntityId);
        EntityLiving obj = (EntityLiving)this.getEntityByID(packet22collect.collectorEntityId);
        if (obj == null) {
            obj = this.mc.thePlayer;
        }
        if (entity != null) {
            this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, entity, obj, -0.5f));
            this.worldClient.removeEntityFromWorld(packet22collect.collectedEntityId);
        }
    }

    @Override
    public void handleChat(Packet3Chat packet3chat) {
        if (packet3chat.encrypted) {
            try {
                this.mc.ingameGUI.addChatMessage(AES.decrypt(packet3chat.message, AES.clientKeyChain));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.mc.ingameGUI.addChatMessage(packet3chat.message);
        }
    }

    public void handlePlayerJoin(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.message);
    }

    public void handlePlayerLeave(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.message);
    }

    @Override
    public void handleAnimation(Packet18Animation packet18animation) {
        Entity entity = this.getEntityByID(packet18animation.entityId);
        if (entity == null) {
            return;
        }
        if (packet18animation.animate == 1) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.swingItem();
        } else if (packet18animation.animate == 2) {
            entity.animateHurt();
        } else if (packet18animation.animate == 3) {
            EntityPlayer entityplayer1 = (EntityPlayer)entity;
            entityplayer1.wakeUpPlayer(false, false);
        } else if (packet18animation.animate == 4) {
            EntityPlayer entityplayer2 = (EntityPlayer)entity;
            entityplayer2.func_6420_o();
        }
    }

    @Override
    public void handleSleep(Packet17Sleep packet17sleep) {
        Entity entity = this.getEntityByID(packet17sleep.entityID);
        if (entity == null) {
            return;
        }
        if (packet17sleep.field_22046_e == 0) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.sleepInBedAt(packet17sleep.x, packet17sleep.y, packet17sleep.z);
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake packet2handshake) {
        block8: {
            if (packet2handshake.username.equals("-")) {
                try {
                    RSA.RSAKeyChain = RSA.generateKeyPair();
                    this.addToSendQueue(new Packet1Login(this.mc.session.username, 28946, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + packet2handshake.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = bufferedreader.readLine();
                bufferedreader.close();
                if (s.equalsIgnoreCase("ok")) {
                    try {
                        RSA.RSAKeyChain = RSA.generateKeyPair();
                        this.addToSendQueue(new Packet1Login(this.mc.session.username, 28946, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s});
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + exception.toString()});
            }
        }
    }

    @Override
    public void handleSendKey(Packet136SendKey packet136SendKey) {
        try {
            AES.clientKeyChain = AES.getKey(RSA.decrypt(packet136SendKey.KEY, RSA.RSAKeyChain.getPrivate()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handlePlayerList(Packet138PlayerList packet138PlayerList) {
        this.playerList.clear();
        String[] players = packet138PlayerList.players;
        String[] scores = packet138PlayerList.scores;
        for (int i = 0; i < players.length; ++i) {
            this.playerList.put(players[i], scores[i]);
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(Packet24MobSpawn packet24mobspawn) {
        double d = (double)packet24mobspawn.xPosition / 32.0;
        double d1 = (double)packet24mobspawn.yPosition / 32.0;
        double d2 = (double)packet24mobspawn.zPosition / 32.0;
        float f = (float)(packet24mobspawn.yaw * 360) / 256.0f;
        float f1 = (float)(packet24mobspawn.pitch * 360) / 256.0f;
        EntityLiving entityliving = (EntityLiving)EntityDispatcher.createEntity(packet24mobspawn.type, this.mc.theWorld);
        entityliving.serverPosX = packet24mobspawn.xPosition;
        entityliving.serverPosY = packet24mobspawn.yPosition;
        entityliving.serverPosZ = packet24mobspawn.zPosition;
        entityliving.id = packet24mobspawn.entityId;
        entityliving.absMoveTo(d, d1, d2, f, f1);
        entityliving.isMultiplayerEntity = true;
        this.worldClient.func_712_a(packet24mobspawn.entityId, entityliving);
        List list = packet24mobspawn.getMetadata();
        if (list != null) {
            entityliving.getEntityData().assignValues(list);
        }
        entityliving.nickname = StringUtils.substring(packet24mobspawn.nickname, 0, 32);
        entityliving.chatColor = packet24mobspawn.chatColor;
    }

    @Override
    public void handleUpdateTime(Packet4UpdateTime packet4updatetime) {
        this.mc.theWorld.setWorldTime(packet4updatetime.time);
    }

    @Override
    public void handleSpawnPosition(Packet6SpawnPosition packet6spawnposition) {
        this.mc.thePlayer.setPlayerSpawnCoordinate(new ChunkCoordinates(packet6spawnposition.xPosition, packet6spawnposition.yPosition, packet6spawnposition.zPosition));
        this.mc.theWorld.getLevelData().setSpawn(packet6spawnposition.xPosition, packet6spawnposition.yPosition, packet6spawnposition.zPosition);
    }

    @Override
    public void handleAttachEntity(Packet39AttachEntity packet) {
        Entity passenger = this.getEntityByID(packet.passengerId);
        if (packet.passengerId == this.mc.thePlayer.id) {
            passenger = this.mc.thePlayer;
        }
        IVehicle vehicle = packet.isTileEntity ? (IVehicle)((Object)this.worldClient.getBlockTileEntity(packet.x, packet.y, packet.z)) : this.getEntityByID(packet.vehicleId);
        if (passenger != null && vehicle != null) {
            passenger.startRiding(vehicle);
        }
    }

    @Override
    public void handleEntityStatus(Packet38EntityStatus packet38entitystatus) {
        Entity entity = this.getEntityByID(packet38entitystatus.entityId);
        if (entity != null) {
            entity.handleEntityEvent(packet38entitystatus.entityStatus, packet38entitystatus.attackedAtYaw);
        }
    }

    protected Entity getEntityByID(int i) {
        if (i == this.mc.thePlayer.id) {
            return this.mc.thePlayer;
        }
        return this.worldClient.getEntityById(i);
    }

    @Override
    public void handleUpdateHealth(Packet8UpdateHealth packet8updatehealth) {
        this.mc.thePlayer.setHealth(packet8updatehealth.healthMP);
    }

    @Override
    public void handleUpdatePlayerProfile(Packet72UpdatePlayerProfile packet72playerprofile) {
        int index;
        PlayerProfile playerProfile = new PlayerProfile(packet72playerprofile.username, packet72playerprofile.nickname, packet72playerprofile.score, packet72playerprofile.chatColor, packet72playerprofile.isOperator);
        if (playerProfile.playerName.equals(this.mc.thePlayer.username)) {
            this.mc.thePlayer.score = playerProfile.scoreTotal;
        }
        if ((index = this.findPlayerInList(playerProfile)) != -1) {
            if (!packet72playerprofile.isOnline) {
                this.removePlayer(index);
            } else {
                this.players.set(index, playerProfile);
            }
        } else {
            this.addPlayer(playerProfile);
        }
    }

    @Override
    public void handleRespawn(Packet9Respawn packet9respawn) {
        if (packet9respawn.respawnDimensionId != this.mc.thePlayer.dimension) {
            this.field_1210_g = false;
            this.worldClient = new WorldClient(this.mc, this, this.worldClient.getLevelData().getRandomSeed(), packet9respawn.respawnDimensionId, packet9respawn.respawnWorldTypeId);
            this.worldClient.isClientSide = true;
            this.mc.changeWorld(this.worldClient);
            this.mc.thePlayer.dimension = packet9respawn.respawnDimensionId;
            this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        }
        this.mc.respawn(true, packet9respawn.respawnDimensionId);
    }

    @Override
    public void handleExplosion(Packet60Explosion packet60explosion) {
        Explosion explosion = packet60explosion.isCannonball ? new ExplosionCannonball(this.mc.theWorld, null, packet60explosion.explosionX, packet60explosion.explosionY, packet60explosion.explosionZ, packet60explosion.explosionSize) : new Explosion(this.mc.theWorld, null, packet60explosion.explosionX, packet60explosion.explosionY, packet60explosion.explosionZ, packet60explosion.explosionSize);
        explosion.destroyedBlockPositions = packet60explosion.destroyedBlockPositions;
        explosion.doExplosionB(true);
    }

    @Override
    public void handleOpenWindow(Packet100OpenWindow packet100openwindow) {
        if (packet100openwindow.inventoryType == 0) {
            InventoryBasic inventorybasic = new InventoryBasic(packet100openwindow.windowTitle, packet100openwindow.slotsCount);
            this.mc.thePlayer.displayGUIChest(inventorybasic);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 2) {
            TileEntityFurnace tileentityfurnace = new TileEntityFurnace();
            this.mc.thePlayer.displayGUIFurnace(tileentityfurnace);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 3) {
            TileEntityDispenser tileentitydispenser = new TileEntityDispenser();
            this.mc.thePlayer.displayGUIDispenser(tileentitydispenser);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 4) {
            TileEntityBlastFurnace tileentityblastfurnace = new TileEntityBlastFurnace();
            this.mc.thePlayer.displayGUIFurnace(tileentityblastfurnace);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 5) {
            TileEntityTrommel tileentitytrommel = new TileEntityTrommel();
            this.mc.thePlayer.displayGUITrommel(tileentitytrommel);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 7) {
            this.mc.thePlayer.displayGUIPaintingPicker();
        } else if (packet100openwindow.inventoryType == 1) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            this.mc.thePlayer.displayGUIWorkbench(MathHelper.floor_double(entityplayersp.x), MathHelper.floor_double(entityplayersp.y), MathHelper.floor_double(entityplayersp.z));
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        }
    }

    @Override
    public void handleOpenFlagWindow(Packet142OpenFlagWindow packet) {
        TileEntity tileEntity = this.worldClient.getBlockTileEntity(packet.x, packet.y, packet.z);
        if (tileEntity instanceof TileEntityFlag) {
            TileEntityFlag tileEntityFlag = (TileEntityFlag)tileEntity;
            this.mc.thePlayer.displayGUIEditFlag(tileEntityFlag);
            this.mc.thePlayer.craftingInventory.windowId = packet.windowId;
        }
    }

    @Override
    public void handlePhotoMode(Packet143PhotoMode packet) {
        GuiIngameMenu.photoModeDisabled = packet.disabled;
    }

    @Override
    public void handleSetSlot(Packet103SetSlot packet103setslot) {
        if (packet103setslot.windowId == -1) {
            this.mc.thePlayer.inventory.setHeldItemStack(packet103setslot.myItemStack);
        } else if (packet103setslot.windowId == 0 && packet103setslot.itemSlot >= 36 && packet103setslot.itemSlot < 45) {
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(packet103setslot.itemSlot).getStack();
            if (packet103setslot.myItemStack != null && (itemstack == null || itemstack.stackSize < packet103setslot.myItemStack.stackSize)) {
                packet103setslot.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.putStackInSlot(packet103setslot.itemSlot, packet103setslot.myItemStack);
        } else if (packet103setslot.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStackInSlot(packet103setslot.itemSlot, packet103setslot.myItemStack);
        }
    }

    @Override
    public void handleTransaction(Packet106Transaction packet106transaction) {
        Container container = null;
        if (packet106transaction.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (packet106transaction.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (packet106transaction.field_20030_c) {
                container.func_20113_a(packet106transaction.shortWindowId);
            } else {
                container.func_20110_b(packet106transaction.shortWindowId);
                this.addToSendQueue(new Packet106Transaction(packet106transaction.windowId, packet106transaction.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleWindowItems(Packet104WindowItems packet104windowitems) {
        if (packet104windowitems.windowId == 0) {
            this.mc.thePlayer.inventorySlots.putStacksInSlots(packet104windowitems.itemStack);
        } else if (packet104windowitems.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStacksInSlots(packet104windowitems.itemStack);
        }
    }

    @Override
    public void handleUpdateProgressbar(Packet105UpdateProgressbar packet105updateprogressbar) {
        this.handleInvalidPacket(packet105updateprogressbar);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.windowId == packet105updateprogressbar.windowId) {
            this.mc.thePlayer.craftingInventory.updateClientProgressBar(packet105updateprogressbar.progressBar, packet105updateprogressbar.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(Packet5PlayerInventory packet5playerinventory) {
        Entity entity = this.getEntityByID(packet5playerinventory.entityID);
        if (entity != null) {
            entity.setEquippedSlot(packet5playerinventory.slot, packet5playerinventory.itemID, packet5playerinventory.itemDamage, packet5playerinventory.itemData);
        }
    }

    @Override
    public void handleCloseWindow(Packet101CloseWindow packet101closewindow) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handlePlayNoteBlock(Packet54PlayNoteBlock packet54playnoteblock) {
        this.mc.theWorld.triggerEvent(packet54playnoteblock.xLocation, packet54playnoteblock.yLocation, packet54playnoteblock.zLocation, packet54playnoteblock.instrumentType, packet54playnoteblock.pitch);
    }

    @Override
    public void handleBed(Packet70Bed packet70bed) {
        int i = packet70bed.field_25019_b;
        if (i >= 0 && i < Packet70Bed.field_25020_a.length && Packet70Bed.field_25020_a[i] != null) {
            this.mc.thePlayer.addChatMessage(Packet70Bed.field_25020_a[i]);
        }
    }

    @Override
    public void handleMapData(Packet131MapData packet131mapdata) {
        if (packet131mapdata.itemId == Item.map.id) {
            ItemMap.getOrCreateSavedData(packet131mapdata.meta, this.mc.theWorld).setColors(packet131mapdata.mapData).setMapWaypoints(packet131mapdata.waypoints);
        } else {
            System.out.println("Unknown itemid: " + packet131mapdata.meta);
        }
    }

    @Override
    public void handlePlaySoundEffect(Packet61PlaySoundEffect packet61playsoundeffect) {
        this.mc.theWorld.playSoundEffect(packet61playsoundeffect.soundID, packet61playsoundeffect.x, packet61playsoundeffect.y, packet61playsoundeffect.z, packet61playsoundeffect.data);
    }

    @Override
    public void handlePlaySoundDirectly(Packet62PlaySoundDirect packet) {
        String soundPath = SoundTypes.getSoundById(packet.soundId);
        if (soundPath == null) {
            return;
        }
        this.mc.sndManager.playSound(soundPath, packet.soundType, (float)packet.x, (float)packet.y, (float)packet.z, packet.volume, packet.pitch);
    }

    @Override
    public void handleSpawnParticle(Packet63SpawnParticleEffect packet63SpawnParticleEffect) {
        if (packet63SpawnParticleEffect.isGroup) {
            for (int i = 0; i < packet63SpawnParticleEffect.amount; ++i) {
                this.mc.renderGlobal.addParticle(packet63SpawnParticleEffect.particleKey, packet63SpawnParticleEffect.x + this.rand.nextDouble() * (double)packet63SpawnParticleEffect.randOffX, packet63SpawnParticleEffect.y + this.rand.nextDouble() * (double)packet63SpawnParticleEffect.randOffY, packet63SpawnParticleEffect.z + this.rand.nextDouble() * (double)packet63SpawnParticleEffect.randOffZ, packet63SpawnParticleEffect.motionX + this.rand.nextGaussian() * (double)packet63SpawnParticleEffect.randMotionX, packet63SpawnParticleEffect.motionY + this.rand.nextGaussian() * (double)packet63SpawnParticleEffect.randMotionY, packet63SpawnParticleEffect.motionZ + this.rand.nextGaussian() * (double)packet63SpawnParticleEffect.randMotionZ, packet63SpawnParticleEffect.maxDistance);
            }
        } else {
            this.mc.renderGlobal.addParticle(packet63SpawnParticleEffect.particleKey, packet63SpawnParticleEffect.x, packet63SpawnParticleEffect.y, packet63SpawnParticleEffect.z, packet63SpawnParticleEffect.motionX, packet63SpawnParticleEffect.motionY, packet63SpawnParticleEffect.motionZ, packet63SpawnParticleEffect.maxDistance);
        }
    }

    @Override
    public void handleStatistic(Packet200Statistic packet200statistic) {
        ((EntityClientPlayerMP)this.mc.thePlayer).func_27027_b(StatList.getStat(packet200statistic.field_27052_a), packet200statistic.field_27051_b);
    }

    @Override
    public void handleEntityPlayerGamemode(Packet41EntityPlayerGamemode packet) {
        this.mc.thePlayer.setGamemode(Gamemode.gamemodesList[packet.gamemodeId]);
    }

    @Override
    public void handleEntityNickname(Packet35EntityNickname packet35EntityNickname) {
        Entity entity = this.getEntityByID(packet35EntityNickname.entityId);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).nickname = StringUtils.substring(packet35EntityNickname.nickname, 0, 32);
            ((EntityLiving)entity).chatColor = packet35EntityNickname.chatColor;
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleBlockItemSwitch(Packet16BlockItemSwitch packet16blockitemswitch) {
        this.mc.thePlayer.inventory.currentItem = packet16blockitemswitch.id;
    }

    @Override
    public void handleTileEntityData(Packet140TileEntityData packet) {
        Class<?> clazz = TileEntity.getClassFromID(packet.tag.getString("id"));
        if (clazz == null) {
            return;
        }
        TileEntity existingTileEntity = this.worldClient.getBlockTileEntity(packet.tag.getInteger("x"), packet.tag.getInteger("y"), packet.tag.getInteger("z"));
        if (existingTileEntity == null || existingTileEntity.getClass() != clazz) {
            TileEntity tileEntity = TileEntity.createAndLoadEntity(packet.tag);
            if (tileEntity != null) {
                this.mc.theWorld.setBlockTileEntity(tileEntity.x, tileEntity.y, tileEntity.z, tileEntity);
            }
        } else {
            existingTileEntity.readFromNBT(packet.tag);
        }
        this.worldClient.markBlockDirty(packet.tag.getInteger("x"), packet.tag.getInteger("y"), packet.tag.getInteger("z"));
    }

    @Override
    public void handleGameRule(Packet74GameRule packet) {
        LevelData levelData = this.mc.theWorld.getLevelData();
        if (packet.getGameRules() != null) {
            levelData.getGameRules().setValues(packet.getGameRules());
        }
    }

    @Override
    public void handleSyncedRecipe(Packet75RecipeSync packet75RecipeSync) {
        if (Registries.RECIPES.getAllSerializableRecipes().isEmpty()) {
            System.out.println("Receiving " + packet75RecipeSync.maxRecipes + " recipes from server..");
        }
        DataLoader.loadRecipeFromServer(packet75RecipeSync);
        if ((long)Registries.RECIPES.getAllSerializableRecipes().size() == packet75RecipeSync.maxRecipes) {
            System.out.println("All recipes received!");
            Registries.RECIPES.invalidateCaches();
            SearchPage.searchField.setText("_");
            PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
            GuiGuidebook.getPageManager().updatePages();
            SearchPage.searchField.setText("");
            PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
            GuiGuidebook.getPageManager().updatePages();
        }
    }

    @Override
    public void handleIds(Packet201Ids packet) {
        SoundTypes.setSoundIds(packet.soundIds);
    }

    @Override
    public void handleCustomPayload(Packet250CustomPayload packet) {
    }
}

