/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.colorizer.ColorProperties;
import net.minecraft.client.render.colorizer.ColorizerFoliage;
import net.minecraft.client.render.colorizer.LeavesColorProperties;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Season;

public class BlockColorLeaves
extends BlockColor {
    protected final String colorId;

    public BlockColorLeaves(String colorId) {
        this.colorId = colorId;
    }

    @Override
    public int getFallbackColor(int meta) {
        LeavesColorProperties color = ColorProperties.getLeavesColor(this.colorId);
        if (color == null) {
            return 0xFFFFFF;
        }
        return ColorProperties.fRGB2iRGB(color.inventoryR, color.inventoryG, color.inventoryB);
    }

    @Override
    public int getWorldColor(World world, int x, int y, int z) {
        LeavesColorProperties color = ColorProperties.getLeavesColor(this.colorId);
        if (color == null) {
            return 0xFFFFFF;
        }
        int foliageColor = ColorProperties.fRGB2iRGB(color.inventoryR, color.inventoryG, color.inventoryB);
        if (world != null) {
            double temp = world.getBlockTemperature(x, z);
            double hum = world.getBlockHumidity(x, z);
            Season season = world.seasonManager.getCurrentSeason();
            if (season != null) {
                float progress = world.seasonManager.getSeasonProgress();
                foliageColor = ColorizerFoliage.getSeasonalColor(season, progress, temp, hum, color);
            }
        }
        return foliageColor;
    }
}

