/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.core.block.Block;

public class BlockModelRenderBlocks
extends BlockModel {
    private static RenderBlocks renderBlocks;
    public final int renderType;

    public BlockModelRenderBlocks(int renderType) {
        this.renderType = renderType;
    }

    @Override
    public boolean render(Block block, int x, int y, int z) {
        return renderBlocks.renderBlockByRenderType(block, this.renderType, x, y, z);
    }

    @Override
    public boolean renderNoCulling(Block block, int x, int y, int z) {
        return renderBlocks.renderBlockAllFaces(block, this.renderType, x, y, z);
    }

    @Override
    public boolean renderWithOverrideTexture(Block block, int x, int y, int z, int textureIndex) {
        return renderBlocks.renderBlockUsingTexture(block, this.renderType, x, y, z, textureIndex);
    }

    @Override
    public boolean shouldItemRender3d() {
        if (this.renderType == 0 || this.renderType == 20 || this.renderType == 30) {
            return true;
        }
        if (this.renderType == 13) {
            return true;
        }
        if (this.renderType == 10) {
            return true;
        }
        if (this.renderType == 11) {
            return true;
        }
        if (this.renderType == 18) {
            return true;
        }
        if (this.renderType == 21) {
            return true;
        }
        if (this.renderType == 22) {
            return true;
        }
        if (this.renderType == 23) {
            return true;
        }
        if (this.renderType == 27) {
            return true;
        }
        if (this.renderType == 31) {
            return true;
        }
        if (this.renderType == 33) {
            return true;
        }
        return this.renderType == 16;
    }

    @Override
    public float getItemRenderScale() {
        if (this.renderType == 1 || this.renderType == 19 || this.renderType == 12 || this.renderType == 2) {
            return 0.5f;
        }
        return 0.25f;
    }

    public static void setRenderBlocks(RenderBlocks rb) {
        renderBlocks = rb;
    }
}

