/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.entity.animal.EntitySquid;
import org.lwjgl.opengl.GL11;

public class SquidRenderer
extends LivingRenderer<EntitySquid> {
    public SquidRenderer(ModelBase modelbase, float f) {
        super(modelbase, f);
    }

    @Override
    protected float ticksExisted(EntitySquid squid, float partialTick) {
        return squid.limbAnglePrev + (squid.newLimbAngle - squid.limbAnglePrev) * partialTick;
    }

    @Override
    protected void rotateModel(EntitySquid squid, float ticksExisted, float headYawOffset, float partialTick) {
        float pitch = squid.prevPitch + (squid.newPitch - squid.prevPitch) * partialTick;
        float yaw = squid.prevYaw + (squid.newYaw - squid.prevYaw) * partialTick;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(180.0f - headYawOffset), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.2f, (float)0.0f);
    }

    @Override
    public void doRenderPreview(EntitySquid squid, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.25f, (float)0.0f);
        super.doRenderPreview(squid, x, y, z, yaw, partialTick);
        GL11.glPopMatrix();
    }
}

