/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererFlowerJar
extends TileEntityRenderer<TileEntityFlowerJar> {
    private RenderBlocks renderBlocks;

    @Override
    public void onWorldChanged(World world) {
        this.renderBlocks = new RenderBlocks(world, world);
    }

    @Override
    public void doRender(TileEntityFlowerJar tileEntity, double x, double y, double z, float renderPartialTicks) {
        GL11.glPushMatrix();
        if (tileEntity.flowerInPot > 0) {
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            Block block = Block.getBlock(tileEntity.flowerInPot);
            this.loadTexture("/terrain.png");
            float scaleValue = 0.75f;
            GL11.glScalef((float)scaleValue, (float)scaleValue, (float)scaleValue);
            GL11.glTranslatef((float)0.66f, (float)0.75f, (float)0.66f);
            float lightLevel = Minecraft.getMinecraft((Object)this).theWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
            if (Minecraft.getMinecraft((Object)this).fullbright) {
                lightLevel = 1.0f;
            }
            this.renderBlocks.renderBlockOnInventory(block, 0, lightLevel);
        }
        GL11.glPopMatrix();
    }
}

