/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.model.ModelSign;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererSign
extends TileEntityRenderer<TileEntitySign> {
    private final ModelSign signModel = new ModelSign();

    public void renderTileEntitySignAt(TileEntitySign tileEntity, double d, double d1, double d2, float f) {
        Block block = tileEntity.getBlockType();
        GL11.glPushMatrix();
        float scale = 0.6666667f;
        if (block == Block.signPostPlanksOak) {
            GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 + 0.75f * scale), (float)((float)d2 + 0.5f));
            float f2 = (float)(tileEntity.getMovedData() * 360) / 16.0f;
            GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            this.signModel.signStick.showModel = true;
        } else {
            int i = tileEntity.getMovedData();
            float f3 = 0.0f;
            if (i == 2) {
                f3 = 180.0f;
            }
            if (i == 4) {
                f3 = 90.0f;
            }
            if (i == 5) {
                f3 = -90.0f;
            }
            GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 + 0.75f * scale), (float)((float)d2 + 0.5f));
            GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.signModel.signStick.showModel = false;
        }
        this.loadTexture("/item/sign.png");
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)(-scale), (float)(-scale));
        this.signModel.func_887_a();
        GL11.glPopMatrix();
        FontRenderer fontrenderer = this.getFontRenderer();
        GL11.glPushMatrix();
        float f4 = 0.01566f * scale;
        GL11.glTranslatef((float)0.0f, (float)(0.5f * scale), (float)(0.065f * scale));
        GL11.glScalef((float)f4, (float)(-f4), (float)f4);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f4));
        GL11.glDepthMask((boolean)false);
        EnumSignPicture picture = tileEntity.getPicture();
        this.renderDispatcher.renderEngine.bindTexture(this.renderDispatcher.renderEngine.getTexture("/gui/sign_images.png"));
        this.drawTexturedModalRect(-48, -24, picture.getU(), picture.getV(), 48, 24);
        GL11.glPopMatrix();
        float lightLevel = Minecraft.getMinecraft((Object)this).theWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        GL11.glPushMatrix();
        f4 = 0.01666667f * scale;
        GL11.glTranslatef((float)0.0f, (float)(0.5f * scale), (float)(0.065f * scale));
        GL11.glScalef((float)f4, (float)(-f4), (float)f4);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f4));
        GL11.glDepthMask((boolean)false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)((float)(color >> 16 & 0xFF) * lightLevel);
        int g = (int)((float)(color >> 8 & 0xFF) * lightLevel);
        int b = (int)((float)(color >> 0 & 0xFF) * lightLevel);
        color = r << 16 | g << 8 | b << 0;
        for (int line = 0; line < tileEntity.signText.length; ++line) {
            String text = tileEntity.signText[line];
            if (line == tileEntity.lineBeingEdited) {
                text = "> " + text + " <";
            }
            fontrenderer.drawString(text, -fontrenderer.getStringWidth(text) / 2, line * 10 - tileEntity.signText.length * 5, color);
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(TileEntitySign tileEntity, double x, double y, double z, float partialTick) {
        this.renderTileEntitySignAt(tileEntity, x, y, z, partialTick);
    }

    private void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float uScale = 0.0013020834f;
        float vScale = 0.0026041667f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height * 2, 0.0, (float)(u + 0) * uScale, (float)(v + height) * vScale);
        tessellator.addVertexWithUV(x + width * 2, y + height * 2, 0.0, (float)(u + width) * uScale, (float)(v + height) * vScale);
        tessellator.addVertexWithUV(x + width * 2, y + 0, 0.0, (float)(u + width) * uScale, (float)(v + 0) * vScale);
        tessellator.addVertexWithUV(x + 0, y + 0, 0.0, (float)(u + 0) * uScale, (float)(v + 0) * vScale);
        tessellator.draw();
    }
}

