/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFlower;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockDeadBush
extends BlockFlower {
    public BlockDeadBush(String key, int id) {
        super(key, id);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.sand.id || i == Block.dirtScorched.id;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        int quantity = world.rand.nextInt(3);
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        if (quantity == 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Item.stick, quantity)};
    }
}

