/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTransparent;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockIce
extends BlockTransparent {
    public BlockIce(String key, int id) {
        super(key, id, Material.ice, false);
        this.movementScale = 0.98f;
        this.setTicking(true);
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        return super.shouldSideBeRendered(blockAccess, x, y, z, 1 - side);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int meta, TileEntity tileEntity) {
        super.harvestBlock(world, entityplayer, i, j, k, meta, tileEntity);
        Material material = world.getBlockMaterial(i, j - 1, k);
        if (material.blocksMotion() || material.isLiquid()) {
            world.setBlockWithNotify(i, j, k, Block.fluidWaterFlowing.id);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.getSavedLightValue(LightLayer.Block, x, y, z) > 11 - Block.lightBlock[this.id]) {
            world.setBlockWithNotify(x, y, z, Block.fluidWaterStill.id);
        }
    }

    @Override
    public int getPistonPushReaction() {
        return 0;
    }
}

