/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLog;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.season.Season;

public abstract class BlockLeavesBase
extends Block {
    int[] adjacentTreeBlocks;
    protected static boolean fancyGraphics;

    public BlockLeavesBase(String key, int id, Material material, boolean flag) {
        super(key, id, material);
        fancyGraphics = flag;
        this.setTicking(true);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        return !fancyGraphics ? this.atlasIndices[side.getId()] + 1 : this.atlasIndices[side.getId()];
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        float dropRate;
        Season season = world.seasonManager.getCurrentSeason();
        float f = dropRate = season != null ? 20.0f / season.saplingDropFactor : 20.0f;
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        int numDropped = 1;
        if (world.rand.nextInt(MathHelper.floor_double(dropRate)) != 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(this.getSapling(), numDropped)};
    }

    protected abstract Block getSapling();

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        int i1 = blockAccess.getBlockId(x, y, z);
        if (!fancyGraphics && i1 == this.id) {
            return false;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        int radius = 1;
        int chunkRadius = radius + 1;
        if (world.areBlocksLoaded(x - chunkRadius, y - chunkRadius, z - chunkRadius, x + chunkRadius, y + chunkRadius, z + chunkRadius)) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        int meta;
                        int blockId = world.getBlockId(x + dx, y + dy, z + dz);
                        if (!(Block.blocksList[blockId] instanceof BlockLeavesBase) || ((meta = world.getBlockMetadata(x + dx, y + dy, z + dz)) & 1) != 0) continue;
                        world.setBlockMetadata(x + dx, y + dy, z + dz, meta | 8);
                    }
                }
            }
        }
    }

    public static void setGraphicsLevel(boolean graphicsLevel) {
        fancyGraphics = graphicsLevel;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) != 0 && !BlockLeavesBase.isPermanent(meta)) {
            int j2;
            int byte0 = 4;
            int offset = byte0 + 1;
            int ySpan = 32;
            int xSpan = ySpan * ySpan;
            int halfLength = ySpan / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[ySpan * ySpan * ySpan];
            }
            if (world.areBlocksLoaded(x - offset, y - offset, z - offset, x + offset, y + offset, z + offset)) {
                for (int xOffset = -byte0; xOffset <= byte0; ++xOffset) {
                    for (int yOffset = -byte0; yOffset <= byte0; ++yOffset) {
                        for (int zOffset = -byte0; zOffset <= byte0; ++zOffset) {
                            int k3 = world.getBlockId(x + xOffset, y + yOffset, z + zOffset);
                            this.adjacentTreeBlocks[(xOffset + halfLength) * xSpan + (yOffset + halfLength) * ySpan + (zOffset + halfLength)] = Block.blocksList[k3] instanceof BlockLog ? 0 : (Block.blocksList[k3] instanceof BlockLeavesBase ? -2 : -1);
                        }
                    }
                }
                for (int i2 = 1; i2 <= 4; ++i2) {
                    for (int dx = -byte0; dx <= byte0; ++dx) {
                        for (int dy = -byte0; dy <= byte0; ++dy) {
                            for (int dz = -byte0; dz <= byte0; ++dz) {
                                if (this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] != i2 - 1) continue;
                                if (this.adjacentTreeBlocks[(dx + halfLength - 1) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(dx + halfLength - 1) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(dx + halfLength + 1) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(dx + halfLength + 1) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength - 1) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength - 1) * ySpan + (dz + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength + 1) * ySpan + (dz + halfLength)] == -2) {
                                    this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength + 1) * ySpan + (dz + halfLength)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength - 1)] == -2) {
                                    this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength - 1)] = i2;
                                }
                                if (this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength + 1)] != -2) continue;
                                this.adjacentTreeBlocks[(dx + halfLength) * xSpan + (dy + halfLength) * ySpan + (dz + halfLength + 1)] = i2;
                            }
                        }
                    }
                }
            }
            if ((j2 = this.adjacentTreeBlocks[halfLength * xSpan + halfLength * ySpan + halfLength]) >= 0) {
                world.setBlockMetadata(x, y, z, meta & 0xFFFFFFF7);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int i, int j, int k) {
        this.dropBlockWithCause(world, EnumDropCause.WORLD, i, j, k, world.getBlockMetadata(i, j, k), null);
        world.setBlockWithNotify(i, j, k, 0);
    }

    public static boolean isPermanent(int meta) {
        return (meta & 1) > 0;
    }
}

