/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.logic.RailLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockRail
extends Block {
    private final boolean isPowered;

    public static final boolean isRailBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == Block.rail.id || l == Block.railPowered.id || l == Block.railDetector.id;
    }

    public static final boolean isRailBlock(int i) {
        return i == Block.rail.id || i == Block.railPowered.id || i == Block.railDetector.id;
    }

    protected BlockRail(String key, int id, boolean isPowered) {
        super(key, id, Material.decoration);
        this.isPowered = isPowered;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3d start, Vec3d end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.collisionRayTrace(world, x, y, z, start, end);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.725f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    @Override
    public int getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        if (this.id != Block.railPowered.id || (blockAccess.getBlockMetadata(x, y, z) & 8) == 0) {
            return -1;
        }
        return BlockRail.texCoordToIndex(0, 16);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (this.isPowered) {
            if (this.id == Block.railPowered.id && (data & 8) == 0) {
                return BlockRail.texCoordToIndex(3, 10);
            }
            if (this.id == Block.railPowered.id) {
                return BlockRail.texCoordToIndex(3, 11);
            }
        } else if (data >= 6) {
            return BlockRail.texCoordToIndex(0, 7);
        }
        return BlockRail.texCoordToIndex(0, 8);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(int meta, Random rand) {
        return 1;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        this.func_4031_h(world, x, y, z, true);
        if (this == Block.railPowered) {
            this.onNeighborBlockChange(world, x, y, z, this.id);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag;
        int i1;
        if (world.isClientSide) {
            return;
        }
        int j1 = i1 = world.getBlockMetadata(x, y, z);
        if (this.isPowered) {
            j1 &= 7;
        }
        boolean bl = flag = !world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
        if (j1 == 2 && !world.canPlaceOnSurfaceOfBlock(x + 1, y, z)) {
            flag = true;
        }
        if (j1 == 3 && !world.canPlaceOnSurfaceOfBlock(x - 1, y, z)) {
            flag = true;
        }
        if (j1 == 4 && !world.canPlaceOnSurfaceOfBlock(x, y, z - 1)) {
            flag = true;
        }
        if (j1 == 5 && !world.canPlaceOnSurfaceOfBlock(x, y, z + 1)) {
            flag = true;
        }
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        } else if (this.id == Block.railPowered.id) {
            boolean flag1 = world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z);
            flag1 = flag1 || this.func_27044_a(world, x, y, z, i1, true, 0) || this.func_27044_a(world, x, y, z, i1, false, 0);
            boolean flag2 = false;
            if (flag1 && (i1 & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, j1 | 8);
                flag2 = true;
            } else if (!flag1 && (i1 & 8) != 0) {
                world.setBlockMetadataWithNotify(x, y, z, j1);
                flag2 = true;
            }
            if (flag2) {
                world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
                if (j1 == 2 || j1 == 3 || j1 == 4 || j1 == 5) {
                    world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
                }
            }
        } else if (blockId > 0 && Block.blocksList[blockId].canProvidePower() && !this.isPowered && RailLogic.getNAdjacentTracks(new RailLogic(this, world, x, y, z)) == 3) {
            this.func_4031_h(world, x, y, z, false);
        }
    }

    private void func_4031_h(World world, int i, int j, int k, boolean flag) {
        if (world.isClientSide) {
            return;
        }
        new RailLogic(this, world, i, j, k).func_792_a(world.isBlockIndirectlyGettingPowered(i, j, k), flag);
    }

    private boolean func_27044_a(World world, int i, int j, int k, int l, boolean flag, int i1) {
        if (i1 >= 8) {
            return false;
        }
        int j1 = l & 7;
        boolean flag1 = true;
        switch (j1) {
            case 0: {
                if (flag) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (flag) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (flag) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag1 = false;
                }
                j1 = 1;
                break;
            }
            case 3: {
                if (flag) {
                    --i;
                    ++j;
                    flag1 = false;
                } else {
                    ++i;
                }
                j1 = 1;
                break;
            }
            case 4: {
                if (flag) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag1 = false;
                }
                j1 = 0;
                break;
            }
            case 5: {
                if (flag) {
                    ++k;
                    ++j;
                    flag1 = false;
                } else {
                    --k;
                }
                j1 = 0;
            }
        }
        if (this.func_27043_a(world, i, j, k, flag, i1, j1)) {
            return true;
        }
        return flag1 && this.func_27043_a(world, i, j - 1, k, flag, i1, j1);
    }

    private boolean func_27043_a(World world, int i, int j, int k, boolean flag, int l, int i1) {
        int j1 = world.getBlockId(i, j, k);
        if (j1 == Block.railPowered.id) {
            int k1 = world.getBlockMetadata(i, j, k);
            int l1 = k1 & 7;
            if (i1 == 1 && (l1 == 0 || l1 == 4 || l1 == 5)) {
                return false;
            }
            if (i1 == 0 && (l1 == 1 || l1 == 2 || l1 == 3)) {
                return false;
            }
            if ((k1 & 8) != 0) {
                if (world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k)) {
                    return true;
                }
                return this.func_27044_a(world, i, j, k, k1, flag, l + 1);
            }
        }
        return false;
    }

    @Override
    public int getPistonPushReaction() {
        return 0;
    }

    public static boolean isPoweredBlockRail(BlockRail blockrail) {
        return blockrail != null && blockrail.isPowered;
    }
}

