/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockSlab
extends Block {
    private Block modelBlock;
    private int modelBlockMetadata;

    public BlockSlab(Block modelBlock, int id) {
        this(modelBlock, id, 0);
    }

    public BlockSlab(Block modelBlock, int id, int modelBlockMetadata) {
        super("slab." + modelBlock.key.substring(5), id, modelBlock.blockMaterial);
        this.atlasIndices = modelBlock.atlasIndices;
        this.modelBlock = modelBlock;
        this.modelBlockMetadata = modelBlockMetadata;
        this.withHardness(modelBlock.blockHardness);
        this.withBlastResistance(modelBlock.blastResistance / 3.0f);
        this.withLightEmission(lightEmission[modelBlock.id]);
        this.withLightBlock(1);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 3;
        if (l == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else if (l == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (l == 2) {
            this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 3;
        if (l == 0) {
            return AABB.getBoundingBoxFromPool(x, y, z, (float)x + 1.0f, (float)y + 0.5f, (float)z + 1.0f);
        }
        if (l == 1) {
            return AABB.getBoundingBoxFromPool(x, y, z, x + 1, (float)y + 1.0f, (float)z + 1.0f);
        }
        return AABB.getBoundingBoxFromPool(x, (float)y + 0.5f, z, (float)x + 1.0f, (float)y + 1.0f, (float)z + 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return (meta & 3) == 1;
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return (meta & 3) != 0;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        ItemStack[] result = this.modelBlock.getBreakResult(world, dropCause, x, y, z, this.modelBlockMetadata, tileEntity);
        if (result != null) {
            for (ItemStack stack : result) {
                if (stack.itemID != this.modelBlock.id) continue;
                stack.setMetadata(meta & 0xF0);
                stack.itemID = this.id;
                stack.stackSize = (meta & 3) == 1 && dropCause != EnumDropCause.PICK_BLOCK ? 2 : 1;
            }
        }
        return result;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(side, this.modelBlockMetadata);
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(side, this.modelBlockMetadata);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3d entityVelocity) {
        this.modelBlock.handleEntityInside(world, x, y, z, entity, entityVelocity);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return this.modelBlock.canCollideCheck(meta, shouldCollideWithFluids);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.getBlockId(x, y - 1, z) == this.id || world.getBlockId(x, y + 1, z) == this.id || super.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.modelBlock.onEntityWalking(world, x, y, z, entity);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.modelBlock.updateTick(world, x, y, z, rand);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        return this.modelBlock.blockActivated(world, x, y, z, player);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
        this.modelBlock.onBlockDestroyedByExplosion(world, x, y, z);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        Direction dir = entity.getVerticalPlacementDirection(side, sideHeight);
        if (dir == Direction.DOWN) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
        }
        if (dir == Direction.UP) {
            world.setBlockMetadataWithNotify(x, y, z, 2);
        }
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        this.onNeighborBlockChange(world, x, y, z, 0);
        this.modelBlock.onBlockAdded(world, x, y, z);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public float getBlastResistance(Entity entity) {
        return this.modelBlock.getBlastResistance(entity);
    }

    @Override
    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return this.modelBlock.getBlockBrightness(blockAccess, x, y, z);
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.modelBlock.onBlockClicked(world, x, y, z, player);
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        this.modelBlock.randomDisplayTick(world, x, y, z, rand);
    }
}

