/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityFlying
extends EntityLiving {
    public EntityFlying(World world) {
        super(world);
    }

    @Override
    protected void causeFallDamage(float f) {
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        if (this.isInWater()) {
            this.moveRelative(moveStrafing, moveForward, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.8;
            this.yd *= 0.8;
            this.zd *= 0.8;
        } else if (this.isInLava()) {
            this.moveRelative(moveStrafing, moveForward, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.5;
            this.yd *= 0.5;
            this.zd *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int i = this.world.getBlockId(MathHelper.floor_double(this.x), MathHelper.floor_double(this.bb.minY) - 1, MathHelper.floor_double(this.z));
                if (i > 0) {
                    f2 = Block.blocksList[i].movementScale * 0.91f;
                }
            }
            float f3 = 0.1627714f / (f2 * f2 * f2);
            this.moveRelative(moveStrafing, moveForward, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int j = this.world.getBlockId(MathHelper.floor_double(this.x), MathHelper.floor_double(this.bb.minY) - 1, MathHelper.floor_double(this.z));
                if (j > 0) {
                    f2 = Block.blocksList[j].movementScale * 0.91f;
                }
            }
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)f2;
            this.yd *= (double)f2;
            this.zd *= (double)f2;
        }
        this.prevLimbYaw = this.limbYaw;
        double d = this.x - this.xo;
        double d1 = this.z - this.zo;
        float f4 = MathHelper.sqrt_double(d * d + d1 * d1) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.limbYaw += (f4 - this.limbYaw) * 0.4f;
        this.limbSwing += this.limbYaw;
    }

    @Override
    public boolean canClimb() {
        return false;
    }
}

