/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;

public class EntityArmoredZombie
extends EntityZombie {
    private final boolean isHoldingSword;
    private static final ItemStack defaultHeldItem = new ItemStack(Item.toolSwordIron, 1);

    public EntityArmoredZombie(World world) {
        super(world);
        this.skinName = "zombie_armored";
        Random rand = new Random();
        this.isHoldingSword = rand.nextInt(5) == 0;
        this.attackStrength = this.isHoldingSword ? 4 : 2;
        ArrayList<Integer> armorItems = new ArrayList<Integer>();
        armorItems.add(0);
        armorItems.add(1);
        armorItems.add(2);
        armorItems.add(3);
        int[] armorBreakOrder = new int[4];
        for (int i = 0; i < 4; ++i) {
            int index = rand.nextInt(armorItems.size());
            armorBreakOrder[i] = (Integer)armorItems.get(index);
            armorItems.remove(index);
        }
        this.setArmorBreakOrder(armorBreakOrder);
        int[] armorBreakPoints = new int[4];
        for (int i = 0; i < 4; ++i) {
            armorBreakPoints[i] = 30 - 10 * i + rand.nextInt(10);
        }
        this.setArmorBreakPoints(armorBreakPoints);
        this.scoreValue = 1000;
    }

    @Override
    public void init() {
        this.entityData.define(6, 0);
        this.entityData.define(7, (short)0);
    }

    @Override
    public int getMaxHealth() {
        return 40;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        int lastHealth = this.getHealth();
        boolean result = super.hurt(attacker, i, type);
        for (int j = 0; j < 4; ++j) {
            int[] armorBreakPoints = this.getArmorBreakPoints();
            if (this.getHealth() > armorBreakPoints[j] || lastHealth <= armorBreakPoints[j]) continue;
            int numChainlinks = this.random.nextInt(2);
            for (int k = 0; k < numChainlinks; ++k) {
                EntityItem entityitem = this.spawnAtLocation(new ItemStack(Item.chainlink), 1.0f);
                entityitem.yd += (double)(this.random.nextFloat() * 0.05f);
                entityitem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                entityitem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            }
        }
        return result;
    }

    public void setArmorBreakPoints(int[] breakPoints) {
        int value = breakPoints[0];
        value |= breakPoints[1] << 6;
        value |= breakPoints[2] << 12;
        this.entityData.set(6, value |= breakPoints[3] << 18);
    }

    public int[] getArmorBreakPoints() {
        int value = this.entityData.getInt(6);
        return new int[]{value & 0x3F, (value & 0xFC0) >> 6, (value & 0x3F000) >> 12, (value & 0xFC0000) >> 18};
    }

    public void setArmorBreakOrder(int[] breakPoints) {
        short value = (short)breakPoints[0];
        value = (short)(value | (short)(breakPoints[1] << 2));
        value = (short)(value | (short)(breakPoints[2] << 4));
        value = (short)(value | (short)(breakPoints[3] << 6));
        this.entityData.set(7, value);
    }

    public int[] getArmorBreakOrder() {
        short value = this.entityData.getShort(7);
        return new int[]{value & 3, (value & 0xC) >> 2, (value & 0x30) >> 4, (value & 0xC0) >> 6};
    }

    @Override
    public ItemStack getHeldItem() {
        if (this.isHoldingSword) {
            return defaultHeldItem;
        }
        return null;
    }
}

