/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class NicknameCommand
extends ServerCommand {
    public NicknameCommand(MinecraftServer server) {
        super(server, "nickname", "nick");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender.getPlayer();
        if (args[0].equalsIgnoreCase("set")) {
            if (!sender.isPlayer()) {
                throw new CommandError("Must be used by a player!");
            }
            if (args.length == 1) {
                throw new CommandError("Enter a nickname!");
            }
            StringBuilder enteredNicknameStr = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                enteredNicknameStr.append(args[i]).append(" ");
            }
            String enteredNickname = enteredNicknameStr.substring(0, enteredNicknameStr.length() - 1);
            if (enteredNickname.length() > 16) {
                enteredNickname = enteredNickname.substring(0, 16);
            }
            player.nickname = enteredNickname;
            player.hadNicknameSet = true;
            player.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("You set your nickname to " + player.getDisplayName());
            return true;
        }
        if (args[0].equalsIgnoreCase("get")) {
            if (!sender.isPlayer()) {
                throw new CommandError("Must be used by a player!");
            }
            if (args.length != 1) {
                return false;
            }
            sender.sendMessage("Your nickname is " + player.getDisplayName());
            return true;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            if (!sender.isPlayer()) {
                throw new CommandError("Must be used by a player!");
            }
            if (args.length != 1) {
                return false;
            }
            player.nickname = "";
            player.hadNicknameSet = true;
            player.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("You cleared your nickname.");
            return true;
        }
        player = (EntityPlayerMP)handler.getPlayer(args[0]);
        if (player == null) {
            throw new CommandError("Unknown username!");
        }
        if (args.length < 2) {
            return false;
        }
        if (!sender.isAdmin() && !sender.isConsole()) {
            return false;
        }
        if (args[1].equalsIgnoreCase("set")) {
            if (args.length < 3) {
                return false;
            }
            StringBuilder enteredNicknameStr = new StringBuilder();
            for (int i = 2; i < args.length; ++i) {
                enteredNicknameStr.append(args[i]).append(" ");
            }
            String enteredNickname = enteredNicknameStr.substring(0, enteredNicknameStr.length() - 1);
            if (enteredNickname.length() > 16) {
                enteredNickname = enteredNickname.substring(0, 16);
            }
            player.nickname = enteredNickname;
            player.hadNicknameSet = true;
            player.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("Set " + player.username + "'s nickname to " + player.getDisplayName());
            handler.sendMessageToPlayer(player, "Your nickname was set to " + player.getDisplayName());
            return true;
        }
        if (args[1].equalsIgnoreCase("get")) {
            if (args.length != 2) {
                return false;
            }
            sender.sendMessage("" + player.username + "'s nickname is " + player.getDisplayName());
            return true;
        }
        if (args[1].equalsIgnoreCase("clear")) {
            if (args.length != 2) {
                return false;
            }
            player.nickname = "";
            player.hadNicknameSet = true;
            player.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("Cleared " + player.username + "'s nickname.");
            handler.sendMessageToPlayer(player, "Your nickname was cleared.");
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/nickname set <value>");
        sender.sendMessage("/nickname get");
        sender.sendMessage("/nickname clear");
        if (sender.isConsole() || sender.isAdmin()) {
            sender.sendMessage("/nickname <username> set <value>");
            sender.sendMessage("/nickname <username> get");
            sender.sendMessage("/nickname <username> clear");
        }
    }
}

