/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;

public class Packet21PickupSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public byte roll;
    public int itemID;
    public int count;
    public int itemDamage;
    public CompoundTag tag;

    public Packet21PickupSpawn() {
    }

    public Packet21PickupSpawn(EntityItem entityitem) {
        this.entityId = entityitem.id;
        this.itemID = entityitem.item.itemID;
        this.count = entityitem.item.stackSize;
        this.itemDamage = entityitem.item.getMetadata();
        this.tag = entityitem.item.getData();
        this.xPosition = MathHelper.floor_double(entityitem.x * 32.0);
        this.yPosition = MathHelper.floor_double(entityitem.y * 32.0);
        this.zPosition = MathHelper.floor_double(entityitem.z * 32.0);
        this.rotation = (byte)(entityitem.xd * 128.0);
        this.pitch = (byte)(entityitem.yd * 128.0);
        this.roll = (byte)(entityitem.zd * 128.0);
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.itemID = dis.readShort();
        this.count = dis.readByte();
        this.itemDamage = dis.readShort();
        this.tag = Packet21PickupSpawn.readCompressedCompoundTag(dis);
        this.xPosition = dis.readInt();
        this.yPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.rotation = dis.readByte();
        this.pitch = dis.readByte();
        this.roll = dis.readByte();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeShort(this.itemID);
        dos.writeByte(this.count);
        dos.writeShort(this.itemDamage);
        Packet21PickupSpawn.writeCompressedCompoundTag(this.tag, dos);
        dos.writeInt(this.xPosition);
        dos.writeInt(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeByte(this.rotation);
        dos.writeByte(this.pitch);
        dos.writeByte(this.roll);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePickupSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 24;
    }
}

