/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;

public class CreativeInventoryCategories {
    public static final List<Object> members = new ArrayList<Object>();

    private static void addItem(Item item, int metadata) {
        for (Object member : members) {
            ItemStack stack;
            if (!(member instanceof ItemStack) || (stack = (ItemStack)member).getItem() != item || stack.getMetadata() != metadata) continue;
            return;
        }
        members.add(new ItemStack(item, 1, metadata));
    }

    private static void addItem(Item item) {
        CreativeInventoryCategories.addItem(item, 0);
    }

    private static void addItems(Item item, int ... metadatas) {
        for (int metadata : metadatas) {
            CreativeInventoryCategories.addItem(item, metadata);
        }
    }

    private static void addItems(Item item, int minMetadata, int maxMetadata) {
        for (int metadata = minMetadata; metadata <= maxMetadata; ++metadata) {
            CreativeInventoryCategories.addItem(item, metadata);
        }
    }

    private static void addItem(Block block, int metadata) {
        CreativeInventoryCategories.addItem(Item.itemsList[block.id], metadata);
    }

    private static void addItem(Block block) {
        CreativeInventoryCategories.addItem(block, 0);
    }

    private static void addItems(Block block, int ... metadatas) {
        CreativeInventoryCategories.addItems(Item.itemsList[block.id], metadatas);
    }

    private static void addItems(Block block, int minMetadata, int maxMetadata) {
        CreativeInventoryCategories.addItems(Item.itemsList[block.id], minMetadata, maxMetadata);
    }

    static {
        Category active = new Category("creative.category.stones", Block.stone);
        members.add(active);
        active.addItem(Block.stone);
        active.addItem(Block.basalt);
        active.addItem(Block.limestone);
        active.addItem(Block.granite);
        active.addItem(Block.marble);
        active.addItem(Block.slate);
        active = new Category("creative.inventory.cobblestones", Block.cobbleStone);
        members.add(active);
        active.addItem(Block.cobbleStone);
        active.addItem(Block.cobbleStoneMossy);
        active.addItem(Block.cobbleBasalt);
        active.addItem(Block.cobbleLimestone);
        active.addItem(Block.cobbleGranite);
        active = new Category("creative.inventory.polishedStones", Block.stonePolished);
        members.add(active);
        active.addItem(Block.stonePolished);
        active.addItem(Block.granitePolished);
        active.addItem(Block.limestonePolished);
        active.addItem(Block.basaltPolished);
        active.addItem(Block.slatePolished);
        CreativeInventoryCategories.addItem(Block.pillarMarble);
        CreativeInventoryCategories.addItem(Block.sandstone);
        CreativeInventoryCategories.addItem(Block.planksOak);
        active = new Category("creative.inventory.paintedPlanks", Block.planksOakPainted);
        members.add(active);
        active.addItems(Block.planksOakPainted, 0, 15);
        CreativeInventoryCategories.addItem(Block.fencePlanksOak);
        active = new Category("creative.inventory.paintedFences", Block.fencePlanksOakPainted);
        members.add(active);
        active.addItems(Block.fencePlanksOakPainted, 0, 15);
        CreativeInventoryCategories.addItem(Block.fencegatePlanksOak);
        active = new Category("creative.inventory.paintedFenceGates", Block.fencegatePlanksOakPainted);
        members.add(active);
        active.addItems(Block.fencegatePlanksOakPainted, 0, 15);
    }

    public static class Category {
        public final String languageKey;
        public final Item categoryIcon;
        public final List<ItemStack> categoryItems;
        public boolean expanded;

        public Category(String languageKey, Item categoryIcon) {
            this.languageKey = languageKey;
            this.categoryIcon = categoryIcon;
            this.categoryItems = new ArrayList<ItemStack>();
        }

        public Category(String languageKey, Block categoryIcon) {
            this(languageKey, Item.itemsList[categoryIcon.id]);
        }

        public void addItem(Item item, int metadata) {
            for (ItemStack stack : this.categoryItems) {
                if (stack.getItem() != item || stack.getMetadata() != metadata) continue;
                return;
            }
            this.categoryItems.add(new ItemStack(item, 1, metadata));
        }

        public void addItem(Item item) {
            this.addItem(item, 0);
        }

        public void addItems(Item item, int ... metadatas) {
            for (int metadata : metadatas) {
                this.addItem(item, metadata);
            }
        }

        public void addItems(Item item, int minMetadata, int maxMetadata) {
            for (int metadata = minMetadata; metadata <= maxMetadata; ++metadata) {
                this.addItem(item, metadata);
            }
        }

        public void addItem(Block block, int metadata) {
            this.addItem(Item.itemsList[block.id], metadata);
        }

        public void addItem(Block block) {
            this.addItem(block, 0);
        }

        public void addItems(Block block, int ... metadatas) {
            this.addItems(Item.itemsList[block.id], metadatas);
        }

        public void addItems(Block block, int minMetadata, int maxMetadata) {
            this.addItems(Item.itemsList[block.id], minMetadata, maxMetadata);
        }
    }
}

