/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureLiquid
extends WorldFeature {
    private int liquidBlockId;

    public WorldFeatureLiquid(int i) {
        this.liquidBlockId = i;
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        if (world.getBlockId(x, y + 1, z) != Block.stone.id) {
            return false;
        }
        if (world.getBlockId(x, y - 1, z) != Block.stone.id) {
            return false;
        }
        if (world.getBlockId(x, y, z) != 0 && world.getBlockId(x, y, z) != Block.stone.id) {
            return false;
        }
        int l = 0;
        if (world.getBlockId(x - 1, y, z) == Block.stone.id) {
            ++l;
        }
        if (world.getBlockId(x + 1, y, z) == Block.stone.id) {
            ++l;
        }
        if (world.getBlockId(x, y, z - 1) == Block.stone.id) {
            ++l;
        }
        if (world.getBlockId(x, y, z + 1) == Block.stone.id) {
            ++l;
        }
        int i1 = 0;
        if (world.isAirBlock(x - 1, y, z)) {
            ++i1;
        }
        if (world.isAirBlock(x + 1, y, z)) {
            ++i1;
        }
        if (world.isAirBlock(x, y, z - 1)) {
            ++i1;
        }
        if (world.isAirBlock(x, y, z + 1)) {
            ++i1;
        }
        if (l == 3 && i1 == 1) {
            world.setBlockWithNotify(x, y, z, this.liquidBlockId);
            world.scheduledUpdatesAreImmediate = true;
            Block.blocksList[this.liquidBlockId].updateTick(world, x, y, z, random);
            world.scheduledUpdatesAreImmediate = false;
        }
        return true;
    }
}

