/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;

public class SaveFile
implements Comparable<SaveFile> {
    private final String fileName;
    private final String displayName;
    private final LevelData levelData;
    private final DimensionData[] dimensionData;
    private final long lastTimePlayed;
    private final long sizeOnDisk;
    private final boolean needsConversion;

    public SaveFile(String fileName, String displayName, LevelData levelData, DimensionData[] dimensionData, long lastTimePlayed, long sizeOnDisk, boolean needsConversion) {
        this.fileName = fileName;
        this.displayName = displayName;
        this.lastTimePlayed = lastTimePlayed;
        this.sizeOnDisk = sizeOnDisk;
        this.needsConversion = needsConversion;
        this.levelData = levelData;
        this.dimensionData = dimensionData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    public DimensionData[] getDimensionData() {
        return this.dimensionData;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public boolean getNeedsConversion() {
        return this.needsConversion;
    }

    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public int getMostRecentSave(SaveFile save) {
        if (this.lastTimePlayed < save.lastTimePlayed) {
            return 1;
        }
        if (this.lastTimePlayed > save.lastTimePlayed) {
            return -1;
        }
        return this.fileName.compareTo(save.fileName);
    }

    @Override
    public int compareTo(SaveFile save) {
        return this.getMostRecentSave(save);
    }
}

