/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.core.enums.EnumOS;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class FullscreenHelper {
    private final Minecraft mc;
    private int previousX = 0;
    private int previousY = 0;
    private int previousWidth = 0;
    private int previousHeight = 0;
    private boolean isBorderless;
    private boolean isFullscreen;

    public FullscreenHelper(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.toggle();
        this.updateWindowState();
    }

    public void updateWindowState() {
        try {
            this.update();
            this.mc.resize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void update() throws Exception {
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        boolean borderless = (Boolean)this.mc.gameSettings.borderlessFullscreen.value;
        DisplayMode resolution = null;
        if (!this.isFullscreen) {
            this.previousWidth = Display.getWidth();
            this.previousHeight = Display.getHeight();
            this.previousX = Display.getX();
            this.previousY = Display.getY();
        }
        if (fullscreen) {
            if (resolution == null && borderless) {
                if (Display.isFullscreen()) {
                    Display.setFullscreen((boolean)false);
                }
                if (!this.isBorderless) {
                    this.setBorderless(true);
                    this.isBorderless = true;
                }
                Rectangle rectangle = this.getDisplay();
                System.out.println("Set Borderless Fullscreen: " + rectangle.getWidth() + " x " + rectangle.getHeight());
                this.setPositionAndSize(rectangle);
            } else {
                if (resolution == null) {
                    resolution = Display.getDesktopDisplayMode();
                }
                System.out.println("Set Fullscreen: " + resolution.getWidth() + " x " + resolution.getHeight());
                Display.setDisplayModeAndFullscreen((DisplayMode)resolution);
            }
            this.isFullscreen = true;
            return;
        }
        if (!this.isFullscreen) {
            return;
        }
        if (this.isBorderless) {
            this.setBorderless(false);
            this.isBorderless = false;
        }
        if (Display.isFullscreen()) {
            Display.setFullscreen((boolean)false);
        }
        this.setPositionAndSize(this.previousX, this.previousY, this.previousWidth, this.previousHeight);
        this.setResizable();
        this.isFullscreen = false;
    }

    public void setPositionAndSize(Rectangle rectangle) throws LWJGLException {
        this.setSize((int)rectangle.getWidth(), (int)rectangle.getHeight());
        this.setPosition((int)rectangle.getX(), (int)rectangle.getY());
    }

    public void setPositionAndSize(int x, int y, int w, int h) throws LWJGLException {
        this.setSize(w, h);
        this.setPosition(x, y);
    }

    public void setSize(int width, int height) throws LWJGLException {
        Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
    }

    public void setPosition(int x, int y) {
        Display.setLocation((int)x, (int)y);
    }

    public void setResizable() {
        if (Minecraft.getOs() != EnumOS.macos && !((Boolean)this.mc.gameSettings.disableResize.value).booleanValue()) {
            Display.setResizable((boolean)false);
            Display.setResizable((boolean)true);
        }
    }

    public Rectangle getDisplay() {
        int centerX = Display.getX() + Display.getWidth() / 2;
        int centerY = Display.getY() + Display.getHeight() / 2;
        return this.getDisplayAt(centerX, centerY);
    }

    public Rectangle getDisplayAt(int x, int y) {
        try {
            GraphicsDevice[] devices;
            for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                Rectangle rect = device.getDefaultConfiguration().getBounds();
                if (!rect.contains(x, y)) continue;
                return rect;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            DisplayMode displayMode = Display.getDesktopDisplayMode();
            return new Rectangle(0, 0, displayMode.getWidth(), displayMode.getHeight());
        }
    }

    public void setBorderless(boolean b) {
        System.setProperty("org.lwjgl.opengl.Window.undecorated", String.valueOf(b));
    }
}

