/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.nbt.CompoundTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.GameResolution;
import net.minecraft.client.achievement.stat.StatStringFormatKeyInv;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.entity.ClientSkinVariantList;
import net.minecraft.client.entity.player.EntityClientPlayerMP;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.GuiAchievement;
import net.minecraft.client.gui.GuiBadJavaArch;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConflictWarning;
import net.minecraft.client.gui.GuiConnecting;
import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiException;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiInventory;
import net.minecraft.client.gui.GuiInventoryCreative;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMissingMinecraft;
import net.minecraft.client.gui.GuiOutOfMemory;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.GuiSleepSP;
import net.minecraft.client.gui.MainMenuBackground;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.input.InputHandler;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseInput;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.controller.Joystick;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.client.net.thread.ThreadCheckHasPaid;
import net.minecraft.client.net.thread.ThreadDownloadResources;
import net.minecraft.client.net.thread.ThreadSleepForeverClient;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.InputDevice;
import net.minecraft.client.option.IntegerOption;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.enums.Difficulty;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.client.render.ChunkRenderer;
import net.minecraft.client.render.EffectRenderer;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.LoadingScreenRenderer;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.PostProcessingManager;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.ColorizerFoliage;
import net.minecraft.client.render.colorizer.ColorizerGrass;
import net.minecraft.client.render.colorizer.ColorizerWater;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.client.render.window.GameWindowLWJGL2;
import net.minecraft.client.sound.SoundManager;
import net.minecraft.client.util.debug.Debug;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.client.util.helper.ScreenshotHelper;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.client.world.chunk.provider.ChunkProviderStatic;
import net.minecraft.core.Global;
import net.minecraft.core.HitResult;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.MinecraftError;
import net.minecraft.core.MinecraftException;
import net.minecraft.core.Timer;
import net.minecraft.core.UnexpectedThrowable;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.crafting.legacy.CraftingManager;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumOS;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.command.ClientCommandHandler;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.Session;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.LogPrintStream;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.ScreenShot;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.PortalHandler;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveConverters;
import net.minecraft.core.world.save.SaveFormats;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Minecraft
implements Runnable,
MinecraftAccessor {
    public static final String VERSION = Global.VERSION;
    public static final boolean isMultiplayerDisabled = false;
    public static boolean doPartialTick = true;
    private static Minecraft INSTANCE;
    public PlayerController playerController;
    public boolean hasCrashed;
    public UnexpectedThrowable lastCrash;
    private final Timer timer;
    public World theWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public ICamera activeCamera;
    public EffectRenderer effectRenderer;
    public Session session;
    public String worldPresetName = null;
    public String worldPresetSeed = null;
    public int worldPresetX;
    public int worldPresetY;
    public int worldPresetZ;
    public String minecraftUri;
    public boolean hideQuitButton;
    public volatile boolean isGamePaused;
    public RenderEngine renderEngine;
    public FontRenderer fontRenderer;
    public GuiScreen currentScreen;
    public LoadingScreenRenderer loadingScreen;
    public WorldRenderer worldRenderer;
    public ThreadDownloadResources downloadResourcesThread;
    private int ticksRan;
    public GuiAchievement guiAchievement;
    public GuiIngame ingameGUI;
    public boolean skipRenderWorld;
    public ModelBiped field_9242_w;
    public HitResult objectMouseOver;
    public GameSettings gameSettings;
    public SoundManager sndManager;
    public TexturePackList texturePackList;
    private File mcDataDir;
    private ISaveFormat saveFormat;
    public static int numRecordedFrameTimes;
    public static long hasPaidCheckTime;
    public StatsCounter statsCounter;
    private String serverName;
    private int serverPort;
    private static File minecraftDir;
    public volatile boolean running;
    public String debug;
    public String debugFPS;
    boolean isTakingScreenshot;
    public boolean inGameHasFocus;
    private int mouseTicksRan;
    public boolean isRaining;
    long systemTime;
    private int joinPlayerCounter;
    protected boolean toggleFlyPressed = false;
    protected long flyPressedTime = 0L;
    public float hotbarSwapAnimationProgress = 0.0f;
    public final GameResolution resolution = new GameResolution(this);
    public final ClientCommandHandler commandHandler = new ClientCommandHandler(this);
    public boolean fullbright = false;
    public Renderer render;
    public ControllerInput controllerInput;
    public final MouseInput mouseInput = new MouseInput(this);
    public InputType inputType = InputType.KEYBOARD;
    public final ScreenshotHelper screenshotHelper = new ScreenshotHelper(this);
    private boolean f3Press = false;
    public Thread rpcThread = null;
    public PostProcessingManager ppm = new PostProcessingManager(this);
    private long lastFocusTime;
    public GameWindow gameWindow;
    public ClientSkinVariantList skinVariantList = new ClientSkinVariantList(this);
    public MainMenuBackground mainMenuBackground = new MainMenuBackground(this);
    private boolean gameStarted = false;

    public Minecraft(GameWindow gameWindow) {
        this.gameWindow = gameWindow;
        Global.accessor = this;
        LogPrintStream.setup();
        this.hasCrashed = false;
        this.timer = new Timer(20.0f);
        this.session = null;
        this.hideQuitButton = false;
        this.isGamePaused = false;
        this.currentScreen = null;
        this.loadingScreen = new LoadingScreenRenderer(this);
        this.ticksRan = 0;
        this.guiAchievement = new GuiAchievement(this);
        this.skipRenderWorld = false;
        this.field_9242_w = new ModelBiped(0.0f);
        this.objectMouseOver = null;
        this.sndManager = new SoundManager();
        this.running = true;
        this.debug = "";
        this.isTakingScreenshot = false;
        this.inGameHasFocus = false;
        this.mouseTicksRan = 0;
        this.isRaining = false;
        this.systemTime = System.currentTimeMillis();
        this.joinPlayerCounter = 0;
        new ThreadSleepForeverClient(this, "Timer hack thread");
        INSTANCE = this;
    }

    public void onMinecraftCrash(UnexpectedThrowable throwable) {
        if (!this.gameStarted) {
            this.running = false;
            System.err.println("An exception has occured while trying to start the game!");
            throwable.exception.printStackTrace(System.err);
            this.gameWindow.displayCrashReport(throwable, 1);
            this.hasCrashed = true;
            this.shutdownMinecraftApplet();
            return;
        }
        boolean disableCrashHandler = (Boolean)this.gameSettings.disableCrashHandler.value;
        if (disableCrashHandler) {
            this.running = false;
            System.err.println("An exception has occured, and the crash handler is disabled! The game will now exit!");
            throwable.exception.printStackTrace(System.err);
            this.gameWindow.displayCrashReport(throwable, 1);
            this.hasCrashed = true;
            this.shutdownMinecraftApplet();
            return;
        }
        if (this.hasCrashed) {
            this.running = false;
            System.err.println("An exception has occured while trying to render the crash handler! The game will now exit!");
            throwable.exception.printStackTrace(System.err);
            this.gameWindow.displayCrashReport(throwable, 2);
            this.shutdownMinecraftApplet();
            return;
        }
        Debug.reset();
        throwable.exception.printStackTrace(System.err);
        this.hasCrashed = true;
        this.lastCrash = throwable;
        try {
            if (!this.gameStarted) {
                GuiPopup error = GuiException.createStartupError(throwable.exception, this);
                this.displayGuiScreen(error);
                return;
            }
            if (throwable.exception instanceof RuntimeException) {
                this.changeWorld(null);
                GuiMainMenu guiMainMenu = new GuiMainMenu();
                this.displayGuiScreen(guiMainMenu);
                GuiPopup error = GuiException.create(guiMainMenu, throwable.exception, this);
                this.displayGuiScreen(error);
            } else {
                this.changeWorld(null);
                GuiPopup error = GuiException.createFatal(throwable.exception, this);
                this.displayGuiScreen(error);
            }
        }
        catch (Throwable e) {
            this.onMinecraftCrash(new UnexpectedThrowable("Trying to display crash handler", e));
        }
    }

    public void setServer(String serverName, int serverPort) {
        this.serverName = serverName;
        this.serverPort = serverPort;
    }

    public void startGame() throws LWJGLException {
        this.mcDataDir = this.getMinecraftDir();
        this.gameSettings = new GameSettings(this, this.mcDataDir);
        GameResolution.defaultWidth = (Integer)this.gameSettings.windowWidth.value;
        GameResolution.defaultHeight = (Integer)this.gameSettings.windowHeight.value;
        System.out.println("Resolution: " + GameResolution.defaultWidth + " x " + GameResolution.defaultHeight);
        System.out.println("Java Version: " + System.getProperty("java.version"));
        this.printWrongJavaVersionInfo();
        this.gameWindow.init(this);
        this.resolution.update();
        this.saveFormat = new SaveFormat19134(new File(this.mcDataDir, "saves"));
        I18n.initialize((String)this.gameSettings.language.value);
        if (!((Boolean)this.gameSettings.startInFullscreen.value).booleanValue()) {
            this.gameSettings.fullscreen.value = false;
        }
        this.resolution.getSetGuiScale();
        this.resolution.update();
        Display.setVSyncEnabled((boolean)((Boolean)this.gameSettings.enableVsync.value));
        if (!((Boolean)this.gameSettings.disableResize.value).booleanValue()) {
            this.gameWindow.setResizable(true);
        }
        OpenGLHelper.testCapabilities(this);
        if (Shaders.enableShaders) {
            this.setRenderer(new ShadersRenderer(this));
        } else {
            this.setRenderer(new Renderer(this));
        }
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.renderEngine = new RenderEngine(this, this.texturePackList, this.gameSettings);
        this.loadScreen();
        BiomeProviderOverworld.init();
        ColorizerWater.updateColorData(this.renderEngine.getTextureImageData("/misc/watercolor.png"));
        ColorizerGrass.updateColorData(this.renderEngine.getTextureImageData("/misc/grasscolor.png"));
        ColorizerFoliage.updateColorData(this.renderEngine.getTextureImageData("/misc/foliagecolor.png"));
        this.worldRenderer = new WorldRenderer(this);
        BlockModelDispatcher.getInstance();
        ItemModelDispatcher.getInstance();
        EntityRenderDispatcher.instance.itemRenderer = new ItemRenderer(this);
        this.statsCounter = new StatsCounter(this.session, this.mcDataDir);
        AchievementList.OPEN_INVENTORY.setStatStringFormatter(new StatStringFormatKeyInv(this));
        AchievementList.OPEN_GUIDEBOOK.setStatStringFormatter(s -> {
            if (!this.gameSettings.keyGuidebook.isBound()) {
                return "Set your guidebook keybind in the controls menu!";
            }
            return String.format(s, this.gameSettings.keyGuidebook.getKeyName());
        });
        this.loadScreen();
        StatList.init();
        System.out.println("Initizalizing input");
        try {
            InputHandler.init(this);
            this.controllerInput = InputHandler.getController((String)this.gameSettings.selectedController.value);
        }
        catch (Exception e) {
            System.err.println("Input init error!");
            e.printStackTrace();
        }
        System.out.println("Input done!");
        System.out.println("Setting up OpenGL values...");
        OpenGLHelper.checkError("pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        OpenGLHelper.checkError("startup");
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.loadScreen();
        this.renderEngine.refreshTextures(new ArrayList<Throwable>());
        this.loadScreen();
        System.out.println("Initializing Renderer...");
        TextureRegistry.blockAtlas.bindTexture();
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.resolution.width, (int)this.resolution.height);
        this.effectRenderer = new EffectRenderer(this.theWorld, this.renderEngine);
        try {
            System.out.println("Starting Resource Download Thread...");
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception e) {
            // empty catch block
        }
        OpenGLHelper.checkError("post startup");
        this.ingameGUI = new GuiIngame(this);
        new Registries();
        DataLoader.loadRecipesFromFile("/recipes/blast_furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/trommel.json");
        DataLoader.loadRecipesFromFile("/recipes/workbench.json");
        CraftingManager.getInstance().init();
        DataLoader.loadDataPacks(this);
        Registries.RECIPES_LOCAL_COPY = Registries.RECIPES;
        int recipes = Registries.RECIPES.getAllRecipes().size();
        int groups = Registries.RECIPES.getAllGroups().size();
        int namespaces = Registries.RECIPES.size();
        int itemGroups = Registries.ITEM_GROUPS.size();
        System.out.printf("%d item groups.%n", itemGroups);
        System.out.printf("%d recipes in %d groups in %d namespaces.%n", recipes, groups, namespaces);
        this.loadScreen();
        if (((Boolean)this.gameSettings.discordRichPresence.value).booleanValue()) {
            this.rpcThread = new RichPresenceHandlerThread(this);
            this.rpcThread.start();
        }
        this.gameStarted = true;
        boolean hasBeta173 = true;
        try {
            Class.forName("a");
        }
        catch (Exception e) {
            hasBeta173 = false;
        }
        if (!hasBeta173) {
            this.displayGuiScreen(new GuiMissingMinecraft());
        } else if (System.getProperty("sun.arch.data.model").equals("32")) {
            this.displayGuiScreen(new GuiBadJavaArch());
        } else if (this.serverName != null) {
            this.displayGuiScreen(new GuiConnecting(this, this.serverName, this.serverPort));
        } else if (this.worldPresetName != null && this.worldPresetSeed != null) {
            GuiSelectWorld selectWorldScreen = new GuiSelectWorld(null);
            this.displayGuiScreen(selectWorldScreen);
            selectWorldScreen.deletePresetWorld(this.worldPresetName);
            GuiCreateWorld screen = new GuiCreateWorld(null);
            this.displayGuiScreen(screen);
            screen.runPreset(this.worldPresetName, this.worldPresetSeed, this.worldPresetX, this.worldPresetY, this.worldPresetZ);
        } else {
            this.displayGuiScreen(new GuiMainMenu());
        }
        this.gameWindow.updateWindowState();
    }

    private void printWrongJavaVersionInfo() {
        String javaVersion = System.getProperty("java.version");
        if (Minecraft.getOs() != EnumOS.linux || javaVersion == null) {
            return;
        }
        try {
            int major = Integer.parseInt(javaVersion.split(".")[0]);
            if (major > 8) {
                System.out.println("Detected a probably incompatible Java version. If the game crashes with a message similar to \n\"Inconsistency detected by ld.so: dl-lookup.c: 111: check_match: Assertion `version->filename == NULL || ! _dl_name_match_p (version->filename, map)' failed!\", \nuse Java 8!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadScreen() throws LWJGLException {
        System.out.println("Drawing Loading Screen...");
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.resolution.scaledWidthExact, (double)this.resolution.scaledHeightExact, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.resolution.width, (int)this.resolution.height);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        Random mojrand = new Random();
        if (mojrand.nextInt(200) == 0) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/title/majonk.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/title/mojang.png"));
        }
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV(0.0, this.resolution.height, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.resolution.width, this.resolution.height, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.resolution.width, 0.0, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int width = 256;
        int height = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.setColorOpaque_I(0xFFFFFF);
        this.drawMojangLogoVertices((this.resolution.scaledWidth - width) / 2, (this.resolution.scaledHeight - height) / 2, 0, 0, width, height);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void drawMojangLogoVertices(int minX, int minY, int minU, int minV, int width, int height) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(minX + 0, minY + height, 0.0, (float)(minU + 0) * scaleX, (float)(minV + height) * scaleY);
        tessellator.addVertexWithUV(minX + width, minY + height, 0.0, (float)(minU + width) * scaleX, (float)(minV + height) * scaleY);
        tessellator.addVertexWithUV(minX + width, minY + 0, 0.0, (float)(minU + width) * scaleX, (float)(minV + 0) * scaleY);
        tessellator.addVertexWithUV(minX + 0, minY + 0, 0.0, (float)(minU + 0) * scaleX, (float)(minV + 0) * scaleY);
        tessellator.draw();
    }

    @Override
    public File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = Minecraft.getAppDir("minecraft-bta");
        }
        return minecraftDir;
    }

    @Override
    public String getMinecraftVersion() {
        return VERSION;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return new ChunkProviderStatic(world, chunkLoader, world.getWorldType().createChunkGenerator(world));
    }

    public static File getAppDir(String s) {
        File appDir;
        String homeDirPath = System.getProperty("user.home", ".");
        switch (Minecraft.getOs()) {
            case linux: 
            case solaris: {
                appDir = new File(homeDirPath, '.' + s + '/');
                break;
            }
            case windows: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    appDir = new File(s2, "." + s + '/');
                    break;
                }
                appDir = new File(homeDirPath, '.' + s + '/');
                break;
            }
            case macos: {
                appDir = new File(homeDirPath, "Library/Application Support/" + s);
                break;
            }
            default: {
                appDir = new File(homeDirPath, s + '/');
            }
        }
        if (!appDir.exists() && !appDir.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + appDir);
        }
        return appDir;
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris") || s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux") || s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public ISaveFormat getSaveFormat() {
        return this.saveFormat;
    }

    public void displayGuiScreen(GuiScreen guiscreen) {
        if (this.currentScreen == null && guiscreen != null && this.controllerInput != null) {
            this.controllerInput.cursorX = (double)this.resolution.scaledWidth / 2.0;
            this.controllerInput.cursorY = (double)this.resolution.scaledHeight / 2.0;
        }
        if (this.currentScreen != null) {
            this.currentScreen.onClosed();
        }
        if (guiscreen instanceof GuiMainMenu) {
            this.statsCounter.func_27175_b();
        }
        if (this.statsCounter != null) {
            this.statsCounter.syncStats();
        }
        if (guiscreen == null && this.theWorld == null) {
            guiscreen = new GuiMainMenu();
        } else if (guiscreen == null && this.thePlayer.getHealth() <= 0) {
            guiscreen = new GuiGameOver();
        }
        if (guiscreen instanceof GuiMainMenu) {
            this.ingameGUI.clearChatMessages();
        }
        this.currentScreen = guiscreen;
        if (guiscreen != null) {
            this.setIngameNotInFocus();
            guiscreen.setWorldAndResolution(this, this.resolution.scaledWidth, this.resolution.scaledHeight);
            this.skipRenderWorld = false;
        } else {
            this.setIngameFocus();
        }
    }

    public void shutdownMinecraftApplet() {
        try {
            try {
                if (this.gameSettings != null) {
                    this.gameSettings.saveOptions();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.statsCounter != null) {
                this.statsCounter.func_27175_b();
                this.statsCounter.syncStats();
            }
            System.out.println("Stopping!");
            try {
                this.changeWorld(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                GLAllocation.deleteTexturesAndDisplayLists();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.sndManager != null) {
                this.sndManager.closeMinecraft();
            }
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
        }
        System.gc();
        if (!this.hasCrashed) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            this.startGame();
        }
        catch (Throwable e) {
            this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", e));
        }
        try {
            long currentTime = System.currentTimeMillis();
            int fpsCounter = 0;
            while (this.running) {
                try {
                    long now;
                    long sleepTime;
                    Debug.reset();
                    Debug.push("update");
                    Debug.push("misc");
                    long tickStartTime = System.currentTimeMillis();
                    Time.tick();
                    AABB.initializePool();
                    Vec3d.initializePool();
                    if (Display.isCloseRequested()) {
                        this.shutdown();
                    }
                    if (this.isGamePaused && this.theWorld != null && !(this.currentScreen instanceof GuiModelViewer)) {
                        float temp = this.timer.partialTicks;
                        this.timer.advanceTime();
                        this.timer.partialTicks = temp;
                    } else {
                        this.timer.advanceTime();
                    }
                    if (!doPartialTick) {
                        this.timer.partialTicks = 1.0f;
                    }
                    long nanoTime = System.nanoTime();
                    this.mouseInput.update();
                    if (this.controllerInput != null && this.currentScreen != null) {
                        this.controllerInput.moveCursor();
                    }
                    Debug.pop();
                    Debug.change("tick");
                    for (int tick = 0; tick < this.timer.frames; ++tick) {
                        ++this.ticksRan;
                        try {
                            this.runTick();
                            continue;
                        }
                        catch (MinecraftException e) {
                            this.theWorld = null;
                            this.changeWorld(null);
                            this.displayGuiScreen(new GuiConflictWarning());
                        }
                    }
                    Debug.change("update");
                    Debug.push("misc");
                    OpenGLHelper.checkError("pre render");
                    RenderBlocks.fancyGrass = (Integer)this.gameSettings.fancyGraphics.value == 1;
                    EntityItem.enableItemClumping = (Boolean)this.gameSettings.enableItemClumping.value;
                    BlockLeavesBase.enableTreeShadowing = (Boolean)this.gameSettings.treeShadows.value;
                    this.sndManager.updateListenerPosition(this.thePlayer, this.timer.partialTicks);
                    GL11.glEnable((int)3553);
                    if (this.theWorld != null) {
                        Debug.change("updatelight");
                        this.theWorld.updatingLighting();
                        Debug.change("misc");
                    }
                    Debug.change("misc");
                    if (this.thePlayer != null && this.thePlayer.isInWall()) {
                        this.gameSettings.thirdPersonView.value = 0;
                    }
                    Debug.change("displayupdate");
                    Display.update();
                    Debug.change("render");
                    Debug.push("post");
                    this.render.beginRenderGame(this.timer.partialTicks);
                    GL11.glEnable((int)3008);
                    Debug.change("misc");
                    if (!this.skipRenderWorld) {
                        if (this.playerController != null) {
                            this.playerController.render(this.timer.partialTicks);
                        }
                        this.worldRenderer.updateCameraAndRender(this.timer.partialTicks);
                    }
                    if (((Boolean)this.gameSettings.pauseOnLostFocus.value).booleanValue()) {
                        if (!Display.isActive()) {
                            if (System.currentTimeMillis() > this.lastFocusTime + 250L) {
                                this.displayInGameMenu();
                            }
                        } else {
                            this.lastFocusTime = System.currentTimeMillis();
                        }
                    }
                    this.sndManager.setMuted((Boolean)this.gameSettings.muteOnLostFocus.value != false && !Display.isActive());
                    this.guiAchievement.updateAchievementWindow();
                    Debug.change("post");
                    this.render.endRenderGame(this.timer.partialTicks);
                    Debug.pop();
                    Debug.change("misc");
                    if (Display.wasResized()) {
                        this.resize();
                    }
                    OpenGLHelper.checkError("post render");
                    ++fpsCounter;
                    boolean bl = this.isGamePaused = !this.isMultiplayerWorld() && this.currentScreen != null && this.currentScreen.pausesGame();
                    while (System.currentTimeMillis() >= currentTime + 1000L) {
                        this.debug = fpsCounter + " fps, " + ChunkRenderer.chunksUpdated + " chunk updates";
                        this.debugFPS = fpsCounter + " fps";
                        ChunkRenderer.chunksUpdated = 0;
                        currentTime += 1000L;
                        fpsCounter = 0;
                    }
                    if (this.theWorld == null && (sleepTime = 16L - ((now = System.currentTimeMillis()) - tickStartTime) - 1L) > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    Debug.pop();
                    Debug.pop();
                    if (((Boolean)this.gameSettings.showFrameTimes.value).booleanValue()) {
                        DebugRender.render(this.fontRenderer);
                    }
                    this.screenshotListener();
                }
                catch (MinecraftException minecraftexception) {
                    this.theWorld = null;
                    this.changeWorld(null);
                    this.displayGuiScreen(new GuiConflictWarning());
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    this.freeUpMemory();
                    this.displayGuiScreen(new GuiOutOfMemory());
                    System.gc();
                }
                catch (Throwable throwable) {
                    this.freeUpMemory();
                    this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", throwable));
                }
            }
        }
        catch (MinecraftError minecraftError) {
        }
        finally {
            this.shutdownMinecraftApplet();
        }
    }

    public void freeUpMemory() {
        try {
            this.renderGlobal.deleteRenderListBase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AABB.deinitializePool();
            Vec3d.deinitializePool();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (this.gameSettings.keyScreenshot.isPressed()) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                boolean ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                Debug.push("screenshot");
                if (ctrl) {
                    if (Shaders.enableShaders) {
                        try {
                            this.screenshotHelper.takePanoramaScreenshot();
                            this.ingameGUI.addChatMessage("Saved panorama screenshot!");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.ingameGUI.addChatMessage(ScreenShot.saveScreenshot(minecraftDir, this.resolution.width, this.resolution.height));
                }
                Debug.pop();
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (!Display.isActive()) {
            return;
        }
        if (!this.inGameHasFocus) {
            this.inGameHasFocus = true;
            this.mouseInput.grabCursor();
            this.displayGuiScreen(null);
            this.mouseTicksRan = this.ticksRan + 10000;
            if (this.thePlayer != null) {
                this.thePlayer.input.onGameFocused();
            }
        }
    }

    public void setIngameNotInFocus() {
        if (!this.inGameHasFocus) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.input.onGameUnfocused();
        }
        this.inGameHasFocus = false;
        if (this.inputType == InputType.KEYBOARD) {
            this.mouseInput.releaseCursor();
        }
        this.worldRenderer.zooming = false;
    }

    public void displayInGameMenu() {
        if (this.currentScreen == null) {
            this.displayGuiScreen(new GuiIngameMenu());
        }
    }

    private void mineBlocks(int i, boolean flag) {
        if (flag && this.objectMouseOver != null && this.objectMouseOver.hitType == HitResult.HitType.TILE && i == 0) {
            int blockX = this.objectMouseOver.x;
            int blockY = this.objectMouseOver.y;
            int blockZ = this.objectMouseOver.z;
            this.playerController.continueDestroyBlock(blockX, blockY, blockZ, this.objectMouseOver.side);
        } else {
            this.playerController.stopDestroyBlock(flag);
        }
    }

    private void clickMouse(int clickType, boolean attack, boolean repeat) {
        ItemStack itemstack;
        this.mouseTicksRan = this.ticksRan;
        boolean flag = true;
        if (this.objectMouseOver == null) {
            if (clickType == 0 && attack) {
                this.playerController.swingItem(true);
            }
        } else if (this.objectMouseOver.hitType == HitResult.HitType.ENTITY) {
            if (clickType == 0 && attack) {
                this.playerController.swingItem(true);
                this.playerController.attack(this.thePlayer, this.objectMouseOver.entity);
            }
            if (clickType == 1) {
                this.playerController.interact(this.thePlayer, this.objectMouseOver.entity);
            }
        } else if (this.objectMouseOver.hitType == HitResult.HitType.TILE) {
            int blockX = this.objectMouseOver.x;
            int blockY = this.objectMouseOver.y;
            int blockZ = this.objectMouseOver.z;
            Side side = this.objectMouseOver.side;
            double yPlaced = this.objectMouseOver.location.yCoord - (double)this.objectMouseOver.y;
            double xPlaced = side.getAxis() == Axis.X ? this.objectMouseOver.location.xCoord - (double)this.objectMouseOver.x : (side.getAxis() == Axis.Z ? this.objectMouseOver.location.zCoord - (double)this.objectMouseOver.z : this.objectMouseOver.location.xCoord - (double)this.objectMouseOver.x);
            if (clickType == 0) {
                this.playerController.startDestroyBlock(blockX, blockY, blockZ, this.objectMouseOver.side, repeat);
                this.playerController.swingItem(true);
            } else {
                int numItemsInStack;
                ItemStack stack = this.thePlayer.inventory.getCurrentItem();
                int n = numItemsInStack = stack == null ? 0 : stack.stackSize;
                if (this.playerController.useItemOn(this.thePlayer, this.theWorld, stack, blockX, blockY, blockZ, side, xPlaced, yPlaced)) {
                    flag = false;
                    this.playerController.swingItem(true);
                }
                if (stack == null) {
                    return;
                }
                if (stack.stackSize <= 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                } else if (stack.stackSize != numItemsInStack) {
                    this.worldRenderer.itemRenderer.resetEquippedProgress();
                }
            }
        }
        if (flag && clickType == 1 && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.useItem(this.thePlayer, this.theWorld, itemstack)) {
            this.worldRenderer.itemRenderer.resetEquippedProgress();
        }
    }

    public void resize() {
        this.resolution.update();
        if (this.currentScreen != null) {
            this.currentScreen.setWorldAndResolution(this, this.resolution.scaledWidth, this.resolution.scaledHeight);
        }
    }

    private void clickMiddleMouseButton() {
        HitResult mouseOver = this.thePlayer.rayTrace(256.0, this.timer.partialTicks);
        if (mouseOver != null && mouseOver.hitType == HitResult.HitType.TILE) {
            int x = mouseOver.x;
            int y = mouseOver.y;
            int z = mouseOver.z;
            this.thePlayer.pickBlock(x, y, z);
        }
    }

    private void startCheckPaidThread() {
        new ThreadCheckHasPaid(this).start();
    }

    public void runTick() {
        IChunkProvider chunkProvider;
        if (this.ticksRan == 6000) {
            this.startCheckPaidThread();
        }
        this.statsCounter.func_27178_d();
        this.ingameGUI.updateTick();
        this.worldRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null && (chunkProvider = this.theWorld.getChunkProvider()) instanceof ChunkProviderStatic) {
            ChunkProviderStatic chunkproviderloadorgenerate = (ChunkProviderStatic)chunkProvider;
            int playerChunkX = MathHelper.floor_float((int)this.thePlayer.x) >> 4;
            int playerChunkZ = MathHelper.floor_float((int)this.thePlayer.z) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(playerChunkX, playerChunkZ);
        }
        if (this.theWorld != null) {
            boolean bl = this.theWorld.updateAllOnLightChange = !LightmapHelper.isLightmapEnabled();
        }
        if (!this.isGamePaused && this.theWorld != null) {
            this.playerController.tick();
        }
        TextureRegistry.blockAtlas.bindTexture();
        if (!this.isGamePaused) {
            this.renderEngine.updateDynamicTextures();
        }
        if (this.currentScreen == null && this.thePlayer != null) {
            if (this.thePlayer.getHealth() <= 0) {
                this.displayGuiScreen(null);
            } else if (this.thePlayer.isPlayerSleeping() && this.theWorld != null) {
                if (this.theWorld.isClientSide) {
                    this.displayGuiScreen(new GuiSleepMP());
                } else {
                    this.displayGuiScreen(new GuiSleepSP());
                }
            }
        } else if (this.currentScreen != null && this.currentScreen instanceof GuiSleepMP && !this.thePlayer.isPlayerSleeping()) {
            this.displayGuiScreen(null);
        }
        if (this.currentScreen != null) {
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null && this.inputType == InputType.CONTROLLER && (this.mouseInput.deltaX != 0.0 || this.mouseInput.deltaY != 0.0)) {
            this.setInputType(InputType.KEYBOARD);
        }
        if (this.currentScreen != null) {
            this.currentScreen.handleInput();
            if (this.currentScreen != null) {
                this.currentScreen.tick();
            }
        }
        if (this.currentScreen == null || this.currentScreen.allowIngameInput) {
            boolean placeBlockPressed;
            while (Mouse.next()) {
                long delta = System.currentTimeMillis() - this.systemTime;
                if (delta > 200L) continue;
                int scrollDelta = Mouse.getEventDWheel();
                if (scrollDelta != 0) {
                    if (this.thePlayer.noPhysics && this.toggleFlyPressed) {
                        float steps = 20.0f;
                        int step = Math.round(((Float)this.gameSettings.flightSpeed.value).floatValue() * 20.0f);
                        float newSpeed = (float)(step += MathHelper.clamp(scrollDelta, -1, 1)) / 20.0f;
                        newSpeed = MathHelper.clamp(newSpeed, 0.0f, 1.0f);
                        this.gameSettings.flightSpeed.value = Float.valueOf(newSpeed);
                        this.thePlayer.setFlySpeed(newSpeed);
                        this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.flightSpeed);
                    } else if (!this.gameSettings.keyZoom.isPressed()) {
                        this.thePlayer.inventory.changeCurrentItem(scrollDelta);
                    }
                }
                if (!this.inGameHasFocus && Mouse.getEventButtonState()) {
                    this.setIngameFocus();
                    continue;
                }
                if (!this.checkBoundInputs(InputDevice.MOUSE) || Mouse.isGrabbed() || this.inputType != InputType.KEYBOARD || this.currentScreen != null) continue;
                this.mouseInput.grabCursor();
            }
            if (this.toggleFlyPressed && !this.gameSettings.keyFly.isPressed()) {
                this.toggleFlyPressed = false;
                if (this.flyPressedTime + 400L > System.currentTimeMillis()) {
                    this.thePlayer.setNoclip(!this.thePlayer.noPhysics);
                }
            }
            while (Keyboard.next()) {
                boolean control;
                if (Keyboard.getEventKeyState() && ((Boolean)this.gameSettings.showFrameTimes.value).booleanValue() && DebugRender.keyPressed(Keyboard.getEventKey())) continue;
                boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                boolean bl = control = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                if (!Keyboard.getEventKeyState() || !this.gameSettings.keyToggleDebug.isPressed()) {
                    this.thePlayer.input.keyEvent(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                }
                if (this.gameSettings.keyToggleDebug.isPressEvent(InputDevice.KEYBOARD)) {
                    this.f3Press = true;
                }
                if (this.gameSettings.keyToggleDebug.isReleaseEvent(InputDevice.KEYBOARD) && this.f3Press) {
                    if (control) {
                        this.gameSettings.showFrameTimes.toggle();
                    } else {
                        this.gameSettings.showDebugScreen.toggle();
                    }
                    this.f3Press = false;
                }
                if (Keyboard.getEventKeyState()) {
                    if (Keyboard.getEventKey() == 87) {
                        this.gameWindow.toggleFullscreen();
                        continue;
                    }
                    if (this.gameSettings.keyToggleDebug.isPressed()) {
                        if (Keyboard.getEventKey() == 16) {
                            this.ingameGUI.addChatMessage(TextFormatting.YELLOW + "Keyboard shortcuts: ");
                            this.ingameGUI.addChatMessage("F3 + A: Reload chunks");
                            this.ingameGUI.addChatMessage("F3 + C: Clear chat");
                            this.ingameGUI.addChatMessage("F3 + D: Dump textures");
                            this.ingameGUI.addChatMessage("F3 + F: Toggle fullbright");
                            this.ingameGUI.addChatMessage("F3 + G: Show chunk borders");
                            this.ingameGUI.addChatMessage("F3 + H: Toggle item durability");
                            this.ingameGUI.addChatMessage("F3 + L: Toggle lightmap");
                            this.ingameGUI.addChatMessage("F3 + N: Switch gamemode");
                            this.ingameGUI.addChatMessage("F3 + P: Toggle pause on lost focus");
                            this.ingameGUI.addChatMessage("F3 + R: Reload");
                            this.ingameGUI.addChatMessage("F3 + S: Toggle smooth lighting");
                            this.ingameGUI.addChatMessage("F3 + B: Debug collision boxes");
                            this.ingameGUI.addChatMessage("F12: Release cursor");
                        }
                        if (Keyboard.getEventKey() == 19) {
                            this.forceReload();
                        } else if (Keyboard.getEventKey() == 49) {
                            if (this.theWorld.getLevelData().getCheatsEnabled() || this.theWorld.isClientSide) {
                                if (this.thePlayer.getGamemode() == Gamemode.creative) {
                                    this.thePlayer.sendChatMessage("/gamemode 0");
                                } else {
                                    this.thePlayer.sendChatMessage("/gamemode 1");
                                }
                            }
                        } else if (Keyboard.getEventKey() == 32) {
                            Textures.dumpTextures();
                        } else if (Keyboard.getEventKey() == 33) {
                            NetClientHandler queue = this.getSendQueue();
                            if (queue != null) {
                                PlayerProfile profile = queue.getPlayer(this.thePlayer.username);
                                if (profile != null && profile.isOperator) {
                                    boolean bl2 = this.fullbright = !this.fullbright;
                                    if (!LightmapHelper.isLightmapEnabled()) {
                                        this.renderGlobal.loadRenderers();
                                    }
                                }
                            } else if (this.theWorld.getLevelData().getCheatsEnabled()) {
                                boolean bl3 = this.fullbright = !this.fullbright;
                                if (!LightmapHelper.isLightmapEnabled()) {
                                    this.renderGlobal.loadRenderers();
                                }
                            }
                            this.ingameGUI.guiHeldItemTooltip.setString("Fullbright: " + (this.fullbright ? "On" : "Off"));
                        } else if (Keyboard.getEventKey() == 38) {
                            if (this.gameSettings.lightmapStyle.value == LightmapStyle.DISABLED) {
                                this.gameSettings.lightmapStyle.value = LightmapStyle.GRAY;
                                this.ingameGUI.guiHeldItemTooltip.setString("Lightmap: On");
                                this.renderGlobal.loadRenderers();
                            } else {
                                this.gameSettings.lightmapStyle.value = LightmapStyle.DISABLED;
                                this.ingameGUI.guiHeldItemTooltip.setString("Lightmap: Off");
                                this.renderGlobal.loadRenderers();
                            }
                        } else if (Keyboard.getEventKey() == 48) {
                            this.gameSettings.showCollisionBoxes.toggle();
                            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.showCollisionBoxes);
                        } else if (Keyboard.getEventKey() == 34) {
                            this.gameSettings.showChunkBorders.toggle();
                            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.showChunkBorders);
                        } else if (Keyboard.getEventKey() == 46) {
                            this.ingameGUI.clearChatMessages();
                        } else if (Keyboard.getEventKey() == 25) {
                            this.gameSettings.pauseOnLostFocus.toggle();
                            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.pauseOnLostFocus);
                        } else if (Keyboard.getEventKey() == 35) {
                            this.gameSettings.showItemDebugInfo.toggle();
                            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.showItemDebugInfo);
                        } else if (Keyboard.getEventKey() == 30) {
                            this.renderGlobal.loadRenderers();
                        } else if (Keyboard.getEventKey() == 31) {
                            this.gameSettings.ambientOcclusion.toggle();
                            this.gameSettings.ambientOcclusion.onUpdate();
                            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.ambientOcclusion);
                        }
                        if (this.gameSettings.keyToggleDebug.isPressEvent(InputDevice.KEYBOARD)) continue;
                        this.f3Press = false;
                        continue;
                    }
                    if (Keyboard.getEventKey() == 88) {
                        this.mouseInput.releaseCursor();
                        continue;
                    }
                    if (Keyboard.getEventKey() == 1) {
                        this.displayInGameMenu();
                        continue;
                    }
                    if (Keyboard.getEventKey() == 65) {
                        this.render.reload();
                        continue;
                    }
                    if (this.gameSettings.keyCommand.isPressed()) {
                        this.displayGuiScreen(new GuiChat("/"));
                        continue;
                    }
                    this.checkBoundInputs(InputDevice.KEYBOARD);
                    continue;
                }
                this.checkBoundInputs(InputDevice.KEYBOARD);
            }
            boolean breakBlockPressed = this.gameSettings.keyAttack.isPressed() || this.controllerInput != null && this.controllerInput.buttonZR.isPressed();
            boolean bl = placeBlockPressed = this.gameSettings.keyInteract.isPressed() || this.controllerInput != null && this.controllerInput.buttonZL.isPressed();
            if (this.currentScreen == null) {
                if (breakBlockPressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 5.0f && this.inGameHasFocus) {
                    this.clickMouse(0, (Boolean)this.gameSettings.autoHit.value, true);
                }
                if (placeBlockPressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 5.0f && this.inGameHasFocus) {
                    this.clickMouse(1, (Boolean)this.gameSettings.autoHit.value, true);
                }
            }
            this.mineBlocks(0, this.currentScreen == null && breakBlockPressed && this.inGameHasFocus);
        }
        if (this.controllerInput != null) {
            this.handleControllerInput();
        }
        if (this.theWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.theWorld.joinEntityInSurroundings(this.thePlayer);
                }
                this.thePlayer.setFlySpeed(((Float)this.gameSettings.flightSpeed.value).floatValue());
                this.thePlayer.setFlightSmoothness(((Float)this.gameSettings.flightSmoothness.value).floatValue());
                this.thePlayer.turnWithVehicle = (Boolean)this.gameSettings.turnWithVehicle.value;
            }
            this.theWorld.difficultySetting = ((Difficulty)((Object)this.gameSettings.difficulty.value)).id();
            if (this.theWorld.isClientSide) {
                this.theWorld.difficultySetting = 3;
            }
            if (!this.isGamePaused) {
                this.worldRenderer.updateRenderer();
            }
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            if (!this.isGamePaused) {
                if (this.theWorld.lightningFlicker > 0) {
                    --this.theWorld.lightningFlicker;
                }
                this.theWorld.updateEntities();
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                this.theWorld.setAllowedMobSpawns(((Difficulty)((Object)this.gameSettings.difficulty.value)).canMobsSpawn(), true);
                this.theWorld.tick();
            }
            if (!this.isGamePaused && this.theWorld != null) {
                this.theWorld.randomDisplayUpdates(MathHelper.floor_double(this.thePlayer.x), MathHelper.floor_double(this.thePlayer.y), MathHelper.floor_double(this.thePlayer.z));
            }
            if (!this.isGamePaused) {
                this.effectRenderer.updateEffects();
            }
        }
        this.systemTime = System.currentTimeMillis();
    }

    private boolean checkBoundInputs(InputDevice currentInputDevice) {
        boolean control;
        boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean bl = control = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (this.gameSettings.keyAttack.isPressEvent(currentInputDevice)) {
            this.clickMouse(0, true, false);
            return true;
        }
        if (this.gameSettings.keyInteract.isPressEvent(currentInputDevice)) {
            this.clickMouse(1, true, false);
            return true;
        }
        if (this.gameSettings.keyPickBlock.isPressEvent(currentInputDevice)) {
            this.clickMiddleMouseButton();
            return true;
        }
        if (this.gameSettings.keyToggleOverlay.isPressEvent(currentInputDevice)) {
            if (control) {
                IntegerOption integerOption = this.gameSettings.overlayMode;
                Integer n = (Integer)integerOption.value;
                integerOption.value = (Integer)integerOption.value + 1;
                integerOption = this.gameSettings.overlayMode;
                integerOption.value = (Integer)integerOption.value % 3;
            } else {
                int i;
                boolean on = false;
                for (i = 0; i < this.gameSettings.overlayElements.length; ++i) {
                    if (!((Boolean)this.gameSettings.overlayElements[i].value).booleanValue()) continue;
                    on = true;
                    break;
                }
                for (i = 0; i < this.gameSettings.overlayElements.length; ++i) {
                    this.gameSettings.overlayElements[i].value = !on;
                }
            }
            return true;
        }
        if (this.gameSettings.keyHideGui.isPressEvent(currentInputDevice)) {
            this.gameSettings.immersiveMode.toggle();
            return true;
        }
        if (this.gameSettings.keySwitchPerspective.isPressEvent(currentInputDevice)) {
            this.gameSettings.thirdPersonView.value = ((Integer)this.gameSettings.thirdPersonView.value + 1) % 3;
            return true;
        }
        if (this.gameSettings.keyCinematicCamera.isPressEvent(currentInputDevice)) {
            this.gameSettings.smoothCamera.value = (Boolean)this.gameSettings.smoothCamera.value == false;
            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.smoothCamera);
            return true;
        }
        if (this.gameSettings.keyInventory.isPressEvent(currentInputDevice)) {
            this.displayGuiScreen(this.getGuiInventory());
            return true;
        }
        if (this.gameSettings.keyGuidebook.isPressEvent(currentInputDevice)) {
            this.thePlayer.triggerAchievement(AchievementList.OPEN_GUIDEBOOK);
            this.thePlayer.displayGUIGuidebook();
            return true;
        }
        if (this.gameSettings.keyDrop.isPressEvent(currentInputDevice)) {
            this.thePlayer.dropCurrentItem(control);
            return true;
        }
        if (this.gameSettings.keyPhotoMode.isPressEvent(currentInputDevice)) {
            this.displayGuiScreen(new GuiPhotoMode());
            return true;
        }
        if (this.gameSettings.keyChat.isPressEvent(currentInputDevice)) {
            this.displayGuiScreen(new GuiChat());
            return true;
        }
        if (this.isMultiplayerWorld() && this.gameSettings.keyPlayerList.isPressEvent(currentInputDevice)) {
            if (control) {
                IntegerOption on = this.gameSettings.playerListPosition;
                Integer i = (Integer)on.value;
                on.value = (Integer)on.value + 1;
                on = this.gameSettings.playerListPosition;
                on.value = (Integer)on.value % 3;
            } else {
                this.gameSettings.showPlayerList.value = (Boolean)this.gameSettings.showPlayerList.value == false;
            }
            return true;
        }
        if (this.thePlayer.getGamemode().canPlayerFly() && this.gameSettings.keyFly.isPressEvent(currentInputDevice)) {
            if (!this.toggleFlyPressed) {
                this.toggleFlyPressed = true;
            }
            this.flyPressedTime = System.currentTimeMillis();
            return true;
        }
        if (this.gameSettings.keyHotBarSwitch.isPressEvent(currentInputDevice)) {
            if (shift) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 27) % 36);
                this.hotbarSwapAnimationProgress = -1.0f;
            } else {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 9) % 36);
                this.hotbarSwapAnimationProgress = 1.0f;
            }
            this.thePlayer.inventory.changeCurrentItem(0);
            return true;
        }
        if (this.gameSettings.keyCenterView.isPressEvent(currentInputDevice)) {
            this.thePlayer.xRot = 0.0f;
            return true;
        }
        if (this.gameSettings.keyLockRotation.isPressEvent(currentInputDevice)) {
            if (control) {
                IntegerOption on = this.gameSettings.rotationOverlayMode;
                Integer i = (Integer)on.value;
                on.value = (Integer)on.value + 1;
                on = this.gameSettings.rotationOverlayMode;
                on.value = (Integer)on.value % 4;
            } else {
                if (this.thePlayer.rotationLock == null || this.thePlayer.rotationLock == Direction.NONE) {
                    this.thePlayer.rotationLock = Direction.getDirection(this.thePlayer);
                    this.thePlayer.rotationLockHorizontal = Direction.getHorizontalDirection(this.thePlayer);
                    this.thePlayer.rotationLockVertical = Direction.getVerticalDirection(this.thePlayer);
                } else {
                    this.thePlayer.rotationLock = null;
                    this.thePlayer.rotationLockHorizontal = null;
                    this.thePlayer.rotationLockVertical = null;
                }
                this.thePlayer.syncPlacementMode();
            }
            return true;
        }
        if (this.gameSettings.keyToggleFog.isPressEvent(currentInputDevice)) {
            this.gameSettings.renderDistance.toggle(shift ? -1 : 1);
            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.renderDistance);
            return true;
        }
        if (this.gameSettings.keyToggleGamma.isPressEvent(currentInputDevice)) {
            int currentGammaStep = 2;
            if (((Float)this.gameSettings.gamma.value).floatValue() < 0.125f) {
                currentGammaStep = 0;
            } else if (((Float)this.gameSettings.gamma.value).floatValue() < 0.375f) {
                currentGammaStep = 1;
            } else if (((Float)this.gameSettings.gamma.value).floatValue() > 0.875f) {
                currentGammaStep = 4;
            } else if (((Float)this.gameSettings.gamma.value).floatValue() > 0.625f) {
                currentGammaStep = 3;
            }
            int newGammaStep = (currentGammaStep + (shift ? -1 : 1) + 5) % 5;
            this.gameSettings.gamma.value = Float.valueOf((float)newGammaStep * 0.25f);
            this.ingameGUI.guiHeldItemTooltip.setOptionNameAndValueString(this.gameSettings.gamma);
            return true;
        }
        if (this.gameSettings.keyHotBarLeft.isPressEvent(currentInputDevice)) {
            this.thePlayer.inventory.changeCurrentItem(1);
            return true;
        }
        if (this.gameSettings.keyHotBarRight.isPressEvent(currentInputDevice)) {
            this.thePlayer.inventory.changeCurrentItem(-1);
            return true;
        }
        KeyBinding[] hotbarSlots = new KeyBinding[]{this.gameSettings.keyHotBarSlot1, this.gameSettings.keyHotBarSlot2, this.gameSettings.keyHotBarSlot3, this.gameSettings.keyHotBarSlot4, this.gameSettings.keyHotBarSlot5, this.gameSettings.keyHotBarSlot6, this.gameSettings.keyHotBarSlot7, this.gameSettings.keyHotBarSlot8, this.gameSettings.keyHotBarSlot9};
        for (int i = 0; i < hotbarSlots.length; ++i) {
            if (!hotbarSlots[i].isPressEvent(currentInputDevice)) continue;
            this.thePlayer.inventory.currentItem = i + this.thePlayer.inventory.hotbarOffset;
            return true;
        }
        if (this.gameSettings.keyZoom.isPressEvent(currentInputDevice)) {
            Mouse.getDWheel();
            this.worldRenderer.zooming = true;
            return true;
        }
        if (this.gameSettings.keyZoom.isReleaseEvent(currentInputDevice)) {
            this.worldRenderer.zooming = false;
            return true;
        }
        return false;
    }

    private GuiInventory getGuiInventory() {
        if (this.thePlayer.getGamemode() == Gamemode.creative) {
            return new GuiInventoryCreative(this.thePlayer);
        }
        return new GuiInventory(this.thePlayer);
    }

    public void handleControllerInput() {
        try {
            this.controllerInput.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            InputHandler.controllers.remove(this.controllerInput);
            this.controllerInput = null;
            this.setInputType(InputType.KEYBOARD);
            return;
        }
        for (Joystick joystick : this.controllerInput.joysticks) {
            if (!(joystick.getX() < -0.5f || joystick.getX() > 0.5f || joystick.getY() < -0.5f) && !(joystick.getY() > 0.5f)) continue;
            this.setInputType(InputType.CONTROLLER);
        }
        ControllerInput controller = this.controllerInput;
        if (this.currentScreen == null) {
            if (controller.buttonZR.pressedThisFrame()) {
                this.clickMouse(0, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonZL.pressedThisFrame()) {
                this.clickMouse(1, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonB.pressedThisFrame()) {
                this.thePlayer.dropCurrentItem(false);
            }
            if (controller.buttonY.pressedThisFrame() || controller.buttonX.pressedThisFrame()) {
                this.displayGuiScreen(this.getGuiInventory());
            }
            if (controller.buttonMinus.pressedThisFrame()) {
                this.gameSettings.showPlayerList.value = (Boolean)this.gameSettings.showPlayerList.value == false;
            }
            if (controller.buttonPlus.pressedThisFrame()) {
                this.displayGuiScreen(new GuiIngameMenu());
            }
            if (controller.digitalPad.up.pressedThisFrame()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 27) % 36);
                this.hotbarSwapAnimationProgress = -1.0f;
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            if (controller.digitalPad.down.pressedThisFrame()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 9) % 36);
                this.hotbarSwapAnimationProgress = 1.0f;
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            if (controller.digitalPad.left.pressedThisFrame() && this.thePlayer.getGamemode().canPlayerFly()) {
                this.thePlayer.setNoclip(!this.thePlayer.noPhysics);
            }
            if (controller.buttonL.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentItem(1);
            }
            if (controller.buttonR.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentItem(-1);
            }
            if (controller.joyLeft.getButton().pressedThisFrame()) {
                IntegerOption integerOption = this.gameSettings.thirdPersonView;
                Integer n = (Integer)integerOption.value;
                integerOption.value = (Integer)integerOption.value + 1;
                integerOption = this.gameSettings.thirdPersonView;
                integerOption.value = (Integer)integerOption.value % 3;
            }
        } else {
            GuiScreen currentScreen = this.currentScreen;
            if (controller.buttonB.pressedThisFrame()) {
                currentScreen.keyTyped('\u0000', 14, -1, -1);
            }
            if (controller.buttonPlus.pressedThisFrame()) {
                currentScreen.keyTyped('\u0000', 1, -1, -1);
            }
            if (controller.buttonA.pressedThisFrame()) {
                currentScreen.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 0);
            }
            if (controller.buttonA.releasedThisFrame()) {
                currentScreen.mouseMovedOrButtonReleased((int)controller.cursorX, (int)controller.cursorY, 0);
            }
            if (controller.buttonY.pressedThisFrame()) {
                currentScreen.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 1);
            }
            if (controller.buttonY.releasedThisFrame()) {
                currentScreen.mouseMovedOrButtonReleased((int)controller.cursorX, (int)controller.cursorY, 1);
            }
            if (controller.buttonX.pressedThisFrame()) {
                currentScreen.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 10);
            }
            if (currentScreen instanceof GuiContainer) {
                try {
                    ((GuiContainer)currentScreen).controllerInput(controller);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void forceReload() {
        System.out.println("FORCING RELOAD!");
        this.sndManager = new SoundManager();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.downloadResourcesThread.reloadResources();
        this.renderEngine.refreshTexturesAndDisplayErrors();
        this.render.reload();
        if (this.renderGlobal != null) {
            this.renderGlobal.loadRenderers();
        }
    }

    public boolean isMultiplayerWorld() {
        return this.theWorld != null && this.theWorld.isClientSide;
    }

    public void startWorld(String worldDirName, String worldName, long seed) {
        this.changeWorld(null);
        System.gc();
        int worldSaveVersion = 0;
        try {
            LevelData info = new LevelData(new File(this.mcDataDir, "saves/" + worldDirName));
            worldSaveVersion = info.getSaveVersion();
        }
        catch (IOException e) {
            worldSaveVersion = this.saveFormat.getSaveVersion();
        }
        if (worldSaveVersion < 19134) {
            this.convertSaveVersion(worldSaveVersion, worldDirName, worldName);
        } else {
            I18n i18n = I18n.getInstance();
            LevelStorage saveHandler = this.saveFormat.getSaveHandler(worldDirName, false);
            World world = new World(saveHandler, worldName, seed, null, null);
            if (world.isNewWorld) {
                this.statsCounter.addValueToStat(StatList.createWorldStat, 1);
                this.statsCounter.addValueToStat(StatList.startGameStat, 1);
                this.changeWorld(world, i18n.translateKey("gui.loading.label.generating"));
            } else {
                this.statsCounter.addValueToStat(StatList.loadWorldStat, 1);
                this.statsCounter.addValueToStat(StatList.startGameStat, 1);
                this.changeWorld(world, i18n.translateKey("gui.loading.label.loading"));
            }
        }
    }

    public void usePortal(int dim) {
        Dimension lastDim = Dimension.getDimensionList().get(this.thePlayer.dimension);
        Dimension newDim = Dimension.getDimensionList().get(dim);
        System.out.println("Switching to dimension \"" + newDim.getTranslatedName() + "\"!!");
        this.thePlayer.dimension = dim;
        this.theWorld.setEntityDead(this.thePlayer);
        this.thePlayer.removed = false;
        double x = this.thePlayer.x;
        double z = this.thePlayer.z;
        double y = this.thePlayer.y;
        this.thePlayer.moveTo(x *= (double)Dimension.getCoordScale(lastDim, newDim), y, z *= (double)Dimension.getCoordScale(lastDim, newDim), this.thePlayer.yRot, this.thePlayer.xRot);
        if (this.thePlayer.isAlive()) {
            this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
        }
        World world = new World(this.theWorld, newDim);
        I18n i18n = I18n.getInstance();
        if (newDim == lastDim.homeDim) {
            this.changeWorld(world, i18n.translateKeyAndFormat("gui.loading.label.leaving", lastDim.getTranslatedName()), this.thePlayer);
        } else {
            this.changeWorld(world, i18n.translateKeyAndFormat("gui.loading.label.entering", newDim.getTranslatedName()), this.thePlayer);
        }
        this.thePlayer.world = this.theWorld;
        if (this.thePlayer.isAlive()) {
            this.thePlayer.moveTo(x, y, z, this.thePlayer.yRot, this.thePlayer.xRot);
            this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            new PortalHandler().teleportEntity(this.theWorld, this.thePlayer, lastDim, newDim);
        }
    }

    public void changeWorld(World world) {
        this.changeWorld(world, "");
    }

    public void changeWorld(World world, String loadingTitle) {
        this.changeWorld(world, loadingTitle, null);
    }

    public void changeWorld(World world, String loadingTitle, EntityPlayer player) {
        this.mainMenuBackground.deleteTextures();
        this.gameSettings.showCollisionBoxes.value = false;
        this.fullbright = false;
        this.statsCounter.func_27175_b();
        this.statsCounter.syncStats();
        if (world != null) {
            this.loadingScreen.updateLoadingBackground(world.dimension);
            this.loadingScreen.progressStart(loadingTitle);
            this.loadingScreen.progressStage("");
        }
        this.sndManager.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.theWorld != null) {
            this.theWorld.saveWorldIndirectly(this.loadingScreen);
            this.theWorld.getChunkProvider().unloadAllChunks();
            this.theWorld.onUnload();
        }
        this.theWorld = world;
        if (world != null) {
            this.playerController.initLevel(world);
            if (!this.isMultiplayerWorld()) {
                if (player == null) {
                    this.thePlayer = (EntityPlayerSP)world.func_4085_a(EntityPlayerSP.class);
                }
            } else if (this.thePlayer != null) {
                this.thePlayer.resetPos();
                if (world != null) {
                    world.entityJoinedWorld(this.thePlayer);
                }
            }
            if (!world.isClientSide) {
                this.func_6255_d(loadingTitle);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(world);
                this.thePlayer.resetPos();
                this.playerController.initPlayer(this.thePlayer);
            }
            this.thePlayer.input = new PlayerInput(this);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(world);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(world);
            }
            this.playerController.adjustPlayer(this.thePlayer);
            IChunkProvider ichunkprovider = world.getChunkProvider();
            if (ichunkprovider instanceof ChunkProviderStatic) {
                ChunkProviderStatic chunkproviderloadorgenerate = (ChunkProviderStatic)ichunkprovider;
                int i = MathHelper.floor_float((int)this.thePlayer.x) >> 4;
                int j = MathHelper.floor_float((int)this.thePlayer.z) >> 4;
                chunkproviderloadorgenerate.setCurrentChunkOver(i, j);
            }
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.isNewWorld) {
                world.saveWorldIndirectly(this.loadingScreen);
            }
            this.activeCamera = new EntityCameraFirstPerson(this, this.thePlayer);
            this.thePlayer.syncPlacementMode();
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
        if (world != null) {
            this.loadingScreen.progressStop();
        }
        this.worldRenderer.lightmapHelper.setup();
    }

    private void convertSaveVersion(int fromVersion, String worldDirName, String worldName) {
        ISaveFormat fromWorldFormat = SaveFormats.createSaveFormat(fromVersion, new File(this.mcDataDir, "saves"));
        if (fromWorldFormat != null) {
            ISaveFormat toWorldFormat;
            ISaveConverter converterToUse = null;
            for (ISaveConverter converter : SaveConverters.saveConverters) {
                if (converter.fromVersion() != fromVersion || converterToUse != null && converter.toVersion() <= converterToUse.toVersion()) continue;
                converterToUse = converter;
            }
            if (converterToUse != null && (toWorldFormat = SaveFormats.createSaveFormat(converterToUse.toVersion(), new File(this.mcDataDir, "saves"))) != null) {
                this.loadingScreen.updateLoadingBackground(null);
                this.loadingScreen.progressStartNoAbort("Converting world from " + fromWorldFormat.getFormatName() + " to " + toWorldFormat.getFormatName() + ".");
                this.loadingScreen.progressStage("This may take a while :)");
                CompoundTag levelDataTag = toWorldFormat.getLevelDataRaw(worldDirName);
                converterToUse.convertSave(levelDataTag, new File(this.mcDataDir, "saves"), worldDirName, this.loadingScreen);
                this.loadingScreen.progressStop();
                levelDataTag.putInt("version", toWorldFormat.getSaveVersion());
                LevelStorage saveHandler = toWorldFormat.getSaveHandler(worldDirName, false);
                saveHandler.saveLevelDataRaw(levelDataTag);
                this.startWorld(worldDirName, worldName, 0L);
            }
        }
    }

    private void func_6255_d(String loadingTitle) {
        this.loadingScreen.updateLoadingBackground(this.theWorld.dimension);
        this.loadingScreen.progressStartNoAbort(loadingTitle);
        this.loadingScreen.progressStage("Building terrain");
        int c = 128;
        int i = 0;
        int j = c * 2 / 16 + 1;
        j *= j;
        IChunkProvider ichunkprovider = this.theWorld.getChunkProvider();
        ChunkCoordinates chunkcoordinates = this.theWorld.getSpawnPoint();
        if (this.thePlayer != null) {
            chunkcoordinates.x = (int)this.thePlayer.x;
            chunkcoordinates.z = (int)this.thePlayer.z;
        }
        if (ichunkprovider instanceof ChunkProviderStatic) {
            ChunkProviderStatic chunkProvider = (ChunkProviderStatic)ichunkprovider;
            chunkProvider.setCurrentChunkOver(Math.floorDiv(chunkcoordinates.x, 16), Math.floorDiv(chunkcoordinates.z, 16));
        }
        for (int k = -c; k <= c; k += 16) {
            for (int l = -c; l <= c; l += 16) {
                this.loadingScreen.progressStagePercentage(i++ * 100 / j);
                this.theWorld.getBlockId(chunkcoordinates.x + k, 64, chunkcoordinates.z + l);
                while (this.theWorld.updatingLighting()) {
                }
            }
        }
        this.loadingScreen.progressStage("Simulating world for a bit...");
        this.loadingScreen.progressStop();
        j = 2000;
        this.theWorld.dropOldChunks();
    }

    public void installResource(String s, File file) {
        int i = s.indexOf("/");
        String s1 = s.substring(0, i);
        s = s.substring(i + 1);
        if (s1.equalsIgnoreCase("sound")) {
            this.sndManager.addSound(s, file);
        } else if (s1.equalsIgnoreCase("newsound")) {
            this.sndManager.addSound(s, file);
        } else if (s1.equalsIgnoreCase("streaming")) {
            this.sndManager.addStreaming(s, file);
        } else if (s1.equalsIgnoreCase("music")) {
            this.sndManager.addMusic(s, file);
        } else if (s1.equalsIgnoreCase("newmusic")) {
            this.sndManager.addMusic(s, file);
        }
    }

    public String getRendererDebugInfo() {
        return this.renderGlobal.getRendererDebugInfo();
    }

    public String getEntityDebugInfoString() {
        return this.renderGlobal.getEntityDebugInfo();
    }

    public String getChunkProviderInfoString() {
        return this.theWorld.getChunkProviderInfoString();
    }

    public String getEntityCountsInfoString() {
        return "P: " + this.effectRenderer.getNumParticlesString() + ". T: " + this.theWorld.getNumLoadedEntitiesString();
    }

    public void respawn(boolean flag, int i) {
        IChunkProvider ichunkprovider;
        EntityPlayerSP previousPlayer = this.thePlayer;
        if (!this.theWorld.isClientSide && !this.theWorld.dimension.defaultWorldType.mayRespawn()) {
            this.usePortal(i);
        }
        ChunkCoordinates spawnCoordinates = null;
        ChunkCoordinates bedSpawnCoordinates = null;
        ChunkCoordinates lastDeathCoordinates = null;
        boolean canRespawnAtBed = true;
        if (this.thePlayer != null && !flag) {
            spawnCoordinates = this.thePlayer.getPlayerSpawnCoordinate();
            lastDeathCoordinates = this.thePlayer.getLastDeathCoordinate();
            if (spawnCoordinates != null && (bedSpawnCoordinates = EntityPlayer.getValidBedSpawnCoordinates(this.theWorld, spawnCoordinates)) == null) {
                this.thePlayer.sendTranslatedChatMessage("bed.notValid");
            }
        }
        if (bedSpawnCoordinates == null) {
            bedSpawnCoordinates = this.theWorld.getSpawnPoint();
            canRespawnAtBed = false;
        }
        if ((ichunkprovider = this.theWorld.getChunkProvider()) instanceof ChunkProviderStatic) {
            ChunkProviderStatic chunkproviderloadorgenerate = (ChunkProviderStatic)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(bedSpawnCoordinates.x >> 4, bedSpawnCoordinates.z >> 4);
        }
        this.theWorld.getRespawnLocation();
        this.theWorld.updateEntityList();
        int j = 0;
        Gamemode playerGamemode = Gamemode.survival;
        if (this.thePlayer != null) {
            j = this.thePlayer.id;
            this.theWorld.setEntityDead(this.thePlayer);
            playerGamemode = this.thePlayer.getGamemode();
        }
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.theWorld);
        this.thePlayer.dimension = i;
        this.thePlayer.setGamemode(playerGamemode);
        this.thePlayer.messageHistory = previousPlayer.messageHistory;
        this.activeCamera = new EntityCameraFirstPerson(this, this.thePlayer);
        this.thePlayer.resetPos();
        if (previousPlayer != null && !this.theWorld.isClientSide) {
            this.thePlayer.inventory.transferAllContents(previousPlayer.inventory);
        }
        if (canRespawnAtBed) {
            this.thePlayer.setPlayerSpawnCoordinate(spawnCoordinates);
            this.thePlayer.moveTo((float)bedSpawnCoordinates.x + 0.5f, (float)bedSpawnCoordinates.y + 0.1f, (float)bedSpawnCoordinates.z + 0.5f, 0.0f, 0.0f);
        }
        this.thePlayer.setLastDeathCoordinate(lastDeathCoordinates);
        this.playerController.initPlayer(this.thePlayer);
        this.theWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.input = new PlayerInput(this);
        this.thePlayer.id = j;
        this.thePlayer.func_6420_o();
        this.playerController.adjustPlayer(this.thePlayer);
        this.func_6255_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.displayGuiScreen(null);
        }
    }

    public NetClientHandler getSendQueue() {
        if (this.thePlayer instanceof EntityClientPlayerMP) {
            return ((EntityClientPlayerMP)this.thePlayer).sendQueue;
        }
        return null;
    }

    public void setRenderer(Renderer renderer) {
        if (this.render != null) {
            this.render.delete();
        }
        this.render = renderer;
        this.render.reload();
    }

    public static void startMainThread(String username, String sessionId) {
        boolean flag = false;
        String sessionUsername = username;
        GameWindowLWJGL2 gameWindow = new GameWindowLWJGL2();
        Minecraft mc = new Minecraft(gameWindow);
        Thread thread = new Thread((Runnable)mc, "Client-Main");
        thread.setPriority(10);
        mc.minecraftUri = "www.minecraft.net";
        mc.session = sessionUsername != null && sessionId != null ? new Session(sessionUsername, sessionId) : new Session("Player" + System.currentTimeMillis() % 1000L, "");
        thread.start();
    }

    public static void main(String[] args) {
        String playerName = null;
        String sessionId = null;
        playerName = "Player" + System.currentTimeMillis() % 1000L;
        if (args.length > 0) {
            playerName = args[0];
        }
        sessionId = "-";
        if (args.length > 1) {
            sessionId = args[1];
        }
        Minecraft.startMainThread(playerName, sessionId);
    }

    public void setInputType(InputType inputType) {
        if (inputType != this.inputType) {
            System.out.println("Set input type to " + inputType.name());
        }
        this.inputType = inputType;
        if (inputType == InputType.CONTROLLER) {
            this.mouseInput.grabCursor();
        }
        if (inputType == InputType.KEYBOARD) {
            if (this.inGameHasFocus && !Mouse.isGrabbed()) {
                this.mouseInput.grabCursor();
            }
            if (!this.inGameHasFocus && Mouse.isGrabbed()) {
                this.mouseInput.releaseCursor();
            }
        }
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return this.skinVariantList;
    }

    public boolean isAmbientOcclusionEnabled() {
        return (Boolean)this.gameSettings.ambientOcclusion.value;
    }

    public boolean isTreeShadingEnabled() {
        return (Boolean)this.gameSettings.treeShadows.value;
    }

    public boolean isDebugInfoEnabled() {
        return (Boolean)this.gameSettings.showDebugScreen.value;
    }

    @Override
    public boolean isFullbrightEnabled() {
        return this.fullbright;
    }

    public boolean canRenderEntityLabel() {
        return this.isDebugInfoEnabled() && this.thePlayer != null && this.thePlayer.getGamemode() == Gamemode.creative;
    }

    public float getOutlineWidth() {
        return ((Float)Minecraft.INSTANCE.gameSettings.blockOutlineWidth.value).floatValue();
    }

    @Override
    public int getAutosaveTimer() {
        return INSTANCE != null ? (int)(((Float)Minecraft.INSTANCE.gameSettings.autosaveTimer.value).floatValue() * 24.0f) * 5 : 0;
    }

    public static Minecraft getMinecraft(Object caller) {
        return Minecraft.getMinecraft(caller.getClass());
    }

    public static Minecraft getMinecraft(Class<?> caller) {
        String name = caller.getPackage().getName();
        if (name.startsWith("net.minecraft.core") || name.startsWith("net.minecraft.server")) {
            throw new RuntimeException("Tried to access net.minecraft.client.Minecraft from outside net.minecraft.client!");
        }
        return INSTANCE;
    }

    public static void crash() {
        throw new RuntimeException("lol");
    }

    static {
        numRecordedFrameTimes = 0;
        hasPaidCheckTime = 0L;
        minecraftDir = null;
    }
}

