/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.world.World;

public class EntityReddustFX
extends EntityFX {
    float field_673_a;

    public EntityReddustFX(World world, double x, double y, double z, float red, float green, float blue) {
        this(world, x, y, z, 1.0f, red, green, blue);
    }

    public EntityReddustFX(World world, double x, double y, double z, float scale, float red, float green, float blue) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        float f4 = (float)Math.random() * 0.4f + 0.6f;
        this.particleRed = ((float)(Math.random() * 0.2) + 0.8f) * red * f4;
        this.particleGreen = ((float)(Math.random() * 0.2) + 0.8f) * green * f4;
        this.particleBlue = ((float)(Math.random() * 0.2) + 0.8f) * blue * f4;
        this.particleScale *= 0.75f;
        this.particleScale *= scale;
        this.field_673_a = this.particleScale;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * scale);
        this.noPhysics = false;
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + partialTick) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.field_673_a * f6;
        super.renderParticle(t, partialTick, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public void tick() {
        int val;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.particleTexture = (val = 7 - this.particleAge * 8 / this.particleMaxAge) >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

