/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.core.lang.I18n;

public class GuiConnectFailed
extends GuiScreen {
    private String errorMessage;
    private String errorDetail;

    public GuiConnectFailed(String s, String s1, Object[] aobj) {
        String authToken;
        I18n stringtranslate = I18n.getInstance();
        this.errorMessage = stringtranslate.translateKey(s);
        this.errorDetail = aobj != null ? stringtranslate.translateKeyAndFormat(s1, aobj) : stringtranslate.translateKey(s1);
        Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
        if (mc.session != null && (authToken = mc.session.sessionId) != null && authToken.length() > 1 && this.errorDetail.contains(authToken)) {
            this.errorDetail = this.errorDetail.replace(authToken, "<AUTH TOKEN>");
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.connect_failed.button.back")));
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (button.id == 0) {
            this.mc.displayGuiScreen(new GuiMainMenu());
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.drawDefaultBackground();
        this.drawStringCentered(this.fontRenderer, this.errorMessage, this.width / 2, this.height / 2 - 50, 0xFFFFFF);
        this.drawStringCentered(this.fontRenderer, this.errorDetail, this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTick);
    }
}

