/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Date;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveFile;
import net.minecraft.core.world.type.WorldType;

class GuiWorldSlot
extends ScrolledSelectionList {
    final GuiSelectWorld parentWorldGui;

    public GuiWorldSlot(GuiSelectWorld guiselectworld) {
        super(guiselectworld.mc, guiselectworld.width, guiselectworld.height, 32, guiselectworld.height - 64, 36);
        this.parentWorldGui = guiselectworld;
    }

    @Override
    protected int getItemCount() {
        return GuiSelectWorld.getSaveList(this.parentWorldGui).size();
    }

    @Override
    protected void selectItem(int itemIndex, boolean doubleClicked) {
        boolean flag1;
        GuiSelectWorld.setSelectedWorld(this.parentWorldGui, itemIndex);
        GuiSelectWorld.getSelectButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1 = GuiSelectWorld.getSelectedWorld(this.parentWorldGui) >= 0 && GuiSelectWorld.getSelectedWorld(this.parentWorldGui) < this.getItemCount();
        GuiSelectWorld.getRenameButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1;
        GuiSelectWorld.getDeleteButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1;
        if (doubleClicked && flag1) {
            this.parentWorldGui.selectWorld(itemIndex);
        }
    }

    @Override
    protected boolean isSelectedItem(int itemIndex) {
        return itemIndex == GuiSelectWorld.getSelectedWorld(this.parentWorldGui);
    }

    @Override
    protected int getMaxPosition() {
        return GuiSelectWorld.getSaveList(this.parentWorldGui).size() * 36;
    }

    @Override
    protected void renderHoleBackground() {
        this.parentWorldGui.drawDefaultBackground();
    }

    @Override
    protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
        I18n i18n = I18n.getInstance();
        SaveFile saveFile = GuiSelectWorld.getSaveList(this.parentWorldGui).get(index);
        String s = saveFile.getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            s = i18n.translateKeyAndFormat(GuiSelectWorld.getStringWorld(this.parentWorldGui), index + 1);
        }
        String s1 = saveFile.getFileName();
        s1 = s1 + " (" + GuiSelectWorld.getDateFormatter(this.parentWorldGui).format(new Date(saveFile.getLastTimePlayed()));
        long l1 = saveFile.getSizeOnDisk();
        s1 = s1 + ", " + (float)(l1 / 1024L * 100L / 1024L) / 100.0f + " MB)";
        String s2 = "";
        if (saveFile.getNeedsConversion()) {
            s2 = GuiSelectWorld.getStringConversion(this.parentWorldGui) + " " + s2;
        } else {
            WorldType worldType;
            LevelData ld = saveFile.getLevelData();
            DimensionData dd = saveFile.getDimensionData()[0];
            I18n st = I18n.getInstance();
            s2 = s2 + st.translateNameKey(Gamemode.gamemodesList[ld.getGamemode()].getLanguageKey());
            if (ld.getCheatsEnabled()) {
                s2 = s2 + " | " + st.translateKey("gui.select_world.label.cheats");
            }
            s2 = (worldType = dd.getWorldType()) != null ? s2 + " | " + st.translateNameKey(dd.getWorldType().getLanguageKey()) : s2 + " | " + TextFormatting.RED + st.translateKey("gui.select_world.label.unknown");
        }
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s, x + 2, y + 1, 0xFFFFFF);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s1, x + 2, y + 12, 0x808080);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s2, x + 2, y + 12 + 10, 0x808080);
    }
}

