/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer;

import com.b100.utils.ImageUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.gui.modelviewer.categories.BlockCategory;
import net.minecraft.client.gui.modelviewer.categories.EntityCategory;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.ParticleCategory;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerButton;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerSlider;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerTextField;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.gui.options.GuiOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.render.Texture;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.shader.PhotoModeRenderer;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Buffer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiModelViewer
extends GuiPhotoMode
implements GuiListenerTextField.ITextChangeListener {
    private GuiListenerButton buttonRotateLeft;
    private GuiListenerButton buttonRotateRight;
    private GuiListenerButton buttonCenterScreen;
    private GuiListenerButton buttonTakeScreenshot;
    private GuiListenerButton buttonExit;
    private GuiListenerSlider sliderTilt;
    private GuiListenerButton buttonShaders;
    private GuiListenerSlider sliderIntensity;
    public GuiListenerButton buttonPrevEntry;
    public GuiListenerButton buttonNextEntry;
    private GuiListenerButton buttonCategory;
    private GuiListenerButton buttonReloadTextures;
    private GuiListenerButton buttonTickToggle;
    private final ModelViewerCategory entityCategory = new EntityCategory(this);
    private final ModelViewerCategory particleCategory = new ParticleCategory(this);
    private final ModelViewerCategory blockCategory = new BlockCategory(this);
    public final List<ModelViewerCategory> categories = new ArrayList<ModelViewerCategory>();
    private ModelViewerCategory currentCategory;
    protected final int defaultRed = 63;
    protected final int defaultGreen = 63;
    protected final int defaultBlue = 89;
    protected int bgRed = 63;
    protected int bgGreen = 63;
    protected int bgBlue = 89;
    protected boolean tickProgress = true;
    protected boolean rotateToCamera = true;
    public long timeLastKeyPressed = System.currentTimeMillis();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public GuiModelViewer() {
        this.mc = Minecraft.getMinecraft(this);
        this.mc.thePlayer.absMoveTo(0.5, 64.5, 0.5, 180.0f, 0.0f);
        this.mc.thePlayer.noPhysics = true;
        this.mc.renderEngine.refreshTexturesAndDisplayErrors();
        this.mc.renderEngine.updateDynamicTextures();
        if (Shaders.enableShaders) {
            this.photoModeRenderer = new PhotoModeRenderer(this.mc, this);
        }
        this.previousRenderer = this.mc.render;
        this.showPlayer = false;
        this.showHelpText = false;
        this.iZoomGoal = 8.5f;
        this.iZoom = 8.5f;
        this.lastIZoom = 8.5f;
        this.mc.ppm.reset();
        this.iRotation = -2.0f;
        this.iRotationGoal = -2.0f;
        this.categories.add(this.blockCategory);
        this.categories.add(this.entityCategory);
        this.categories.add(this.particleCategory);
        this.setCategory(this.entityCategory);
    }

    @Override
    public void init() {
        this.controlList.clear();
        I18n i18n = I18n.getInstance();
        ArrayList<GuiButton> leftSideButtons = new ArrayList<GuiButton>();
        this.buttonExit = new GuiListenerButton(5, 0, this.height - 20, 20, 20, "X");
        this.buttonExit.setActionListener(this::exitToMenu);
        this.buttonRotateLeft = new GuiListenerButton(0, this.width / 2 - 49 - 2 - 20, this.height - 20, 20, 20, "<");
        this.buttonRotateLeft.setActionListener(() -> {
            this.iRotationGoal += 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        });
        this.buttonRotateRight = new GuiListenerButton(1, this.width / 2 + 49 + 2, this.height - 20, 20, 20, ">");
        this.buttonRotateRight.setActionListener(() -> {
            this.iRotationGoal -= 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        });
        this.buttonTakeScreenshot = new GuiListenerButton(4, this.width / 2 - 49, this.height - 20, 98, 20, i18n.translateKey("gui.photo_mode.button.take_screenshot"));
        this.buttonTakeScreenshot.setActionListener(this::screenShot);
        this.buttonPrevEntry = new GuiListenerButton(10, this.width / 2 - 49 - 2 - 20, this.height - 40 - 2, 20, 20, "<");
        this.buttonPrevEntry.setActionListener(() -> this.currentCategory.cycleCategoryEntry(-1));
        this.buttonNextEntry = new GuiListenerButton(11, this.width / 2 + 49 + 2, this.height - 40 - 2, 20, 20, ">");
        this.buttonNextEntry.setActionListener(() -> this.currentCategory.cycleCategoryEntry(1));
        this.buttonCategory = new GuiListenerButton(12, this.width / 2 - 49, this.height - 40 - 2, 98, 20, i18n.translateKey(this.currentCategory.getCategoryNameKey()));
        this.buttonCategory.setActionListener(() -> this.setCategory(this.categories.get((this.categories.indexOf(this.currentCategory) + 1) % this.categories.size())));
        this.buttonCategory.setOnValueChanged(() -> {
            this.buttonCategory.displayString = i18n.translateKey(this.currentCategory.getCategoryNameKey());
        });
        this.buttonReloadTextures = new GuiListenerButton(12, 21, this.height - 20, 98, 20, i18n.translateKey("gui.model_viewer.button.reload_textures"));
        this.buttonReloadTextures.setActionListener(() -> this.mc.renderEngine.refreshTexturesAndDisplayErrors());
        this.buttonCenterScreen = new GuiListenerButton(10, 0, 0, 120, 20, i18n.translateKey("gui.photo_mode.button.center_camera"));
        this.buttonCenterScreen.setActionListener(() -> {
            this.iPanXGoal = 0.0f;
            this.iPanYGoal = 0.0f;
        });
        this.buttonTickToggle = new GuiListenerButton(13, this.width - 120, 0, 99, 20, i18n.translateKeyAndFormat("gui.model_viewer.button.tickprogress", this.tickProgress));
        this.buttonTickToggle.setActionListener(() -> {
            this.tickProgress = !this.tickProgress;
        });
        this.buttonTickToggle.setOnValueChanged(() -> {
            this.buttonTickToggle.displayString = i18n.translateKeyAndFormat("gui.model_viewer.button.tickprogress", this.tickProgress);
        });
        GuiListenerButton cameraRotateButton = new GuiListenerButton(-1, this.width - 120, 0, 120, 20, i18n.translateKeyAndFormat("gui.model_viewer.button.rotate", this.rotateToCamera));
        cameraRotateButton.setActionListener(() -> {
            this.rotateToCamera = !this.rotateToCamera;
            cameraRotateButton.displayString = i18n.translateKeyAndFormat("gui.model_viewer.button.rotate", this.rotateToCamera);
        });
        GuiListenerButton buttonManualTick = new GuiListenerButton(14, this.width - 21, 0, 20, 20, "+");
        buttonManualTick.setActionListener(this::entryTick);
        this.sliderTilt = new GuiListenerSlider(7, 0, 0, 120, 20, i18n.translateKey("gui.photo_mode.button.tilt.default"), this.iTiltGoal / 90.0f);
        this.sliderTilt.setOnValueChanged(() -> {
            String tilt = i18n.translateKey("gui.photo_mode.button.tilt.default");
            if ((int)(this.sliderTilt.sliderValue * 90.0f) != 30) {
                tilt = (int)(this.sliderTilt.sliderValue * 90.0f) + " degrees";
            }
            this.sliderTilt.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.tilt", tilt);
            if (this.sliderTilt.dragging) {
                this.iTiltGoal = (int)(this.sliderTilt.sliderValue * 90.0f);
            }
        });
        if (Shaders.enableShaders) {
            this.buttonShaders = new GuiListenerButton(8, 0, 0, 120, 20, i18n.translateKeyAndFormat("gui.photo_mode.button.shader", i18n.translateKey("gui.photo_mode.button.shader.none")));
            this.buttonShaders.setActionListener(() -> {
                boolean ctrl;
                boolean bl = ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                if (ctrl) {
                    this.photoModeRenderer.first();
                } else {
                    this.photoModeRenderer.next();
                }
                this.sliderIntensity.enabled = this.photoModeRenderer.getActiveShader() != null;
            });
            this.buttonShaders.setOnValueChanged(() -> {
                String activeShader = this.photoModeRenderer.getActiveShader();
                if (activeShader == null) {
                    activeShader = i18n.translateKey("gui.photo_mode.button.shader.none");
                }
                activeShader = activeShader.toUpperCase(Locale.ROOT);
                this.buttonShaders.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.shader", activeShader);
            });
            this.sliderIntensity = new GuiListenerSlider(9, 0, 0, 120, 20, i18n.translateKeyAndFormat("gui.photo_mode.button.intensity", (int)(this.intensityValue * 100.0f) + "%"), this.intensityValue);
            this.sliderIntensity.setOnValueChanged(() -> {
                this.sliderIntensity.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.intensity", (int)(this.sliderIntensity.sliderValue * 100.0f) + "%");
                if (this.sliderIntensity.dragging) {
                    this.intensityValue = this.sliderIntensity.sliderValue;
                }
            });
            if (this.photoModeRenderer.getActiveShader() == null) {
                this.sliderIntensity.enabled = false;
            }
        }
        if (Shaders.enableShaders) {
            this.mc.setRenderer(this.photoModeRenderer);
        }
        this.controlList.add(cameraRotateButton);
        this.controlList.add(this.buttonTickToggle);
        int i = 0;
        ArrayList _buttons = new ArrayList(this.controlList);
        for (Object button : _buttons) {
            ((GuiButton)button).yPosition = i++ * 21;
        }
        this.controlList.add(buttonManualTick);
        buttonManualTick.yPosition = this.buttonTickToggle.yPosition;
        this.currentCategory.addContextButtons(this.controlList);
        leftSideButtons.add(this.buttonCenterScreen);
        leftSideButtons.add(this.sliderTilt);
        if (Shaders.enableShaders) {
            leftSideButtons.add(this.buttonShaders);
            leftSideButtons.add(this.sliderIntensity);
        }
        int j = 0;
        for (GuiButton button : leftSideButtons) {
            button.yPosition = j++ * 21;
        }
        this.controlList.addAll(leftSideButtons);
        GuiListenerTextField rField = new GuiListenerTextField(this, this.fontRenderer, 0, j++ * 21, 40, 20, String.valueOf(this.bgRed), "Red");
        rField.setPrefaceText("R: ");
        rField.setKeyListener(key -> {
            try {
                this.bgRed = Integer.parseInt(rField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        rField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                rField.setText(String.valueOf(63));
                this.bgRed = 63;
            }
        });
        GuiListenerTextField gField = new GuiListenerTextField(this, this.fontRenderer, 40, rField.yPosition, 40, 20, String.valueOf(this.bgGreen), "Green");
        gField.setPrefaceText("G: ");
        gField.setKeyListener(key -> {
            try {
                this.bgGreen = Integer.parseInt(gField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        gField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                gField.setText(String.valueOf(63));
                this.bgGreen = 63;
            }
        });
        GuiListenerTextField bField = new GuiListenerTextField(this, this.fontRenderer, 80, rField.yPosition, 40, 20, String.valueOf(this.bgBlue), "Blue");
        bField.setPrefaceText("B: ");
        bField.setKeyListener(key -> {
            try {
                this.bgBlue = Integer.parseInt(bField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        bField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                bField.setText(String.valueOf(89));
                this.bgBlue = 89;
            }
        });
        this.controlList.add(rField);
        this.controlList.add(gField);
        this.controlList.add(bField);
        this.controlList.add(this.buttonRotateLeft);
        this.controlList.add(this.buttonRotateRight);
        this.controlList.add(this.buttonTakeScreenshot);
        this.controlList.add(this.buttonPrevEntry);
        this.controlList.add(this.buttonNextEntry);
        this.controlList.add(this.buttonCategory);
        this.controlList.add(this.buttonReloadTextures);
        this.controlList.add(this.buttonExit);
    }

    private void setCategory(ModelViewerCategory category) {
        if (this.currentCategory != null) {
            this.currentCategory.onClose();
        }
        this.currentCategory = category;
        if (this.currentCategory != null) {
            this.currentCategory.onOpen();
        }
        this.init();
    }

    public static int cycleItemId(int itemId, int offset) {
        int id = (itemId + Item.itemsList.length + offset) % Item.itemsList.length;
        while (Item.itemsList[id] == null) {
            id = (id + (int)Math.signum(offset) + Item.itemsList.length) % Item.itemsList.length;
        }
        return id;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidth, (double)this.mc.resolution.scaledHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        if (this.rotateToCamera) {
            this.mc.thePlayer.yRotO = this.mc.thePlayer.yRot = this.getRotation(partialTick) * 45.0f - 135.0f;
        } else {
            this.mc.thePlayer.yRot = 180.0f;
            this.mc.thePlayer.yRotO = 180.0f;
        }
        this.lastIZoom = this.iZoom;
        if (this.iZoom != this.iZoomGoal) {
            this.iZoom += (this.iZoomGoal - this.iZoom) * 0.08f;
            if (Math.abs(this.iZoom - this.iZoomGoal) < 5.0E-4f) {
                this.iZoom = this.iZoomGoal;
            }
        }
        this.lastIRotation = this.iRotation;
        if (this.iRotation != this.iRotationGoal) {
            this.iRotation += (this.iRotationGoal - this.iRotation) * 0.08f;
            if (Math.abs(this.iRotation - this.iRotationGoal) < 5.0E-4f) {
                this.iRotation = this.iRotationGoal;
            }
        }
        this.lastITilt = this.iTilt;
        if (this.iTilt != this.iTiltGoal) {
            this.iTilt += (this.iTiltGoal - this.iTilt) * 0.08f;
            if (Math.abs(this.iTilt - this.iTiltGoal) < 0.01f) {
                this.iTilt = this.iTiltGoal;
            }
        }
        this.lastIPanX = this.iPanX;
        if (this.iPanX != this.iPanXGoal) {
            this.iPanX += (this.iPanXGoal - this.iPanX) * 0.4f;
            if (Math.abs(this.iPanX - this.iPanXGoal) < 0.01f) {
                this.iPanX = this.iPanXGoal;
            }
        }
        this.lastIPanY = this.iPanY;
        if (this.iPanY != this.iPanYGoal) {
            this.iPanY += (this.iPanYGoal - this.iPanY) * 0.4f;
            if (Math.abs(this.iPanY - this.iPanYGoal) < 0.01f) {
                this.iPanY = this.iPanYGoal;
            }
        }
        this.buttonCenterScreen.enabled = !(this.iPanX == 0.0f && this.iPanY == 0.0f || this.iPanXGoal == 0.0f && this.iPanYGoal == 0.0f);
        ArrayList _buttons = new ArrayList(this.controlList);
        for (GuiButton guibutton : _buttons) {
            guibutton.drawButton(this.mc, mouseX, mouseY);
        }
        this.scroll(Mouse.getDWheel());
        TileEntityRenderDispatcher.instance.renderTileEntity(Tessellator.instance, new TileEntity(), -0.5, -0.75, -0.5, partialTick);
        this.drawStringCentered(this.fontRenderer, this.currentCategory.getCurrentDisplayInfo(I18n.getInstance()), this.width / 2, 1, 0xFFFFFF);
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key == 1) {
            this.exitToMenu();
        }
        ArrayList _buttons = new ArrayList(this.controlList);
        for (GuiButton button : _buttons) {
            if (!(button instanceof IListenerElement) || !button.isHovered(mouseX, mouseY)) continue;
            ((IListenerElement)((Object)button)).onKeyTyped(c, key);
        }
    }

    private void exitToMenu() {
        this.currentCategory.onClose();
        this.mc.changeWorld(null);
        this.mc.displayGuiScreen(new GuiOptions(null, OptionsPages.DEBUG));
    }

    public static int cycleBlockId(int id, int idOff) {
        int id2 = (id + Block.blocksList.length + idOff) % Block.blocksList.length;
        while (Block.blocksList[id2] == null) {
            id2 = (id2 + (int)Math.signum(idOff) + Block.blocksList.length) % Block.blocksList.length;
        }
        return id2;
    }

    @Override
    public void onClosed() {
        if (Shaders.enableShaders) {
            this.mc.setRenderer(this.previousRenderer);
        }
        Minecraft.doPartialTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        ArrayList _buttons = new ArrayList(this.controlList);
        for (GuiButton button : _buttons) {
            if (!(button instanceof GuiListenerButton)) continue;
            ((GuiListenerButton)button).tick();
        }
        if (this.tickProgress) {
            this.entryTick();
        }
        Minecraft.doPartialTick = this.tickProgress;
    }

    private void entryTick() {
        this.mc.renderEngine.updateDynamicTextures();
        this.mc.effectRenderer.updateEffects();
        this.currentCategory.onTick();
    }

    @Override
    protected void buttonPressed(GuiButton button) {
    }

    @Override
    public void textChanged(GuiListenerTextField textField) {
        this.timeLastKeyPressed = System.currentTimeMillis();
    }

    public float[] getBackgroundFogColor() {
        return new float[]{(float)this.bgRed / 255.0f, (float)this.bgGreen / 255.0f, (float)this.bgBlue / 255.0f};
    }

    public void screenShot() {
        try {
            File screenshotsDir = new File(this.mc.getMinecraftDir(), "screenshots");
            screenshotsDir.mkdir();
            Texture texture = ((ShadersRenderer)this.mc.render).getWorldFramebufferTex();
            texture.bind();
            int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            int size = w * h * 4;
            Buffer.checkBufferSize(size);
            ByteBuffer buffer = Buffer.buffer;
            buffer.position(0).limit(size);
            GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            if (GL11.glGetError() == 0) {
                File outPut;
                buffer.position(0);
                String timeStamp = "Render_" + dateFormat.format(new Date());
                int id = 1;
                while ((outPut = new File(screenshotsDir, timeStamp + (id != 1 ? "_" + id : "") + ".png")).exists()) {
                    ++id;
                }
                ImageUtils.saveExternalImage(Textures.getImage(buffer, w, h, true, true), outPut);
            } else {
                System.out.println("Cannot get pixel data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

