/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityReddustFX;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerTextField;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import org.lwjgl.input.Keyboard;

public class RedDustFXEntry
extends ParticleEntry {
    private int red = 0;
    private int green = 0;
    private int blue = 0;

    @Override
    public String getParticleName(I18n translator) {
        return "reddust";
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen) {
        final GuiListenerTextField rField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -120, 0, 40, 20, String.valueOf(this.red), "Red");
        rField.setPrefaceText("R: ");
        rField.setKeyListener(key -> {
            try {
                this.red = Integer.parseInt(rField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        rField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                rField.setText(String.valueOf(0));
                this.red = 0;
            }
        });
        final GuiListenerTextField gField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -80, 0, 40, 20, String.valueOf(this.green), "Green");
        gField.setPrefaceText("G: ");
        gField.setKeyListener(key -> {
            try {
                this.green = Integer.parseInt(gField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        gField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                gField.setText(String.valueOf(0));
                this.green = 0;
            }
        });
        final GuiListenerTextField bField = new GuiListenerTextField(parentScreen, mc.fontRenderer, -40, 0, 40, 20, String.valueOf(this.blue), "Blue");
        bField.setPrefaceText("B: ");
        bField.setKeyListener(key -> {
            try {
                this.blue = Integer.parseInt(bField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        bField.setActionListener(() -> {
            if (Keyboard.isKeyDown((int)29)) {
                bField.setText(String.valueOf(0));
                this.blue = 0;
            }
        });
        return new ArrayList<GuiButton>(){
            {
                this.add(rField);
                this.add(gField);
                this.add(bField);
            }
        };
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        mc.effectRenderer.addEffect(new EntityReddustFX(world, x, y, z, (float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f));
    }

    @Override
    public void onOpen() {
        this.red = 0;
        this.green = 0;
        this.blue = 0;
    }

    @Override
    public void onClose() {
    }
}

