/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldTypes;
import net.minecraft.core.world.weather.Weather;

public class PostProcessingManager {
    private final Minecraft mc;
    public float brightness = 0.0f;
    public float contrast = 0.0f;
    public float exposure = 0.0f;
    public float saturation = 0.0f;
    public float rMod = 1.0f;
    public float gMod = 1.0f;
    public float bMod = 1.0f;
    public boolean enabled = true;
    public float heatHaze = 0.0f;
    private double lastTemperature = 0.0;
    private double lastHumidity = 0.0;

    public PostProcessingManager(Minecraft mc) {
        this.mc = mc;
    }

    public void reset() {
        this.brightness = 0.0f;
        this.contrast = 0.0f;
        this.exposure = 0.0f;
        this.saturation = 0.0f;
        this.rMod = 1.0f;
        this.gMod = 1.0f;
        this.bMod = 1.0f;
        this.heatHaze = 0.0f;
    }

    public void update() {
        if (this.mc.theWorld == null || this.mc.thePlayer == null) {
            return;
        }
        this.reset();
        if (((Float)this.mc.gameSettings.colorCorrection.value).floatValue() == 0.0f) {
            return;
        }
        float surfaceness = 1.0f;
        float y = (float)this.mc.thePlayer.y;
        int maxY = this.mc.theWorld.getWorldType().getMaxY();
        int minY = this.mc.theWorld.getWorldType().getMinY();
        int rangeY = maxY - minY;
        int halfY = minY + rangeY / 2;
        int quarterY = minY + rangeY / 4;
        int hToQRange = halfY - quarterY;
        float adjustedY = y - (float)quarterY;
        surfaceness = adjustedY / (float)hToQRange;
        surfaceness = MathHelper.clamp(surfaceness, 0.0f, 1.0f);
        double temperature = this.mc.theWorld.getBlockTemperature((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.z);
        if (temperature == Double.NEGATIVE_INFINITY) {
            temperature = this.lastTemperature;
        }
        this.lastTemperature = temperature;
        double humidity = this.mc.theWorld.getBlockHumidity((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.z);
        if (humidity == Double.NEGATIVE_INFINITY) {
            humidity = this.lastHumidity;
        }
        this.lastHumidity = humidity;
        if (this.mc.theWorld.dimension == Dimension.overworld) {
            this.lastTemperature = temperature;
            temperature = temperature * 2.0 - 1.0;
            this.saturation = (float)((double)this.saturation + 0.25 * temperature * (double)surfaceness);
            this.contrast = (float)((double)this.contrast + -0.1 * temperature * (double)surfaceness);
        }
        float seasonProgress = this.mc.theWorld.getSeasonManager().getSeasonProgress();
        seasonProgress = seasonProgress * 2.0f - 1.0f;
        seasonProgress = Math.abs(seasonProgress);
        seasonProgress = -seasonProgress + 1.0f;
        if (this.mc.theWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            this.saturation += 0.1f * seasonProgress * surfaceness;
        } else if (this.mc.theWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SUMMER) {
            this.rMod += 0.1f * seasonProgress * surfaceness;
            this.gMod += 0.1f * seasonProgress * surfaceness;
        } else if (this.mc.theWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_FALL) {
            this.contrast -= 0.1f * seasonProgress * surfaceness;
            this.rMod += 0.1f * seasonProgress * surfaceness;
        } else if (this.mc.theWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            this.contrast -= 0.1f * seasonProgress * surfaceness;
            this.bMod += 0.1f * seasonProgress * surfaceness;
        }
        Weather activeWeather = this.mc.theWorld.getCurrentWeather();
        if (activeWeather != null) {
            float intensity = this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherIntensity();
            if (activeWeather == Weather.overworldSnow || activeWeather == Weather.overworldWinterSnow) {
                this.contrast += -0.125f * intensity * surfaceness;
                this.saturation += -0.25f * intensity * surfaceness;
                this.bMod += 0.25f * intensity * surfaceness;
            } else if (activeWeather == Weather.overworldRainBlood) {
                this.rMod += 0.4f * intensity * surfaceness;
                this.gMod += 0.1f * intensity * surfaceness;
                this.saturation += 0.125f * intensity * surfaceness;
                this.exposure -= 0.125f * intensity * surfaceness;
            } else if (activeWeather == Weather.overworldRain) {
                this.bMod += 0.1f * intensity * surfaceness;
                this.saturation += -0.125f * intensity * surfaceness;
                this.brightness += -0.0625f * intensity * surfaceness;
            } else if (activeWeather == Weather.overworldStorm) {
                this.bMod += 0.1f * intensity * surfaceness;
                this.saturation += -0.2f * intensity * surfaceness;
                this.brightness += -0.1f * intensity * surfaceness;
            } else if (activeWeather == Weather.overworldFog && ((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
                this.saturation += -0.4f * intensity * surfaceness;
                this.contrast += -0.25f * intensity * surfaceness;
            }
        }
        if (this.mc.theWorld.getWorldType() == WorldTypes.NETHER_DEFAULT || this.mc.theWorld.getWorldType() == WorldTypes.OVERWORLD_HELL) {
            this.rMod += 1.2f;
            this.gMod += 0.3f;
            this.saturation += 0.125f;
            this.exposure -= 0.125f;
            this.contrast -= 0.05f;
            this.brightness -= 0.05f;
            this.heatHaze = 1.0f;
        }
        if (this.mc.theWorld.dimension == Dimension.overworld && (this.mc.theWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SUMMER || this.mc.theWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_FALL) && temperature >= 0.85 && humidity <= 0.15) {
            double tPercentage = (temperature - 0.85) / 0.15;
            double hPercentage = 1.0 - humidity / 0.15;
            double percentage = tPercentage * hPercentage;
            percentage = MathHelper.clamp(percentage, 0.0, 1.0);
            this.heatHaze = (float)percentage;
        }
        if (((Float)this.mc.gameSettings.colorCorrection.value).floatValue() != 0.0f) {
            this.brightness *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.contrast *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.exposure *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.saturation *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.rMod = 1.0f - (1.0f - this.rMod) * ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.gMod = 1.0f - (1.0f - this.gMod) * ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.bMod = 1.0f - (1.0f - this.bMod) * ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
        }
    }
}

