/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlockCache;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class RenderBlocks {
    public WorldSource blockAccess;
    private final Minecraft mc;
    public IconCoordinate overrideBlockTexture = null;
    public boolean flipTexture = false;
    public boolean renderAllFaces = false;
    public byte renderBitMask;
    public static boolean fancyGrass = true;
    public static final float[] SIDE_LIGHT_MULTIPLIER = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public static final float FULL_CUBE_THRESHOLD = 0.0625f;
    public static boolean enableDirectionalLight = true;
    public boolean useInventoryTint = true;
    public int uvRotateEast = 0;
    public int uvRotateWest = 0;
    public int uvRotateSouth = 0;
    public int uvRotateNorth = 0;
    public int uvRotateTop = 0;
    public int uvRotateBottom = 0;
    public boolean enableAO;
    public int field_22352_G = 1;
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    public int lightmapCoordTopLeft;
    public int lightmapCoordBottomLeft;
    public int lightmapCoordBottomRight;
    public int lightmapCoordTopRight;
    public boolean overbright;
    public RenderBlockCache cache = new RenderBlockCache();

    public RenderBlocks(WorldSource worldSource) {
        this.blockAccess = worldSource;
        this.renderBitMask = 0;
        this.mc = Minecraft.getMinecraft(this);
    }

    public RenderBlocks() {
        this.renderBitMask = 0;
        this.mc = Minecraft.getMinecraft(this);
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        if (this.mc.fullbright) {
            return 1.0f;
        }
        int id = blockAccess.getBlockId(x, y, z);
        Block block = blockAccess.getBlock(x, y, z);
        if (block != null) {
            return block.getBlockBrightness(blockAccess, x, y, z);
        }
        return blockAccess.getBrightness(x, y, z, Block.lightEmission[id]);
    }

    public void renderBlockFallingSand(Tessellator tessellator, BlockModel<Block> blockModel, Block block, WorldSource world, int x, int y, int z) {
        int lmcInside;
        boolean lightmap = LightmapHelper.isLightmapEnabled();
        float sideBottom = 1.0f;
        float sideTop = 1.0f;
        float sideNorthSouth = 1.0f;
        float sideEastWest = 1.0f;
        if (enableDirectionalLight) {
            sideBottom = 0.5f;
            sideTop = 1.0f;
            sideNorthSouth = 0.8f;
            sideEastWest = 0.6f;
        }
        tessellator.startDrawingQuads();
        int meta = world.getBlockMetadata(x, y, z);
        float brightnessInside = lightmap ? 1.0f : this.getBlockBrightness(world, x, y, z);
        float brightness = 1.0f;
        int n = lmcInside = lightmap ? block.getLightmapCoord(world, x, y, z) : 0;
        if (lightmap) {
            tessellator.setLightmapCoord(LightmapHelper.max(lmcInside, block.getLightmapCoord(world, x, y - 1, z)));
        } else {
            brightness = Math.max(this.getBlockBrightness(world, x, y - 1, z), brightnessInside);
        }
        tessellator.setColorOpaque_F(sideBottom * brightness, sideBottom * brightness, sideBottom * brightness);
        this.renderBottomFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta));
        if (lightmap) {
            tessellator.setLightmapCoord(LightmapHelper.max(lmcInside, block.getLightmapCoord(world, x, y + 1, z)));
        } else {
            brightness = Math.max(this.getBlockBrightness(world, x, y + 1, z), brightnessInside);
        }
        tessellator.setColorOpaque_F(sideTop * brightness, sideTop * brightness, sideTop * brightness);
        this.renderTopFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.TOP, meta));
        if (lightmap) {
            tessellator.setLightmapCoord(LightmapHelper.max(lmcInside, block.getLightmapCoord(world, x, y, z - 1)));
        } else {
            brightness = Math.max(this.getBlockBrightness(world, x, y, z - 1), brightnessInside);
        }
        tessellator.setColorOpaque_F(sideNorthSouth * brightness, sideNorthSouth * brightness, sideNorthSouth * brightness);
        this.renderNorthFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, meta));
        if (lightmap) {
            tessellator.setLightmapCoord(LightmapHelper.max(lmcInside, block.getLightmapCoord(world, x, y, z + 1)));
        } else {
            brightness = Math.max(this.getBlockBrightness(world, x, y, z + 1), brightnessInside);
        }
        tessellator.setColorOpaque_F(sideNorthSouth * brightness, sideNorthSouth * brightness, sideNorthSouth * brightness);
        this.renderSouthFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.SOUTH, meta));
        if (lightmap) {
            tessellator.setLightmapCoord(LightmapHelper.max(lmcInside, block.getLightmapCoord(world, x - 1, y, z)));
        } else {
            brightness = Math.max(this.getBlockBrightness(world, x - 1, y, z), brightnessInside);
        }
        tessellator.setColorOpaque_F(sideEastWest * brightness, sideEastWest * brightness, sideEastWest * brightness);
        this.renderWestFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.WEST, meta));
        if (lightmap) {
            tessellator.setLightmapCoord(LightmapHelper.max(lmcInside, block.getLightmapCoord(world, x + 1, y, z)));
        } else {
            brightness = Math.max(this.getBlockBrightness(world, x + 1, y, z), brightnessInside);
        }
        tessellator.setColorOpaque_F(sideEastWest * brightness, sideEastWest * brightness, sideEastWest * brightness);
        this.renderEastFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.EAST, meta));
        tessellator.draw();
    }

    public boolean renderStandardBlock(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z) {
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(block)).getWorldColor(this.blockAccess, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return this.renderStandardBlock(tessellator, blockModel, block, x, y, z, r, g, b);
    }

    public boolean renderStandardBlock(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z, float r, float g, float b) {
        this.enableAO = true;
        int meta = this.blockAccess.getBlockMetadata(x, y, z);
        this.cache.setupCache(block, this.blockAccess, x, y, z);
        boolean somethingRendered = false;
        for (Side side : Side.sides) {
            somethingRendered |= this.renderSide(tessellator, blockModel, block, x, y, z, r, g, b, side, meta);
        }
        this.enableAO = false;
        return somethingRendered;
    }

    public final boolean renderSide(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z, float r, float g, float b, Side side, int meta) {
        switch (side) {
            case BOTTOM: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 0, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 0, meta, 0, -1, 0, (float)block.minY, 0, 0, 1, (float)block.maxZ, (float)block.minZ, -1, 0, 0, 1.0f - (float)block.minX, 1.0f - (float)block.maxX);
            }
            case TOP: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 1, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 1, meta, 0, 1, 0, 1.0f - (float)block.maxY, 0, 0, 1, (float)block.maxZ, (float)block.minZ, 1, 0, 0, (float)block.maxX, (float)block.minX);
            }
            case NORTH: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 2, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 2, meta, 0, 0, -1, (float)block.minZ, -1, 0, 0, 1.0f - (float)block.minX, 1.0f - (float)block.maxX, 0, 1, 0, (float)block.maxY, (float)block.minY);
            }
            case SOUTH: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 3, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 3, meta, 0, 0, 1, 1.0f - (float)block.maxZ, 0, 1, 0, (float)block.maxY, (float)block.minY, -1, 0, 0, 1.0f - (float)block.minX, 1.0f - (float)block.maxX);
            }
            case WEST: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 4, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 4, meta, -1, 0, 0, (float)block.minX, 0, 0, 1, (float)block.maxZ, (float)block.minZ, 0, 1, 0, (float)block.maxY, (float)block.minY);
            }
            case EAST: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 5, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 5, meta, 1, 0, 0, 1.0f - (float)block.maxX, 0, 0, 1, (float)block.maxZ, (float)block.minZ, 0, -1, 0, 1.0f - (float)block.minY, 1.0f - (float)block.maxY);
            }
        }
        throw new IllegalArgumentException("Side " + (Object)((Object)side) + " not expected!");
    }

    public final boolean renderSide(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z, float r, float g, float b, int side, int meta, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        IconCoordinate tex = this.overbright ? blockModel.getBlockOverbrightTexture(this.blockAccess, x, y, z, side) : blockModel.getBlockTexture(this.blockAccess, x, y, z, Side.getSideById(side));
        if (tex == null || (this.renderBitMask >> side & 1) != 0) {
            return false;
        }
        boolean rendered = false;
        block.setBlockBoundsBasedOnSide(this.blockAccess, x, y, z, Side.getSideById(side));
        if (this.renderAllFaces || blockModel.shouldSideBeRendered(this.blockAccess, x + dirX, y + dirY, z + dirZ, side, meta)) {
            this.setupLighting(block, x, y, z, r, g, b, side, meta, dirX, dirY, dirZ, depth, topX, topY, topZ, topP, botP, lefX, lefY, lefZ, lefP, rigP);
            if (side == 0) {
                this.renderBottomFace(tessellator, block, x, y, z, tex);
            } else if (side == 1) {
                this.renderTopFace(tessellator, block, x, y, z, tex);
            } else if (side == 2) {
                this.renderNorthFace(tessellator, block, x, y, z, tex);
            } else if (side == 3) {
                this.renderSouthFace(tessellator, block, x, y, z, tex);
            } else if (side == 4) {
                this.renderWestFace(tessellator, block, x, y, z, tex);
            } else if (side == 5) {
                this.renderEastFace(tessellator, block, x, y, z, tex);
            }
            rendered = true;
        }
        return rendered;
    }

    public final void setupLighting(Block block, int x, int y, int z, float r, float g, float b, int side, int meta, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        float lightTL;
        float lightBL;
        float lightBR;
        float lightTR;
        boolean lefT;
        boolean ao = this.mc.isAmbientOcclusionEnabled();
        if (LightmapHelper.isLightmapEnabled()) {
            int lmc;
            if (this.overbright) {
                this.lightmapCoordBottomRight = this.lightmapCoordTopRight = (lmc = LightmapHelper.getOverbrightLightmapCoord(0));
                this.lightmapCoordBottomLeft = this.lightmapCoordTopRight;
                this.lightmapCoordTopLeft = this.lightmapCoordTopRight;
            } else if (ao) {
                int lmcTopRig;
                int lmcBotLef;
                int lmcTopLef;
                int lmcRig;
                int dirX2 = dirX;
                int dirY2 = dirY;
                int dirZ2 = dirZ;
                if (depth > 0.0625f) {
                    dirX2 = 0;
                    dirY2 = 0;
                    dirZ2 = 0;
                }
                boolean topT = this.cache.getOpacity(dirX2 + topX, dirY2 + topY, dirZ2 + topZ);
                boolean botT = this.cache.getOpacity(dirX2 - topX, dirY2 - topY, dirZ2 - topZ);
                lefT = this.cache.getOpacity(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ);
                boolean rigT = this.cache.getOpacity(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ);
                boolean topLefT = this.cache.getOpacity(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ);
                boolean topRigT = this.cache.getOpacity(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ);
                boolean botLefT = this.cache.getOpacity(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ);
                boolean botRigT = this.cache.getOpacity(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ);
                int lmcCen = this.cache.getLightmapCoord(dirX2, dirY2, dirZ2);
                int lmcTop = topT ? lmcCen : this.cache.getLightmapCoord(dirX2 + topX, dirY2 + topY, dirZ2 + topZ);
                int lmcBot = botT ? lmcCen : this.cache.getLightmapCoord(dirX2 - topX, dirY2 - topY, dirZ2 - topZ);
                int lmcLef = lefT ? lmcCen : this.cache.getLightmapCoord(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ);
                int n = lmcRig = rigT ? lmcCen : this.cache.getLightmapCoord(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ);
                int n2 = topT && lefT ? lmcLef : (lmcTopLef = topLefT ? lmcCen : this.cache.getLightmapCoord(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ));
                int n3 = botT && lefT ? lmcLef : (lmcBotLef = botLefT ? lmcCen : this.cache.getLightmapCoord(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ));
                int n4 = topT && rigT ? lmcRig : (lmcTopRig = topRigT ? lmcCen : this.cache.getLightmapCoord(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ));
                int lmcBotRig = botT && rigT ? lmcRig : (botRigT ? lmcCen : this.cache.getLightmapCoord(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ));
                this.lightmapCoordTopLeft = LightmapHelper.avg(lmcCen, lmcLef, lmcTop, lmcTopLef);
                this.lightmapCoordTopRight = LightmapHelper.avg(lmcCen, lmcRig, lmcTop, lmcTopRig);
                this.lightmapCoordBottomLeft = LightmapHelper.avg(lmcCen, lmcLef, lmcBot, lmcBotLef);
                this.lightmapCoordBottomRight = LightmapHelper.avg(lmcCen, lmcRig, lmcBot, lmcBotRig);
            } else {
                lmc = depth > 0.0625f ? block.getLightmapCoord(this.blockAccess, x, y, z) : block.getLightmapCoord(this.blockAccess, x + dirX, y + dirY, z + dirZ);
                this.lightmapCoordBottomRight = this.lightmapCoordTopRight = lmc;
                this.lightmapCoordBottomLeft = this.lightmapCoordTopRight;
                this.lightmapCoordTopLeft = this.lightmapCoordTopRight;
            }
        }
        if (this.overbright) {
            lightTR = 1.0f;
            lightBR = 1.0f;
            lightBL = 1.0f;
            lightTL = 1.0f;
        } else if (this.field_22352_G <= 0) {
            lightBR = lightTR = this.cache.getBrightness(dirX, dirY, dirZ);
            lightBL = lightTR;
            lightTL = lightTR;
        } else if (ao) {
            float dirB = this.cache.getBrightness(dirX, dirY, dirZ);
            lefT = this.cache.getOpacity(dirX + lefX, dirY + lefY, dirZ + lefZ);
            boolean botT = this.cache.getOpacity(dirX - topX, dirY - topY, dirZ - topZ);
            boolean topT = this.cache.getOpacity(dirX + topX, dirY + topY, dirZ + topZ);
            boolean rigT = this.cache.getOpacity(dirX - lefX, dirY - lefY, dirZ - lefZ);
            float lB = this.cache.getBrightness(dirX + lefX, dirY + lefY, dirZ + lefZ);
            float bB = this.cache.getBrightness(dirX - topX, dirY - topY, dirZ - topZ);
            float tB = this.cache.getBrightness(dirX + topX, dirY + topY, dirZ + topZ);
            float rB = this.cache.getBrightness(dirX - lefX, dirY - lefY, dirZ - lefZ);
            float blB = botT && lefT ? lB : this.cache.getBrightness(dirX + lefX - topX, dirY + lefY - topY, dirZ + lefZ - topZ);
            float tlB = topT && lefT ? lB : this.cache.getBrightness(dirX + lefX + topX, dirY + lefY + topY, dirZ + lefZ + topZ);
            float brB = botT && rigT ? rB : this.cache.getBrightness(dirX - lefX - topX, dirY - lefY - topY, dirZ - lefZ - topZ);
            float trB = topT && rigT ? rB : this.cache.getBrightness(dirX - lefX + topX, dirY - lefY + topY, dirZ - lefZ + topZ);
            lightTL = (tlB + lB + tB + dirB) / 4.0f;
            lightTR = (tB + dirB + trB + rB) / 4.0f;
            lightBR = (dirB + bB + rB + brB) / 4.0f;
            lightBL = (lB + blB + dirB + bB) / 4.0f;
            if (depth > 0.0625f) {
                dirB = this.cache.getBrightness(0, 0, 0);
                lefT = this.cache.getOpacity(lefX, lefY, lefZ);
                botT = this.cache.getOpacity(-topX, -topY, -topZ);
                topT = this.cache.getOpacity(topX, topY, topZ);
                rigT = this.cache.getOpacity(-lefX, -lefY, -lefZ);
                lB = this.cache.getBrightness(lefX, lefY, lefZ);
                bB = this.cache.getBrightness(-topX, -topY, -topZ);
                tB = this.cache.getBrightness(topX, topY, topZ);
                rB = this.cache.getBrightness(-lefX, -lefY, -lefZ);
                blB = botT && lefT ? lB : this.cache.getBrightness(lefX - topX, lefY - topY, lefZ - topZ);
                tlB = topT && lefT ? lB : this.cache.getBrightness(lefX + topX, lefY + topY, lefZ + topZ);
                brB = botT && rigT ? rB : this.cache.getBrightness(-lefX - topX, -lefY - topY, -lefZ - topZ);
                trB = topT && rigT ? rB : this.cache.getBrightness(-lefX + topX, -lefY + topY, -lefZ + topZ);
                lightTL = (tlB + lB + tB + dirB) / 4.0f * depth + lightTL * (1.0f - depth);
                lightTR = (tB + dirB + trB + rB) / 4.0f * depth + lightTR * (1.0f - depth);
                lightBR = (dirB + bB + rB + brB) / 4.0f * depth + lightBR * (1.0f - depth);
                lightBL = (lB + blB + dirB + bB) / 4.0f * depth + lightBL * (1.0f - depth);
            }
        } else {
            float brightness;
            lightBR = lightTR = (brightness = this.cache.getBrightness(dirX, dirY, dirZ));
            lightBL = lightTR;
            lightTL = lightTR;
        }
        if (this.overbright || !enableDirectionalLight) {
            this.colorRedBottomRight = this.colorRedTopRight = r;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = g;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = b;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
        } else {
            this.colorRedBottomRight = this.colorRedTopRight = r * SIDE_LIGHT_MULTIPLIER[side];
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = g * SIDE_LIGHT_MULTIPLIER[side];
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = b * SIDE_LIGHT_MULTIPLIER[side];
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
        }
        float tl = topP * lightTL + (1.0f - topP) * lightBL;
        float tr = topP * lightTR + (1.0f - topP) * lightBR;
        float bl = botP * lightTL + (1.0f - botP) * lightBL;
        float br = botP * lightTR + (1.0f - botP) * lightBR;
        float ltl = lefP * tl + (1.0f - lefP) * tr;
        float lbl = lefP * bl + (1.0f - lefP) * br;
        float lbr = rigP * bl + (1.0f - rigP) * br;
        float ltr = rigP * tl + (1.0f - rigP) * tr;
        this.colorRedTopLeft *= ltl;
        this.colorGreenTopLeft *= ltl;
        this.colorBlueTopLeft *= ltl;
        this.colorRedBottomLeft *= lbl;
        this.colorGreenBottomLeft *= lbl;
        this.colorBlueBottomLeft *= lbl;
        this.colorRedBottomRight *= lbr;
        this.colorGreenBottomRight *= lbr;
        this.colorBlueBottomRight *= lbr;
        this.colorRedTopRight *= ltr;
        this.colorGreenTopRight *= ltr;
        this.colorBlueTopRight *= ltr;
    }

    public void renderBottomFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(block.minX);
        double d4 = tex.getSubIconU(block.maxX);
        double d5 = tex.getSubIconV(block.minZ);
        double d6 = tex.getSubIconV(block.maxZ);
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateBottom == 2) {
            d3 = tex.getSubIconU(block.minX);
            d5 = tex.getSubIconV(1.0 - block.maxX);
            d4 = tex.getSubIconU(block.maxZ);
            d6 = tex.getSubIconV(1.0 - block.minZ);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateBottom == 1) {
            d3 = tex.getSubIconU(1.0 - block.maxZ);
            d5 = tex.getSubIconV(block.minX);
            d4 = tex.getSubIconU(1.0 - block.minZ);
            d6 = tex.getSubIconV(block.maxX);
            d7 = d4;
            d8 = d3;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateBottom == 3) {
            d3 = tex.getSubIconU(1.0 - block.minX);
            d4 = tex.getSubIconU(1.0 - block.minX);
            d5 = tex.getSubIconV(1.0 - block.minZ);
            d6 = tex.getSubIconV(1.0 - block.maxZ);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = x + block.minX;
        double d12 = x + block.maxX;
        double d13 = y + block.minY;
        double d14 = z + block.minZ;
        double d15 = z + block.maxZ;
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        } else {
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        }
    }

    public void renderTopFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(block.minX);
        double d4 = tex.getSubIconU(block.maxX);
        double d5 = tex.getSubIconV(block.minZ);
        double d6 = tex.getSubIconV(block.maxZ);
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = tex.getSubIconU(block.minZ);
            d5 = tex.getSubIconV(1.0 - block.maxX);
            d4 = tex.getSubIconU(block.maxZ);
            d6 = tex.getSubIconV(1.0 - block.minX);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = tex.getSubIconU(1.0 - block.maxZ);
            d5 = tex.getSubIconV(block.minX);
            d4 = tex.getSubIconU(1.0 - block.minZ);
            d6 = tex.getSubIconV(block.maxX);
            d7 = d4;
            d8 = d3;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = tex.getSubIconU(1.0 - block.minX);
            d4 = tex.getSubIconU(1.0 - block.maxX);
            d5 = tex.getSubIconV(1.0 - block.minZ);
            d6 = tex.getSubIconV(1.0 - block.maxZ);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = x + block.minX;
        double d12 = x + block.maxX;
        double d13 = y + block.maxY;
        double d14 = z + block.minZ;
        double d15 = z + block.maxZ;
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        } else {
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        }
    }

    public void renderNorthFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(block.minX);
        double d4 = tex.getSubIconU(block.maxX);
        double d5 = tex.getSubIconV(1.0 - block.maxY);
        double d6 = tex.getSubIconV(1.0 - block.minY);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateEast == 2) {
            d3 = tex.getSubIconU(block.minY);
            d5 = tex.getSubIconV(1.0 - block.minX);
            d4 = tex.getSubIconU(block.maxY);
            d6 = tex.getSubIconV(1.0 - block.maxX);
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateEast == 1) {
            d3 = tex.getSubIconU(1.0 - block.maxY);
            d5 = tex.getSubIconV(block.maxX);
            d4 = tex.getSubIconU(1.0 - block.minY);
            d6 = tex.getSubIconV(block.minX);
            d8 = d4;
            d9 = d3;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = tex.getSubIconU(1.0 - block.minX);
            d4 = tex.getSubIconU(1.0 - block.maxX);
            d5 = tex.getSubIconV(block.maxY);
            d6 = tex.getSubIconV(block.minY);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + block.minX;
        double d13 = x + block.maxX;
        double d14 = y + block.minY;
        double d15 = y + block.maxY;
        double d16 = z + block.minZ;
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        }
    }

    public void renderSouthFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(block.minX);
        double d4 = tex.getSubIconU(block.maxX);
        double d5 = tex.getSubIconV(1.0 - block.maxY);
        double d6 = tex.getSubIconV(1.0 - block.minY);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateWest == 1) {
            d3 = tex.getSubIconU(block.minY);
            d6 = tex.getSubIconV(1.0 - block.minX);
            d4 = tex.getSubIconU(block.maxY);
            d10 = d5 = tex.getSubIconV(1.0 - block.maxX);
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateWest == 2) {
            d3 = tex.getSubIconU(1.0 - block.maxY);
            d5 = tex.getSubIconV(block.minX);
            d4 = tex.getSubIconU(1.0 - block.minY);
            d6 = tex.getSubIconV(block.maxX);
            d8 = d4;
            d9 = d3;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = tex.getSubIconU(1.0 - block.minX);
            d4 = tex.getSubIconU(1.0 - block.maxX);
            d5 = tex.getSubIconV(block.maxY);
            d6 = tex.getSubIconV(block.minY);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double x0 = x + block.minX;
        double x1 = x + block.maxX;
        double y0 = y + block.minY;
        double y1 = y + block.maxY;
        double z0 = z + block.maxZ;
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(x0, y1, z0, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(x0, y0, z0, d9, d11);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(x1, y0, z0, d4, d6);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(x1, y1, z0, d8, d10);
        } else {
            tessellator.addVertexWithUV(x0, y1, z0, d3, d5);
            tessellator.addVertexWithUV(x0, y0, z0, d9, d11);
            tessellator.addVertexWithUV(x1, y0, z0, d4, d6);
            tessellator.addVertexWithUV(x1, y1, z0, d8, d10);
        }
    }

    public void renderWestFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double d3 = tex.getSubIconU(block.minZ);
        double d4 = tex.getSubIconU(block.maxZ);
        double d5 = tex.getSubIconV(1.0 - block.maxY);
        double d6 = tex.getSubIconV(1.0 - block.minY);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = tex.getIconUMin();
            d4 = tex.getIconUMax();
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = tex.getIconVMin();
            d6 = tex.getIconVMax();
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = tex.getSubIconU(block.minY);
            d5 = tex.getSubIconV(1.0 - block.maxZ);
            d4 = tex.getSubIconU(block.maxY);
            d6 = tex.getSubIconV(1.0 - block.minZ);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateNorth == 2) {
            d3 = tex.getSubIconU(1.0 - block.maxY);
            d5 = tex.getSubIconV(block.minZ);
            d4 = tex.getSubIconU(1.0 - block.minY);
            d6 = tex.getSubIconV(block.maxZ);
            d8 = d4;
            d9 = d3;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = tex.getSubIconU(1.0 - block.minZ);
            d4 = tex.getSubIconU(1.0 - block.maxZ);
            d5 = tex.getSubIconV(block.maxY);
            d6 = tex.getSubIconV(block.minY);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + block.minX;
        double d13 = y + block.minY;
        double d14 = y + block.maxY;
        double d15 = z + block.minZ;
        double d16 = z + block.maxZ;
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        }
    }

    public void renderEastFace(Tessellator tessellator, Block block, double x, double y, double z, IconCoordinate tex) {
        if (this.overrideBlockTexture != null) {
            tex = this.overrideBlockTexture;
        }
        if (tex == null) {
            return;
        }
        double uMin = tex.getSubIconU(block.minZ);
        double uMax = tex.getSubIconU(block.maxZ);
        double vMin = tex.getSubIconV(1.0 - block.maxY);
        double vMax = tex.getSubIconV(1.0 - block.minY);
        if (this.flipTexture) {
            double _uMin = uMin;
            uMin = uMax;
            uMax = _uMin;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            uMin = tex.getIconUMin();
            uMax = tex.getIconUMax();
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            vMin = tex.getIconVMin();
            vMax = tex.getIconVMax();
        }
        double uMax2 = uMax;
        double uMin2 = uMin;
        double vMin2 = vMin;
        double vMax2 = vMax;
        if (this.uvRotateSouth == 2) {
            uMin = tex.getSubIconU(block.minY);
            vMin = tex.getSubIconV(1.0 - block.minZ);
            uMax = tex.getSubIconU(block.maxY);
            vMax = tex.getSubIconV(1.0 - block.maxZ);
            vMin2 = vMin;
            vMax2 = vMax;
            uMax2 = uMin;
            uMin2 = uMax;
            vMin = vMax;
            vMax = vMin2;
        } else if (this.uvRotateSouth == 1) {
            uMin = tex.getSubIconU(1.0 - block.maxY);
            vMin = tex.getSubIconV(block.maxZ);
            uMax = tex.getSubIconU(1.0 - block.minY);
            vMax = tex.getSubIconV(block.minZ);
            uMax2 = uMax;
            uMin2 = uMin;
            uMin = uMax2;
            uMax = uMin2;
            vMin2 = vMax;
            vMax2 = vMin;
        } else if (this.uvRotateSouth == 3) {
            uMin = tex.getSubIconU(1.0 - block.minZ);
            uMax = tex.getSubIconU(1.0 - block.maxZ);
            vMin = tex.getSubIconV(block.maxY);
            vMax = tex.getSubIconV(block.minY);
            uMax2 = uMax;
            uMin2 = uMin;
            vMin2 = vMin;
            vMax2 = vMax;
        }
        double xMax = x + block.maxX;
        double yMin = y + block.minY;
        double yMax = y + block.maxY;
        double zMin = z + block.minZ;
        double zMax = z + block.maxZ;
        if (this.enableAO) {
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(xMax, yMin, zMax, uMin2, vMax2);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomLeft);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordBottomRight);
            }
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(xMax, yMax, zMin, uMax2, vMin2);
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.lightmapCoordTopRight);
            }
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMin);
        } else {
            tessellator.addVertexWithUV(xMax, yMin, zMax, uMin2, vMax2);
            tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
            tessellator.addVertexWithUV(xMax, yMax, zMin, uMax2, vMin2);
            tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMin);
        }
    }

    public void renderBlockAsItem(Tessellator tessellator, BlockModel<Block> blockModel, Block block, float var2) {
        blockModel.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float var5 = 0.5f;
        float var6 = 1.0f;
        float var7 = 0.8f;
        float var8 = 0.6f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(var6, var6, var6, var2);
        this.renderBottomFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0));
        tessellator.setColorRGBA_F(var5, var5, var5, var2);
        this.renderTopFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.TOP, 0));
        tessellator.setColorRGBA_F(var7, var7, var7, var2);
        this.renderNorthFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, 0));
        this.renderSouthFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.SOUTH, 0));
        tessellator.setColorRGBA_F(var8, var8, var8, var2);
        this.renderWestFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.WEST, 0));
        this.renderEastFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.EAST, 0));
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

