/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import java.util.Random;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.colorizer.ColorizerGrass;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.noise.ImprovedNoise;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;

public class BlockColorGrass
extends BlockColor {
    protected static ImprovedNoise grassColorPerlin = new ImprovedNoise(new Random(0L));

    @Override
    public int getFallbackColor(int meta) {
        return ColorizerGrass.getGrassColor(0.5, 0.5);
    }

    @Override
    public int getWorldColor(WorldSource world, int x, int y, int z) {
        double localTemperature = world.getBlockTemperature(x, z);
        double localHumidity = world.getBlockHumidity(x, z);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        Season season = world.getSeasonManager().getCurrentSeason();
        if (season != null) {
            boolean isWinter = season == Seasons.OVERWORLD_WINTER || season == Seasons.OVERWORLD_WINTER_ENDLESS;
            float progress = world.getSeasonManager().getSeasonProgress();
            if (isWinter) {
                baseGrassColor = ColorizerGrass.getGrassColor(localTemperature * (double)progress, localHumidity);
            }
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getSeasonManager().getNextSeason() : world.getSeasonManager().getPreviousSeason(), Math.abs(progress - 0.5f));
            if (isWinter) {
                float offsetIntensity = 1.0f - Math.abs(progress - 1.0f);
                float red = (float)((baseGrassColor & 0xFF0000) >> 16) / 255.0f;
                float green = (float)((baseGrassColor & 0xFF00) >> 8) / 255.0f;
                float blue = (float)(baseGrassColor & 0xFF) / 255.0f;
                float gray = red * green * blue / 3.0f;
                float grayOffset = (float)grassColorPerlin.getValue((double)x / 30.0, (double)y / 30.0, (double)z / 30.0) * offsetIntensity * 0.5f;
                if (gray + grayOffset > 0.4f) {
                    grayOffset = 0.4f - gray;
                }
                if (gray + grayOffset < 0.0f) {
                    grayOffset = -gray;
                }
                red += grayOffset;
                green += grayOffset;
                blue += grayOffset;
                if (red < 0.0f) {
                    red = 0.0f;
                }
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green < 0.0f) {
                    green = 0.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue < 0.0f) {
                    blue = 0.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                int newRed = (int)(red * 255.0f) & 0xFF;
                int newGreen = (int)(green * 255.0f) & 0xFF;
                int newBlue = (int)(blue * 255.0f) & 0xFF;
                baseGrassColor = newRed << 16 | newGreen << 8 | newBlue;
            }
        }
        return baseGrassColor;
    }
}

