/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import java.util.Random;
import net.minecraft.client.render.block.color.BlockColorLeaves;
import net.minecraft.client.render.colorizer.ColorProperties;
import net.minecraft.client.render.colorizer.ColorizerFoliage;
import net.minecraft.client.render.colorizer.LeavesColorProperties;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.noise.ImprovedNoise;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;

public class BlockColorLeavesOak
extends BlockColorLeaves {
    private static ImprovedNoise fallColorPerlin = new ImprovedNoise(new Random(0L));

    public BlockColorLeavesOak() {
        super("oak");
    }

    @Override
    public int getWorldColor(WorldSource world, int x, int y, int z) {
        LeavesColorProperties color = ColorProperties.getLeavesColor(this.colorId);
        if (color == null) {
            return 0xFFFFFF;
        }
        int foliageColor = ColorProperties.fRGB2iRGB(color.inventoryR, color.inventoryG, color.inventoryB);
        if (world != null) {
            double temp = world.getBlockTemperature(x, z);
            double hum = world.getBlockHumidity(x, z);
            Season season = world.getSeasonManager().getCurrentSeason();
            if (season != null) {
                float progress = world.getSeasonManager().getSeasonProgress();
                foliageColor = ColorizerFoliage.getSeasonalColor(season, progress, temp, hum, color, true);
                if (season == Seasons.OVERWORLD_FALL) {
                    float offsetIntensity = 1.0f - Math.abs(progress * 2.0f - 1.0f);
                    float green = (float)((foliageColor & 0xFF00) >> 8) / 255.0f;
                    float greenOffset = (float)fallColorPerlin.getValue((double)x / 10.0, (double)y / 10.0, (double)z / 10.0) * offsetIntensity * 0.5f;
                    if (green + greenOffset > 0.8f) {
                        greenOffset = 0.8f - green;
                    }
                    if (green + greenOffset < 0.0f) {
                        greenOffset = -green;
                    }
                    int newGreen = (int)((green + greenOffset) * 255.0f) & 0xFF;
                    foliageColor &= 0xFF00FF;
                    foliageColor |= newGreen << 8;
                }
            }
        }
        return foliageColor;
    }
}

