/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import net.minecraft.client.render.block.color.BlockColorGrass;
import net.minecraft.client.render.colorizer.ColorizerGrass;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;

public class BlockColorTallGrass
extends BlockColorGrass {
    @Override
    public int getWorldColor(WorldSource world, int x, int y, int z) {
        double localTemperature = world.getBlockTemperature(x, z);
        double localHumidity = world.getBlockHumidity(x, z);
        long l1 = (long)x * 3129871L + (long)z * 6129781L + (long)y;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        int xO = (int)((long)x + (l1 >> 14 & 0x1FL));
        int yO = (int)((long)y + (l1 >> 19 & 0x1FL));
        int zO = (int)((long)z + (l1 >> 24 & 0x1FL));
        float offsetT = (float)grassColorPerlin.getValue((double)xO / 32.0, (double)yO / 32.0, (double)z / 32.0) / 2.5f;
        float offsetH = (float)grassColorPerlin.getValue((double)x / 32.0, (double)yO / 32.0, (double)zO / 32.0) / 2.5f;
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature += (double)offsetT, localHumidity += (double)offsetH);
        if (world.getBlockBiome(x, y - 1, z) == Biomes.OVERWORLD_CAATINGA || world.getBlockBiome(x, y - 1, z) == Biomes.OVERWORLD_CAATINGA_PLAINS) {
            Season season = world.getSeasonManager().getCurrentSeason();
            if (season != null) {
                boolean ishumid = season == Seasons.OVERWORLD_WINTER || season == Seasons.OVERWORLD_WINTER_ENDLESS || season == Seasons.OVERWORLD_SPRING;
                float progress = world.getSeasonManager().getSeasonProgress();
                baseGrassColor = ishumid ? ColorizerGrass.getGrassColor(0.95, 0.78) : ColorizerGrass.getGrassColor(0.95, 0.1);
                baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getSeasonManager().getNextSeason() : world.getSeasonManager().getPreviousSeason(), Math.abs(progress - 0.5f));
            }
            return baseGrassColor;
        }
        int blockBelow = world.getBlockId(x, y - 1, z);
        if (blockBelow == Block.grassScorched.id || blockBelow == Block.dirtScorched.id || blockBelow == Block.dirtScorchedRich.id) {
            return 16763992;
        }
        Season season = world.getSeasonManager().getCurrentSeason();
        if (season != null) {
            boolean isWinter = season == Seasons.OVERWORLD_WINTER || season == Seasons.OVERWORLD_WINTER_ENDLESS;
            float progress = world.getSeasonManager().getSeasonProgress();
            if (isWinter) {
                baseGrassColor = ColorizerGrass.getGrassColor(localTemperature * (double)progress, localHumidity);
            }
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getSeasonManager().getNextSeason() : world.getSeasonManager().getPreviousSeason(), Math.abs(progress - 0.5f));
            if (isWinter) {
                float offsetIntensity = 1.0f - Math.abs(progress * 2.0f - 1.0f);
                float red = (float)((baseGrassColor & 0xFF0000) >> 16) / 255.0f;
                float green = (float)((baseGrassColor & 0xFF00) >> 8) / 255.0f;
                float blue = (float)(baseGrassColor & 0xFF) / 255.0f;
                float gray = red * green * blue / 3.0f;
                float grayOffset = (float)grassColorPerlin.getValue((double)x / 30.0, (double)y / 50.0, (double)z / 30.0) * offsetIntensity * 0.5f;
                if (gray + grayOffset > 0.4f) {
                    grayOffset = 0.4f - gray;
                }
                if (gray + grayOffset < 0.0f) {
                    grayOffset = -gray;
                }
                red += grayOffset;
                green += grayOffset;
                blue += grayOffset;
                if (red < 0.0f) {
                    red = 0.0f;
                }
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green < 0.0f) {
                    green = 0.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue < 0.0f) {
                    blue = 0.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                int newRed = (int)(red * 255.0f) & 0xFF;
                int newGreen = (int)(green * 255.0f) & 0xFF;
                int newBlue = (int)(blue * 255.0f) & 0xFF;
                baseGrassColor = newRed << 16 | newGreen << 8 | newBlue;
            }
        }
        return baseGrassColor;
    }
}

