/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelLadder<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelLadder(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelLadder.renderBlocks.blockAccess, x, y, z);
        int k1 = BlockModelLadder.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        IconCoordinate l = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, k1);
        if (BlockModelLadder.renderBlocks.overrideBlockTexture != null) {
            l = BlockModelLadder.renderBlocks.overrideBlockTexture;
        }
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = this.getBlockBrightness(BlockModelLadder.renderBlocks.blockAccess, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelLadder.renderBlocks.blockAccess, x, y, z));
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double d = l.getIconUMin();
        double d1 = l.getIconUMax();
        double d2 = l.getIconVMin();
        double d3 = l.getIconVMax();
        float f1 = 0.0f;
        float f2 = 0.05f;
        if (k1 == 5) {
            tessellator.addVertexWithUV((float)x + f2, (float)(y + 1) + f1, (float)(z + 1) + f1, d, d2);
            tessellator.addVertexWithUV((float)x + f2, (float)y - f1, (float)(z + 1) + f1, d, d3);
            tessellator.addVertexWithUV((float)x + f2, (float)y - f1, (float)z - f1, d1, d3);
            tessellator.addVertexWithUV((float)x + f2, (float)(y + 1) + f1, (float)z - f1, d1, d2);
        }
        if (k1 == 4) {
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)y - f1, (float)(z + 1) + f1, d1, d3);
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)(y + 1) + f1, (float)(z + 1) + f1, d1, d2);
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)(y + 1) + f1, (float)z - f1, d, d2);
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)y - f1, (float)z - f1, d, d3);
        }
        if (k1 == 3) {
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)y - f1, (float)z + f2, d1, d3);
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)(y + 1) + f1, (float)z + f2, d1, d2);
            tessellator.addVertexWithUV((float)x - f1, (float)(y + 1) + f1, (float)z + f2, d, d2);
            tessellator.addVertexWithUV((float)x - f1, (float)y - f1, (float)z + f2, d, d3);
        }
        if (k1 == 2) {
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)(y + 1) + f1, (float)(z + 1) - f2, d, d2);
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)y - f1, (float)(z + 1) - f2, d, d3);
            tessellator.addVertexWithUV((float)x - f1, (float)y - f1, (float)(z + 1) - f2, d1, d3);
            tessellator.addVertexWithUV((float)x - f1, (float)(y + 1) + f1, (float)(z + 1) - f2, d1, d2);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

