/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.piston.BlockPistonHead;
import net.minecraft.core.util.helper.Side;

public class BlockModelPistonHead
extends BlockModelStandard<BlockPistonHead> {
    protected IconCoordinate pistonSide = TextureRegistry.getTexture("minecraft:block/piston_side");
    protected IconCoordinate pistonDry = TextureRegistry.getTexture("minecraft:block/piston_face");
    protected IconCoordinate pistonSticky = TextureRegistry.getTexture("minecraft:block/piston_face_sticky");

    public BlockModelPistonHead(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockPistonHead)this.block).setBlockBoundsBasedOnState(BlockModelPistonHead.renderBlocks.blockAccess, x, y, z);
        return this.renderPistonHead(tessellator, (BlockPistonHead)this.block, x, y, z, true);
    }

    public void renderPistonHeadNoCulling(Tessellator tessellator, BlockPistonHead block, int x, int y, int z, boolean flag) {
        BlockModelPistonHead.renderBlocks.renderAllFaces = true;
        this.renderPistonHead(tessellator, block, x, y, z, flag);
        BlockModelPistonHead.renderBlocks.renderAllFaces = false;
    }

    protected boolean renderPistonHead(Tessellator tessellator, BlockPistonHead block, int x, int y, int z, boolean flag) {
        int metadata = BlockModelPistonHead.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int direction = BlockPistonHead.getDirectionFromMeta(metadata);
        float brightness = this.getBlockBrightness(BlockModelPistonHead.renderBlocks.blockAccess, x, y, z);
        float f1 = flag ? 1.0f : 0.5f;
        double width = flag ? 1.0 : 0.5;
        switch (direction) {
            case 0: {
                BlockModelPistonHead.renderBlocks.uvRotateEast = 3;
                BlockModelPistonHead.renderBlocks.uvRotateWest = 3;
                BlockModelPistonHead.renderBlocks.uvRotateSouth = 3;
                BlockModelPistonHead.renderBlocks.uvRotateNorth = 3;
                block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.625f, (float)y + 0.25f, (float)y + 0.25f + f1, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.375f, (float)y + 0.25f, (float)y + 0.25f + f1, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.375f, (float)y + 0.25f, (float)y + 0.25f + f1, (float)z + 0.375f, (float)z + 0.625f, brightness * 0.6f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.625f, (float)y + 0.25f, (float)y + 0.25f + f1, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.6f, width);
                break;
            }
            case 1: {
                block.setBlockBounds(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.625f, (float)y - 0.25f + 1.0f - f1, (float)y - 0.25f + 1.0f, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.375f, (float)y - 0.25f + 1.0f - f1, (float)y - 0.25f + 1.0f, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.375f, (float)y - 0.25f + 1.0f - f1, (float)y - 0.25f + 1.0f, (float)z + 0.375f, (float)z + 0.625f, brightness * 0.6f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.625f, (float)y - 0.25f + 1.0f - f1, (float)y - 0.25f + 1.0f, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.6f, width);
                break;
            }
            case 2: {
                BlockModelPistonHead.renderBlocks.uvRotateSouth = 1;
                BlockModelPistonHead.renderBlocks.uvRotateNorth = 2;
                block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.25f, (float)z + 0.25f + f1, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.25f, (float)z + 0.25f + f1, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.25f, (float)z + 0.25f + f1, brightness * 0.5f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.25f, (float)z + 0.25f + f1, brightness, width);
                break;
            }
            case 3: {
                BlockModelPistonHead.renderBlocks.uvRotateSouth = 2;
                BlockModelPistonHead.renderBlocks.uvRotateNorth = 1;
                BlockModelPistonHead.renderBlocks.uvRotateTop = 3;
                BlockModelPistonHead.renderBlocks.uvRotateBottom = 3;
                block.setBlockBounds(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (float)z - 0.25f + 1.0f - f1, (float)z - 0.25f + 1.0f, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (float)z - 0.25f + 1.0f - f1, (float)z - 0.25f + 1.0f, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (float)z - 0.25f + 1.0f - f1, (float)z - 0.25f + 1.0f, brightness * 0.5f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (float)z - 0.25f + 1.0f - f1, (float)z - 0.25f + 1.0f, brightness, width);
                break;
            }
            case 4: {
                BlockModelPistonHead.renderBlocks.uvRotateEast = 1;
                BlockModelPistonHead.renderBlocks.uvRotateWest = 2;
                BlockModelPistonHead.renderBlocks.uvRotateTop = 2;
                BlockModelPistonHead.renderBlocks.uvRotateBottom = 1;
                block.setBlockBounds(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadEastWest(tessellator, (float)x + 0.25f, (float)x + 0.25f + f1, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.5f, width);
                this.renderHeadEastWest(tessellator, (float)x + 0.25f, (float)x + 0.25f + f1, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, brightness, width);
                this.renderHeadEastWest(tessellator, (float)x + 0.25f, (float)x + 0.25f + f1, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.6f, width);
                this.renderHeadEastWest(tessellator, (float)x + 0.25f, (float)x + 0.25f + f1, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.6f, width);
                break;
            }
            case 5: {
                BlockModelPistonHead.renderBlocks.uvRotateEast = 2;
                BlockModelPistonHead.renderBlocks.uvRotateWest = 1;
                BlockModelPistonHead.renderBlocks.uvRotateTop = 1;
                BlockModelPistonHead.renderBlocks.uvRotateBottom = 2;
                block.setBlockBounds(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadEastWest(tessellator, (float)x - 0.25f + 1.0f - f1, (float)x - 0.25f + 1.0f, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.5f, width);
                this.renderHeadEastWest(tessellator, (float)x - 0.25f + 1.0f - f1, (float)x - 0.25f + 1.0f, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, brightness, width);
                this.renderHeadEastWest(tessellator, (float)x - 0.25f + 1.0f - f1, (float)x - 0.25f + 1.0f, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.6f, width);
                this.renderHeadEastWest(tessellator, (float)x - 0.25f + 1.0f - f1, (float)x - 0.25f + 1.0f, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.6f, width);
            }
        }
        this.resetRenderBlocks();
        block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    private void renderHeadTopBottom(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = this.pistonSide;
        if (BlockModelPistonHead.renderBlocks.overrideBlockTexture != null) {
            i = BlockModelPistonHead.renderBlocks.overrideBlockTexture;
        }
        double uMin = i.getIconUMin();
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(width);
        double vMax = i.getSubIconV(0.25);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMin, yMax, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMax, vMax);
    }

    private void renderHeadNorthSouth(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = this.pistonSide;
        if (BlockModelPistonHead.renderBlocks.overrideBlockTexture != null) {
            i = BlockModelPistonHead.renderBlocks.overrideBlockTexture;
        }
        double uMin = i.getIconUMin();
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(width);
        double vMax = i.getSubIconV(0.25);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMax, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMax, vMax);
    }

    private void renderHeadEastWest(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = this.pistonSide;
        if (BlockModelPistonHead.renderBlocks.overrideBlockTexture != null) {
            i = BlockModelPistonHead.renderBlocks.overrideBlockTexture;
        }
        double uMin = i.getIconUMin();
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(width);
        double vMax = i.getSubIconV(0.25);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMax, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMax, vMax);
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int direction = BlockPistonHead.getDirectionFromMeta(data);
        if (side.getId() == direction) {
            if (((BlockPistonHead)this.block).faceTexture != null) {
                return ((BlockPistonHead)this.block).faceTexture;
            }
            if ((data & 8) != 0) {
                return this.pistonSticky;
            }
            return this.pistonDry;
        }
        return side.getId() != PistonDirections.directionMap[direction] ? this.pistonSide : this.pistonDry;
    }
}

