/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.render.camera.ICamera;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public abstract class CameraUtil {
    public static HitResult traceRay(ICamera camera, World world, double distance, float partialTick) {
        Vec3d pos = camera.getPosition(partialTick);
        Vec3d rot = camera.getRotationVector(partialTick);
        Vec3d endPos = pos.addVector(rot.xCoord * distance, rot.yCoord * distance, rot.zCoord * distance);
        return world.checkBlockCollisionBetweenPoints(pos, endPos);
    }

    public static boolean isUnderLiquid(ICamera camera, World world, Material material, float partialTick) {
        int z;
        int y;
        double cameraY = camera.getY(partialTick);
        int x = MathHelper.floor_double(camera.getX(partialTick));
        int id = world.getBlockId(x, y = MathHelper.floor_float(MathHelper.floor_double(cameraY)), z = MathHelper.floor_double(camera.getZ(partialTick)));
        if (id != 0 && Block.blocksList[id].blockMaterial == material) {
            float f = BlockFluid.getWaterVolume(world.getBlockMetadata(x, y, z)) - 0.2f;
            float f1 = (float)(y + 1) - f;
            return cameraY < (double)f1;
        }
        return false;
    }
}

