/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.render.colorizer.LeavesColorProperties;
import net.minecraft.core.world.season.SeasonColorProperties;

public class ColorProperties {
    private static final Map<String, SeasonColorProperties> seasonColors = new HashMap<String, SeasonColorProperties>();
    private static final Map<String, LeavesColorProperties> leavesColors = new HashMap<String, LeavesColorProperties>();

    public static void loadColors(Properties prop) {
        ColorProperties.registerSeasonColor("spring", prop);
        ColorProperties.registerSeasonColor("summer", prop);
        ColorProperties.registerSeasonColor("fall", prop);
        ColorProperties.registerSeasonColor("winter", prop);
        ColorProperties.registerLeavesColor("oak", prop);
        ColorProperties.registerLeavesColor("pine", prop);
        ColorProperties.registerLeavesColor("birch", prop);
        ColorProperties.registerLeavesColor("cherry", prop);
        ColorProperties.registerLeavesColor("eucalyptus", prop);
        ColorProperties.registerLeavesColor("shrub", prop);
        ColorProperties.registerLeavesColor("caatinga", prop);
        ColorProperties.registerLeavesColor("cocoa", prop);
    }

    private static void registerSeasonColor(String name, Properties prop) {
        seasonColors.put(name, new SeasonColorProperties(name, prop));
    }

    private static void registerLeavesColor(String name, Properties prop) {
        leavesColors.put(name, new LeavesColorProperties(name, prop));
    }

    public static SeasonColorProperties getSeasonColor(String name) {
        return seasonColors.get(name);
    }

    public static LeavesColorProperties getLeavesColor(String name) {
        return leavesColors.get(name);
    }

    public static int fRGB2iRGB(float r, float g, float b) {
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) << 0;
    }
}

