/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import net.minecraft.client.render.colorizer.ColorProperties;
import net.minecraft.client.render.colorizer.LeavesColorProperties;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;

public class ColorizerFoliage {
    private static int[] foliageBuffer = new int[65536];

    public static void updateColorData(int[] ai) {
        foliageBuffer = ai;
    }

    private static int getFoliageColor(double d, double d1) {
        int i = (int)((1.0 - d) * 255.0);
        int j = (int)((1.0 - (d1 *= d)) * 255.0);
        return foliageBuffer[j << 8 | i];
    }

    private static int getPeakSeasonalColor(Season season, double temp, double hum, LeavesColorProperties lcp) {
        int myColor = ColorProperties.fRGB2iRGB(lcp.inventoryR, lcp.inventoryG, lcp.inventoryB);
        if (season == Seasons.OVERWORLD_SPRING) {
            myColor = lcp.overrideSpring ? ColorProperties.fRGB2iRGB(lcp.springR, lcp.springG, lcp.springB) : ColorizerFoliage.getFoliageColor(temp, hum);
        } else if (season == Seasons.OVERWORLD_SUMMER) {
            myColor = lcp.overrideSummer ? ColorProperties.fRGB2iRGB(lcp.summerR, lcp.summerG, lcp.summerB) : ColorizerFoliage.getFoliageColor(temp, hum);
        } else if (season == Seasons.OVERWORLD_FALL) {
            myColor = lcp.overrideFall ? ColorProperties.fRGB2iRGB(lcp.fallR, lcp.fallG, lcp.fallB) : ColorizerFoliage.getFoliageColor(temp, hum);
        } else if (season == Seasons.OVERWORLD_WINTER || season == Seasons.OVERWORLD_WINTER_ENDLESS) {
            myColor = lcp.overrideWinter ? ColorProperties.fRGB2iRGB(lcp.winterR, lcp.winterG, lcp.winterB) : ColorizerFoliage.getFoliageColor(temp, hum);
        }
        return myColor;
    }

    public static int getSeasonalColor(Season season, float progress, double temp, double hum, LeavesColorProperties lcp) {
        return ColorizerFoliage.getSeasonalColor(season, progress, temp, hum, lcp, false);
    }

    public static int getSeasonalColor(Season season, float progress, double temp, double hum, LeavesColorProperties lcp, boolean applySeasonalTransform) {
        int myColor = ColorizerFoliage.getPeakSeasonalColor(season, temp, hum, lcp);
        int otherColor = ColorizerFoliage.getPeakSeasonalColor(season, temp, hum, lcp);
        float blend = Math.abs(progress - 0.5f);
        Season otherSeason = season == Seasons.OVERWORLD_SPRING ? (progress < 0.5f ? Seasons.OVERWORLD_WINTER : Seasons.OVERWORLD_SUMMER) : (season == Seasons.OVERWORLD_SUMMER ? (progress < 0.5f ? Seasons.OVERWORLD_SPRING : Seasons.OVERWORLD_FALL) : (season == Seasons.OVERWORLD_FALL ? (progress < 0.5f ? Seasons.OVERWORLD_SUMMER : Seasons.OVERWORLD_WINTER) : (season == Seasons.OVERWORLD_WINTER ? (progress < 0.5f ? Seasons.OVERWORLD_FALL : Seasons.OVERWORLD_SPRING) : season)));
        if (otherSeason != null) {
            otherColor = ColorizerFoliage.getPeakSeasonalColor(otherSeason, temp, hum, lcp);
            if (applySeasonalTransform) {
                myColor = season.modifyFoliageColorizer(myColor, otherSeason, blend);
            }
        }
        return Season.blendColors(myColor, otherColor, blend);
    }
}

