/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.model.ModelSpider;
import net.minecraft.core.Global;
import net.minecraft.core.entity.monster.EntitySpider;
import org.lwjgl.opengl.GL11;

public class SpiderRenderer
extends LivingRenderer<EntitySpider> {
    public SpiderRenderer() {
        super(new ModelSpider(0.0f), 1.0f);
        this.setRenderPassModel(new ModelSpider(0.01f));
    }

    protected float setSpiderDeathMaxRotation(EntitySpider spider) {
        return 180.0f;
    }

    protected boolean setSpiderEyeBrightness(EntitySpider spider, int renderPass, float partialTick) {
        if (renderPass == 0) {
            boolean useVariants = (Boolean)Minecraft.getMinecraft((Object)this).gameSettings.mobVariants.value;
            this.loadTexture("/assets/minecraft/textures/entity/spider/eyes/" + (useVariants ? spider.getSkinVariant() : 0) + ".png");
            float brightness = spider.getBrightness(1.0f);
            if (Global.accessor.isFullbrightEnabled()) {
                brightness = 1.0f;
            }
            float f1 = (1.0f - brightness) * 0.5f;
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            return true;
        }
        return false;
    }

    @Override
    protected float getDeathMaxRotation(EntitySpider entity) {
        return this.setSpiderDeathMaxRotation(entity);
    }

    @Override
    protected boolean shouldRenderPass(EntitySpider entity, int renderPass, float partialTick) {
        return this.setSpiderEyeBrightness(entity, renderPass, partialTick);
    }
}

