/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.MapItemRenderer;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.PlayerRenderer;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import org.lwjgl.opengl.GL11;

public class ItemModelMap
extends ItemModelStandard {
    private final Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
    private final MapItemRenderer renderMapInstance;

    public ItemModelMap(Item item, String namespace) {
        super(item, namespace);
        this.renderMapInstance = new MapItemRenderer(this.mc.fontRenderer, this.mc.gameSettings, this.mc.renderEngine);
    }

    @Override
    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, EntityPlayer player, ItemStack stack, float partialTick) {
        int blockX = MathHelper.floor_double(player.x);
        int blockY = MathHelper.floor_double(player.y);
        int blockZ = MathHelper.floor_double(player.z);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            LightmapHelper.setLightmapCoord(this.mc.theWorld.getLightmapCoord(blockX, blockY, blockZ, 0));
        } else if (!this.mc.fullbright) {
            brightness = this.mc.theWorld.getLightBrightness(blockX, blockY, blockZ);
        }
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * partialTick;
        float swingProgress = player.getSwingProgress(partialTick);
        float f_z = MathHelper.sin(swingProgress * (float)Math.PI);
        float f_x = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glTranslatef((float)(-f_x * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-f_z * 0.2f));
        float f_val = MathHelper.clamp(1.0f - rotationPitch / 45.0f + 0.1f, 0.0f, 1.0f);
        f_val = -MathHelper.cos(f_val * (float)Math.PI) * 0.5f + 0.5f;
        float zOff = -0.71999997f;
        GL11.glTranslatef((float)0.0f, (float)(-(1.0f - renderer.getEquippedProgress(partialTick)) * 1.2f - f_val * 0.5f + 0.04f), (float)-0.71999997f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(f_val * -85.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        this.mc.renderEngine.loadDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
        PlayerRenderer playerRenderer = (PlayerRenderer)EntityRenderDispatcher.instance.getRenderer(this.mc.thePlayer);
        for (int side = -1; side < 2; side += 2) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.0f, (float)-0.6f, (float)(1.1f * (float)side));
            GL11.glRotatef((float)(-45 * side), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)59.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-65 * side), (float)0.0f, (float)1.0f, (float)0.0f);
            playerRenderer.drawFirstPersonHand(this.mc.thePlayer);
            GL11.glPopMatrix();
        }
        float f_val3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
        float f_val4 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glRotatef((float)(-f_val3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f_val4 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-f_val4 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float scale1 = 0.38f;
        GL11.glScalef((float)0.38f, (float)0.38f, (float)0.38f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
        float scale2 = 0.015625f;
        GL11.glScalef((float)0.015625f, (float)0.015625f, (float)0.015625f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/misc/mapbg.png"));
        tessellator.startDrawingQuads();
        int expansion = 7;
        tessellator.addVertexWithUV(-7.0, 135.0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(135.0, 135.0, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(135.0, -7.0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(-7.0, -7.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        ItemMapSavedData mapData = Item.map.getOrCreateSavedData(stack, this.mc.theWorld);
        this.renderMapInstance.renderMap(this.mc.renderEngine, mapData, brightness);
    }
}

