/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.Global;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ModelWolf
extends ModelBase {
    public Cube wolfHeadMain;
    public Cube wolfBody;
    public Cube wolfLeg1;
    public Cube wolfLeg2;
    public Cube wolfLeg3;
    public Cube wolfLeg4;
    Cube wolfRightEar;
    Cube wolfLeftEar;
    Cube wolfSnout;
    Cube wolfTail;
    Cube wolfMane;

    public ModelWolf(float expandAmount) {
        float f1 = 13.5f;
        this.wolfHeadMain = new Cube(0, 0);
        this.wolfHeadMain.addBox(-3.0f, -3.0f, -2.0f, 6, 6, 4, expandAmount);
        this.wolfHeadMain.setRotationPoint(-1.0f, f1, -7.0f);
        this.wolfBody = new Cube(18, 14);
        this.wolfBody.addBox(-4.0f, -2.0f, -3.0f, 6, 9, 6, expandAmount);
        this.wolfBody.setRotationPoint(0.0f, 14.0f, 2.0f);
        this.wolfMane = new Cube(21, 0);
        this.wolfMane.addBox(-4.0f, -3.0f, -3.0f, 8, 6, 7, expandAmount);
        this.wolfMane.setRotationPoint(-1.0f, 14.0f, 2.0f);
        this.wolfLeg1 = new Cube(0, 18);
        this.wolfLeg1.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg1.setRotationPoint(-2.5f, 16.0f, 7.0f);
        this.wolfLeg2 = new Cube(0, 18);
        this.wolfLeg2.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg2.setRotationPoint(0.5f, 16.0f, 7.0f);
        this.wolfLeg3 = new Cube(0, 18);
        this.wolfLeg3.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg3.setRotationPoint(-2.5f, 16.0f, -4.0f);
        this.wolfLeg4 = new Cube(0, 18);
        this.wolfLeg4.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfLeg4.setRotationPoint(0.5f, 16.0f, -4.0f);
        this.wolfTail = new Cube(9, 18);
        this.wolfTail.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, expandAmount);
        this.wolfTail.setRotationPoint(-1.0f, 12.0f, 8.0f);
        this.wolfRightEar = new Cube(16, 14);
        this.wolfRightEar.addBox(-3.0f, -5.0f, 0.0f, 2, 2, 1, expandAmount);
        this.wolfRightEar.setRotationPoint(-1.0f, f1, -7.0f);
        this.wolfLeftEar = new Cube(16, 14);
        this.wolfLeftEar.addBox(1.0f, -5.0f, 0.0f, 2, 2, 1, expandAmount);
        this.wolfLeftEar.setRotationPoint(-1.0f, f1, -7.0f);
        this.wolfSnout = new Cube(0, 10);
        this.wolfSnout.addBox(-2.0f, 0.0f, -5.0f, 3, 3, 4, expandAmount);
        this.wolfSnout.setRotationPoint(-0.5f, f1, -7.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.render(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.setRotationAngles(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.wolfHeadMain.renderWithRotation(scale);
        this.wolfBody.render(scale);
        this.wolfLeg1.render(scale);
        this.wolfLeg2.render(scale);
        this.wolfLeg3.render(scale);
        this.wolfLeg4.render(scale);
        this.wolfRightEar.renderWithRotation(scale);
        this.wolfLeftEar.renderWithRotation(scale);
        this.wolfSnout.renderWithRotation(scale);
        this.wolfTail.renderWithRotation(scale);
        this.wolfMane.render(scale);
    }

    @Override
    public void setLivingAnimations(EntityLiving entityliving, float limbSwing, float limbYaw, float partialTick) {
        float f3;
        EntityWolf entitywolf = (EntityWolf)entityliving;
        this.wolfTail.rotateAngleY = entitywolf.isWolfAngry() ? 0.0f : MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        if (entitywolf.isWolfSitting()) {
            this.wolfMane.setRotationPoint(-1.0f, 16.0f, -3.0f);
            this.wolfMane.rotateAngleX = 1.256637f;
            this.wolfMane.rotateAngleY = 0.0f;
            this.wolfBody.setRotationPoint(0.0f, 18.0f, 0.0f);
            this.wolfBody.rotateAngleX = 0.7853982f;
            this.wolfTail.setRotationPoint(-1.0f, 21.0f, 6.0f);
            this.wolfLeg1.setRotationPoint(-2.5f, 22.0f, 2.0f);
            this.wolfLeg1.rotateAngleX = 4.712389f;
            this.wolfLeg2.setRotationPoint(0.5f, 22.0f, 2.0f);
            this.wolfLeg2.rotateAngleX = 4.712389f;
            this.wolfLeg3.rotateAngleX = 5.811947f;
            this.wolfLeg3.setRotationPoint(-2.49f, 17.0f, -4.0f);
            this.wolfLeg4.rotateAngleX = 5.811947f;
            this.wolfLeg4.setRotationPoint(0.51f, 17.0f, -4.0f);
        } else {
            this.wolfBody.setRotationPoint(0.0f, 14.0f, 2.0f);
            this.wolfBody.rotateAngleX = 1.570796f;
            this.wolfMane.setRotationPoint(-1.0f, 14.0f, -3.0f);
            this.wolfMane.rotateAngleX = this.wolfBody.rotateAngleX;
            this.wolfTail.setRotationPoint(-1.0f, 12.0f, 8.0f);
            this.wolfLeg1.setRotationPoint(-2.5f, 16.0f, 7.0f);
            this.wolfLeg2.setRotationPoint(0.5f, 16.0f, 7.0f);
            this.wolfLeg3.setRotationPoint(-2.5f, 16.0f, -4.0f);
            this.wolfLeg4.setRotationPoint(0.5f, 16.0f, -4.0f);
            this.wolfLeg1.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
            this.wolfLeg2.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 1.4f * limbYaw;
            this.wolfLeg3.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 1.4f * limbYaw;
            this.wolfLeg4.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        }
        this.wolfHeadMain.rotateAngleZ = f3 = entitywolf.getInterestedAngle(partialTick) + entitywolf.getShakeAngle(partialTick, 0.0f);
        this.wolfRightEar.rotateAngleZ = f3;
        this.wolfLeftEar.rotateAngleZ = f3;
        this.wolfSnout.rotateAngleZ = f3;
        this.wolfMane.rotateAngleZ = entitywolf.getShakeAngle(partialTick, -0.08f);
        this.wolfBody.rotateAngleZ = entitywolf.getShakeAngle(partialTick, -0.16f);
        this.wolfTail.rotateAngleZ = entitywolf.getShakeAngle(partialTick, -0.2f);
        if (entitywolf.getWolfShaking()) {
            float brightness = entitywolf.getBrightness(partialTick);
            if (Global.accessor.isFullbrightEnabled()) {
                brightness = 1.0f;
            }
            float f4 = brightness * entitywolf.getShadingWhileShaking(partialTick);
            GL11.glColor3f((float)f4, (float)f4, (float)f4);
        }
    }

    @Override
    public void setRotationAngles(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setRotationAngles(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.wolfHeadMain.rotateAngleX = headPitch / 57.29578f;
        this.wolfRightEar.rotateAngleY = this.wolfHeadMain.rotateAngleY = headYaw / 57.29578f;
        this.wolfRightEar.rotateAngleX = this.wolfHeadMain.rotateAngleX;
        this.wolfLeftEar.rotateAngleY = this.wolfHeadMain.rotateAngleY;
        this.wolfLeftEar.rotateAngleX = this.wolfHeadMain.rotateAngleX;
        this.wolfSnout.rotateAngleY = this.wolfHeadMain.rotateAngleY;
        this.wolfSnout.rotateAngleX = this.wolfHeadMain.rotateAngleX;
        this.wolfTail.rotateAngleX = limbPitch;
    }
}

