/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.stitcher;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.util.helper.Textures;
import org.jetbrains.annotations.Nullable;

public class AtlasStitcher {
    private static final Minecraft mc = Minecraft.getMinecraft(AtlasStitcher.class);
    public static final String rootAssetPath = "/assets";
    public Map<String, IconCoordinate> textureMap = new HashMap<String, IconCoordinate>();
    public BufferedImage atlas;
    public final String directoryPath;
    @Nullable
    public final String defaultTexture;
    private int atlasWidth;
    private int atlasHeight;
    private double invWidth;
    private double invHeight;
    private final int textureId;
    private final boolean mipmap;

    public AtlasStitcher(String directoryPath, boolean mipmap, @Nullable String defaultTexture) {
        this.directoryPath = directoryPath;
        this.textureId = GLAllocation.generateTexture();
        this.mipmap = mipmap;
        this.defaultTexture = defaultTexture;
    }

    protected IconCoordinate getTexture(String key) {
        if (this.textureMap.containsKey(key)) {
            return this.textureMap.get(key);
        }
        IconCoordinate iconCoordinate = new IconCoordinate(this, key, this.getSourceImagePath(key));
        this.textureMap.put(key, iconCoordinate);
        return iconCoordinate;
    }

    public String getSourceImagePath(String key) {
        String[] split = key.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Key '" + key + "' is improperly formatted!");
        }
        return String.format("%s/%s/%s/%s.png", rootAssetPath, split[0], this.directoryPath, split[1]);
    }

    public void generateAtlas() {
        int area = 0;
        int maxWidth = 0;
        ArrayList<IconCoordinate> coordinateList = new ArrayList<IconCoordinate>(this.textureMap.values());
        for (IconCoordinate coordinate : coordinateList) {
            BufferedImage image = Textures.readImage(AtlasStitcher.mc.texturePackList.getResourceAsStream(coordinate.sourceImage));
            if (image == null || image == Textures.missingTexture) {
                System.out.println(coordinate.sourceImage + " could not be found!");
                if (this.defaultTexture != null) {
                    image = Textures.readImage(AtlasStitcher.mc.texturePackList.getResourceAsStream(this.defaultTexture));
                }
                if (image == null) {
                    image = Textures.missingTexture;
                }
            }
            coordinate.setImage(image);
            coordinate.setDimension(image.getWidth(), image.getHeight());
            area += coordinate.getArea();
            if (coordinate.width <= maxWidth) continue;
            maxWidth = coordinate.width;
        }
        int targetWidth = (int)Math.max(Math.ceil(Math.sqrt(area)), (double)maxWidth);
        Collections.sort(coordinateList);
        int nextX = 0;
        int currentY = 0;
        int nextY = ((IconCoordinate)coordinateList.get((int)0)).height;
        int maxRealWidth = 0;
        for (IconCoordinate coordinate : coordinateList) {
            if (nextX + coordinate.width > targetWidth) {
                nextX = 0;
                currentY = nextY;
                nextY += coordinate.height;
            }
            coordinate.setPosition(nextX, currentY);
            if ((nextX += coordinate.width) <= maxRealWidth) continue;
            maxRealWidth = nextX;
        }
        int length = Math.max(maxRealWidth, nextY);
        BufferedImage generatedAtlas = new BufferedImage(length, length, 2);
        Graphics2D atlas = generatedAtlas.createGraphics();
        atlas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (IconCoordinate coordinate : coordinateList) {
            coordinate.drawToAtlas(atlas);
            coordinate.discardImage();
        }
        atlas.dispose();
        this.atlasWidth = generatedAtlas.getWidth();
        this.atlasHeight = generatedAtlas.getHeight();
        this.invWidth = 1.0 / (double)this.atlasWidth;
        this.invHeight = 1.0 / (double)this.atlasHeight;
        this.atlas = generatedAtlas;
        AtlasStitcher.mc.renderEngine.setupTexture(this.atlas, this.textureId, this.mipmap);
    }

    public void bindTexture() {
        AtlasStitcher.mc.renderEngine.bindTexture(this.textureId);
    }

    public int getTextureId() {
        return this.textureId;
    }

    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    public double getInverseWidth() {
        return this.invWidth;
    }

    public double getInverseHeight() {
        return this.invHeight;
    }
}

