/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import net.minecraft.client.FullscreenHelper;
import net.minecraft.client.GameResolution;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.core.Global;
import net.minecraft.core.UnexpectedThrowable;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

public class GameWindowLWJGL2
implements GameWindow {
    public Minecraft mc;
    public FullscreenHelper fullscreenHelper;
    public DisplayMode defaultDisplayMode;

    @Override
    public void init(Minecraft minecraft) throws LWJGLException {
        this.mc = minecraft;
        this.fullscreenHelper = new FullscreenHelper(minecraft);
        this.defaultDisplayMode = Display.getDisplayMode();
        Display.setDisplayMode((DisplayMode)new DisplayMode(GameResolution.defaultWidth, GameResolution.defaultHeight));
        Display.setTitle((String)("Better than Adventure! " + Global.VERSION));
        this.setIcon();
        try {
            PixelFormat pixelformat = new PixelFormat();
            pixelformat = pixelformat.withDepthBits(24);
            Display.create((PixelFormat)pixelformat);
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
    }

    @Override
    public void toggleFullscreen() {
        this.fullscreenHelper.toggleFullscreen();
    }

    @Override
    public void updateWindowState() {
        this.fullscreenHelper.updateWindowState();
    }

    @Override
    public boolean isBorderlessFullscreenSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIcon() {
        int[] resolutions = new int[]{16, 32, 64, 128, 256};
        ByteBuffer[] buffers = new ByteBuffer[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            BufferedImage image;
            int resolution = resolutions[i];
            String texturePath = "/icon/" + resolution + ".png";
            InputStream stream = null;
            try {
                stream = this.getClass().getResourceAsStream(texturePath);
                image = ImageIO.read(stream);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            if (image.getWidth() != resolution || image.getHeight() != resolution) {
                System.out.println("Icon '" + texturePath + "' has the wrong resolution. Expected " + resolution + " x " + resolution + ", but got " + image.getWidth() + "x " + image.getHeight() + "!");
                return;
            }
            ByteBuffer buffer = ByteBuffer.allocate(resolution * resolution * 4);
            buffer.position(0).limit(buffer.capacity());
            for (int y = 0; y < resolution; ++y) {
                for (int x = 0; x < resolution; ++x) {
                    int color = image.getRGB(x, y);
                    int a = color >> 24 & 0xFF;
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color >> 0 & 0xFF;
                    buffer.put((byte)r);
                    buffer.put((byte)g);
                    buffer.put((byte)b);
                    buffer.put((byte)a);
                }
            }
            buffer.position(0);
            buffers[i] = buffer;
        }
        try {
            Display.setIcon((ByteBuffer[])buffers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setResizable(boolean resizable) {
        this.fullscreenHelper.setResizable();
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        JFrame frame = new JFrame();
        PanelCrashReport panel = new PanelCrashReport(this.mc, unexpectedThrowable, cause);
        panel.setPreferredSize(new Dimension(1280, 720));
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }
}

