/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.client.world.WorldBlockPositionType;
import net.minecraft.client.world.chunk.provider.ChunkProviderClient;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.packet.Packet255KickDisconnect;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pathfinder.IdHashMap;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveHandlerClientMP;

public class WorldClient
extends World {
    private Minecraft mc;
    private LinkedList field_1057_z;
    private NetClientHandler sendQueue;
    private ChunkProviderClient field_20915_C;
    private IdHashMap entityMap;
    private Set field_20914_E;
    private Set field_1053_F;

    public WorldClient(Minecraft minecraft, NetClientHandler netclienthandler, long seed, int dimensionId, int worldTypeId) {
        super((LevelStorage)new SaveHandlerClientMP(), "MpServer", Dimension.getDimensionList().get(dimensionId), Registries.WORLD_TYPES.getItemByNumericId(worldTypeId), seed);
        this.mc = minecraft;
        this.field_1057_z = new LinkedList();
        this.entityMap = new IdHashMap();
        this.field_20914_E = new HashSet();
        this.field_1053_F = new HashSet();
        this.sendQueue = netclienthandler;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
        this.savedDataStorage = netclienthandler.savedDataStorage;
    }

    @Override
    public void tick() {
        this.setWorldTime(this.getWorldTime() + 1L);
        int i = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f);
        if (i != this.skyDarken) {
            this.skyDarken = i;
            for (int j = 0; j < this.listeners.size(); ++j) {
                ((LevelListener)this.listeners.get(j)).allChanged();
            }
        }
        for (int k = 0; k < 10 && !this.field_1053_F.isEmpty(); ++k) {
            Entity entity = (Entity)this.field_1053_F.iterator().next();
            if (this.loadedEntityList.contains(entity)) continue;
            this.entityJoinedWorld(entity);
        }
        this.processPackets();
        for (int l = 0; l < this.field_1057_z.size(); ++l) {
            WorldBlockPositionType worldblockpositiontype = (WorldBlockPositionType)this.field_1057_z.get(l);
            if (--worldblockpositiontype.field_1206_d != 0) continue;
            super.setBlockAndMetadata(worldblockpositiontype.field_1202_a, worldblockpositiontype.field_1201_b, worldblockpositiontype.field_1207_c, worldblockpositiontype.field_1205_e, worldblockpositiontype.field_1204_f);
            super.markBlockNeedsUpdate(worldblockpositiontype.field_1202_a, worldblockpositiontype.field_1201_b, worldblockpositiontype.field_1207_c);
            this.field_1057_z.remove(l--);
        }
        if (this.getWorldTime() % 24000L == 0L) {
            for (LevelListener listener : this.listeners) {
                listener.allChanged();
            }
        }
    }

    public void processPackets() {
        this.sendQueue.processReadPackets();
    }

    public void func_711_c(int i, int j, int k, int l, int i1, int j1) {
        for (int k1 = 0; k1 < this.field_1057_z.size(); ++k1) {
            WorldBlockPositionType worldblockpositiontype = (WorldBlockPositionType)this.field_1057_z.get(k1);
            if (worldblockpositiontype.field_1202_a < i || worldblockpositiontype.field_1201_b < j || worldblockpositiontype.field_1207_c < k || worldblockpositiontype.field_1202_a > l || worldblockpositiontype.field_1201_b > i1 || worldblockpositiontype.field_1207_c > j1) continue;
            this.field_1057_z.remove(k1--);
        }
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        this.field_20915_C = new ChunkProviderClient(this);
        return this.field_20915_C;
    }

    @Override
    public void getRespawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(int i, int j, int k, int l, int i1) {
    }

    @Override
    public boolean tickUpdates(boolean flag) {
        return false;
    }

    public void doPreChunk(int i, int j, boolean flag) {
        if (flag) {
            this.field_20915_C.prepareChunk(i, j);
        } else {
            this.field_20915_C.func_539_c(i, j);
        }
        if (!flag) {
            this.markBlocksDirty(i * 16, 0, j * 16, i * 16 + 15, this.getHeightBlocks(), j * 16 + 15);
        }
    }

    @Override
    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        this.field_20914_E.add(entity);
        if (!flag) {
            this.field_1053_F.add(entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        this.field_20914_E.remove(entity);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (this.field_1053_F.contains(entity)) {
            this.field_1053_F.remove(entity);
        }
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.field_20914_E.contains(entity)) {
            this.field_1053_F.add(entity);
        }
    }

    public void addEntityToWorld(int i, Entity entity) {
        Entity entity1 = this.getEntityFromId(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.field_20914_E.add(entity);
        entity.id = i;
        if (!this.entityJoinedWorld(entity)) {
            this.field_1053_F.add(entity);
        }
        this.entityMap.add(i, entity);
    }

    public Entity getEntityFromId(int i) {
        return (Entity)this.entityMap.get(i);
    }

    public Entity removeEntityFromWorld(int i) {
        Entity entity = (Entity)this.entityMap.remove(i);
        if (entity != null) {
            this.field_20914_E.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    @Override
    public boolean setBlockMetadata(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockMetadata(i, j, k, l)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        int j1 = this.getBlockId(i, j, k);
        int k1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, j1, k1));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlock(i, j, k, l)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    public boolean func_714_c(int i, int j, int k, int l, int i1) {
        this.func_711_c(i, j, k, i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.func_28117_a(new Packet255KickDisconnect("Quitting"));
    }
}

