/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockLeavesCherry;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public class BlockLeavesCherryFlowering
extends BlockLeavesCherry
implements IBonemealable {
    public BlockLeavesCherryFlowering(String key, int id) {
        super(key, id);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        int growthRate = (meta & 0xF0) >> 4;
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        if (growthRate == 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Item.cherry, world.rand.nextInt(2) + 1)};
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.blockActivated(world, x, y, z, player);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        int decayData = meta & 0xF;
        int growthRate = (meta & 0xF0) >> 4;
        if (growthRate > 0) {
            world.playSoundAtEntity(player, player, "random.pop", 0.2f, 0.5f);
            if (!world.isClientSide) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null);
            }
            world.setBlockMetadataWithNotify(x, y, z, decayData);
            world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.id, this.tickRate());
            return true;
        }
        return super.blockActivated(world, x, y, z, player);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        int meta = world.getBlockMetadata(x, y, z);
        int growthRate = (meta & 0xF0) >> 4;
        if (world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            if (rand.nextInt(20) == 0 && growthRate == 0) {
                world.setBlockMetadataWithNotify(x, y, z, 0x10 | meta);
                world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.id, this.tickRate());
            }
        } else if (growthRate > 0) {
            world.setBlockMetadataWithNotify(x, y, z, meta & 0xF);
            world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.id, this.tickRate());
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int meta = world.getBlockMetadata(blockX, blockY, blockZ);
        if ((meta & 0xF0) >> 4 == 0) {
            if (!world.isClientSide) {
                if (world.getSeasonManager().getCurrentSeason() != Seasons.OVERWORLD_SPRING) {
                    return true;
                }
                world.setBlockMetadataWithNotify(blockX, blockY, blockZ, 0x10 | meta);
                if (entityplayer.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

