/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFlower;
import net.minecraft.core.world.World;

public class BlockMushroom
extends BlockFlower {
    public BlockMushroom(String key, int id) {
        super(key, id);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setTicking(true);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        int j1;
        int i1;
        int l;
        if (rand.nextInt(100) == 0 && world.isAirBlock(l = x + rand.nextInt(3) - 1, i1 = y + rand.nextInt(2) - rand.nextInt(2), j1 = z + rand.nextInt(3) - 1) && this.canBlockStay(world, l, i1, j1)) {
            x += rand.nextInt(3) - 1;
            z += rand.nextInt(3) - 1;
            if (world.isAirBlock(l, i1, j1) && this.canBlockStay(world, l, i1, j1)) {
                world.setBlockWithNotify(l, i1, j1, this.id);
            }
        }
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return Block.solid[i];
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        if (y < 0 || y >= world.getHeightBlocks()) {
            return false;
        }
        return world.getFullBlockLightValue(x, y, z) < 13 && this.canThisPlantGrowOnThisBlockID(world.getBlockId(x, y - 1, z));
    }
}

