/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.World;

public class BlockOreRedstone
extends Block {
    private boolean illuminated;
    private String keyNormal;
    private String keyIlluminated;

    public BlockOreRedstone(String key, int id, boolean illuminated, String normalKey, String illuminatedKey) {
        super(key, id, Material.stone);
        if (illuminated) {
            this.setTicking(true);
        }
        this.illuminated = illuminated;
        this.keyNormal = normalKey;
        this.keyIlluminated = illuminatedKey;
    }

    @Override
    public int tickRate() {
        return 30;
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.lightRedstone(world, x, y, z);
        super.onBlockClicked(world, x, y, z, player);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.lightRedstone(world, x, y, z);
        super.onEntityWalking(world, x, y, z, entity);
    }

    private void lightRedstone(World world, int i, int j, int k) {
        this.spawnParticles(world, i, j, k);
        if (!this.illuminated) {
            world.setBlockWithNotify(i, j, k, Block.getBlockByName((String)this.keyIlluminated).id);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            world.setBlockWithNotify(x, y, z, Block.getBlockByName((String)this.keyNormal).id);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(Block.getBlockByName(this.keyNormal))};
            }
            case EXPLOSION: 
            case PROPER_TOOL: {
                return new ItemStack[]{new ItemStack(Item.dustRedstone, 4 + world.rand.nextInt(2))};
            }
        }
        return null;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            this.spawnParticles(world, x, y, z);
        }
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.rand;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        double d = 0.0625;
        for (int i = 0; i < 3; ++i) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)(y + 0) - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)(z + 0) - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)(x + 0) - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, red, green, blue, 0);
        }
    }
}

